package com.xdja.multichip.process.tfcard;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/5/16 <br/>
 */
public class TfCardEventReceiver extends BroadcastReceiver {
    private static final String tag = TfCardEventReceiver.class.getSimpleName();

    @Override
    public void onReceive(Context context, Intent intent) {
        Log.v(tag, "xdjatfprocessService BroadcastReceiver");

        if(intent == null){
            Log.v("tag","TfCardEventReceiver intent null");
            return;
        }

        //注意：当TF卡卸载或移除（从卡槽拔出），某系统上（魅族）会杀死打开过TF的进程；
        //新增了Intent.ACTION_MEDIA_REMOVED广播类型，因为在TF快速插入，再拔出时，系统只发出了该类型广播
        //tf卡被弹出（正常卸载或者强制移除卡）
        if (Intent.ACTION_MEDIA_EJECT.equals(intent.getAction()) ||
                Intent.ACTION_MEDIA_REMOVED.equals(intent.getAction())) {
            Log.v(tag, "tf卡移除");
            //确定那个卡被移除，然后广播通知；信息列表
            TFJniApiHandle.getInstance().handleMediaRemoved(context.getApplicationContext());

        } else if (Intent.ACTION_MEDIA_MOUNTED.equals(intent.getAction())) {
            //tf卡被挂载
            Log.v(tag, "tf卡被挂载");
            TFJniApiHandle.getInstance().handleMediaMounted(context.getApplicationContext());
        }
    }
}
