package com.xdja.multichip.process;

import android.util.Log;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/**
 * 本类主要用于处理 不同的线程，在相同的时间段内 调用某个耗时操作，只执行一次的问题。<br>
 * 比如：线程A、B、C，分别在 时间 100， 110， 120 调用了一个方法fun，<br>
 * fun在A线程A调用时开始执行，执行的耗时是50，<br>
 * 最终线程A、B、C，只执行一次fun，并且A、B、C得到同一次fun执行的结果。<br>
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/6/16 <br/>
 */
public abstract class SuperThreadRun<T> {
    private static final String TAG = "ThreadRunTag";

    /**
     * 此方法是让子类具体实现耗时操作的方法
     *
     * @return
     */
    protected abstract T getRunResult();

    public static final ExecutorService service = Executors.newCachedThreadPool();

    /**
     * 此方法为调用方法
     *
     * @return
     */
    public T getResult() {
        final CountDownLatch latch = new CountDownLatch(1);
        final Object[] result = new Object[1];
        CallBack callBack = new CallBack() {
            @Override
            public void callBack(Object msg) {
                Log.e(TAG, "runFun callBack");
                result[0] = msg;
                latch.countDown();
            }
        };
        callBackList.add(callBack);
        Log.e(TAG, "runFun start.");
        runFun();
        try {
            latch.await(10000, TimeUnit.MILLISECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log.e(TAG, "runFun end.");
        return (T) result[0];
    }

    boolean runFunFlag = false;
    private static Object lockObject = new Object();

    private void runFun() {
        synchronized (lockObject) {
            if (runFunFlag) {
                Log.e(TAG, "runFun true return");
                return;
            }
            runFunFlag = true;
        }
        Future<T> submit = service.submit(new Callable<T>() {
            @Override
            public T call() {
                T result = getRunResult();
                runFunFlag = false;
                Log.e(TAG, "runFun getResult ");
                return result;
            }
        });
        try {
            final T result = submit.get();
            while (true) {
                final CallBack callBack = callBackList.poll();
                if (callBack == null) {
                    break;
                }
                service.submit(new Runnable() {
                    @Override
                    public void run() {
                        callBack.callBack(result);
                    }
                });
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private ConcurrentLinkedQueue<CallBack> callBackList = new ConcurrentLinkedQueue<>();

    interface CallBack<T> {
        /**
         * 回调
         *
         * @param msg
         */
        void callBack(T msg);
    }
}
