package com.xdja.multichip.process.bluetooth;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_DIR;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_KEY_ATTR;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.blesafekey.XDJABleAPI;
import com.xdja.multichip.jniapi.JarMultiJniApiErrorCode;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/13 <br/>
 */

public class JniApiBluetoothKey extends JNIAPI {

    /**
     * 不支持的方法
     */
    public static final int RET_NOT_SUPPORT_METHOD = JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;

    private XDJABleAPI blueApi = new XDJABleAPI();

    public XDJABleAPI getBlueApi(){
        return blueApi;
    }

    @Override
    public int GetVersion(byte[] verion, int[] ver_len) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int EnumDev(int devType, int[] devNum) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int OpenDev(int index, long[] hHandle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CloseDev(long handle) {
         blueApi.DisConnectService();
         return 0;
    }

    @Override
    public int LockDev(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int UnlockDev(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int Transmit(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen) {
        return blueApi.Transmit(cmd, cmdLen, dataOut, outLen);
    }

    @Override
    public int GetDevInfo(long handle, XDJA_DEVINFO devInfo) {
        return blueApi.GetDevInfo(devInfo);
    }

    @Override
    public int SetLogPath(byte[] logPath) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ActivateCard(long handle, byte[] param, int paramLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetActivateState(long handle) {
        return blueApi.GetActivateState();
    }

    @Override
    public int ChangePIN(long handle, int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen) {
        return blueApi.ChangePIN(pinRole, oldPin, oldLen, newPin, newLen);
    }

    @Override
    public int GetPinTryCount(long handle, int pinRole) {
        return blueApi.GetPinTryCount(pinRole);
    }

    @Override
    public int VerifyPIN(long handle, int pinRole, byte[] pin, int pinLen) {
        return blueApi.VerifyPIN(pinRole, pin, pinLen);
    }

    @Override
    public int UnlockPIN(long handle, int id, byte[] key, int keyLen, byte[] newPin, int newLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReloadPIN(long handle, int pinRole, byte[] key, int keyLen, byte[] newPin, int newLen) {
        return blueApi.ReloadPIN(pinRole,key,keyLen,newPin,newLen);
    }

    @Override
    public int CardReset(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ExternAuth(long handle, byte exterAuthID, byte[] encRandom) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int InterAuth(long handle, byte[] dataIn, int inLen, int flag, byte kID, byte[] tmpKey, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CreateDir(long handle, XDJA_DIR dir) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SelectFile(long handle, byte[] fid) {
        return blueApi.SelectFile(fid);
    }

    @Override
    public int DeleteFile(long handle, byte[] fid) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetDirSize(long handle, int[] size) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CreateFile(long handle, XDJA_FILE file) {
        return blueApi.CreateFile(file);
    }

    @Override
    public int GetFileInfo(long handle, byte[] fid, XDJA_FILE file) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReadFile(long handle, byte[] fid, int readPos, int readLen, byte[] dataOut) {
        return blueApi.ReadFile(fid, readPos, readLen, dataOut);
    }

    @Override
    public int WriteFile(long handle, byte[] fid, int writePos, int writeLen, byte[] dataIn) {
        return blueApi.WriteFile(fid, writePos, writeLen, dataIn);
    }

    @Override
    public int ReadRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        return blueApi.ReadRsaPubKey(pubfid, pubKey);
    }

    @Override
    public int WriteRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int WriteRsaPriKey(long handle, byte[] prifid, XDJA_RSA_PRIKEY priKey) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReadSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        return blueApi.ReadSm2PubKey(pubfid, pubKey);
    }

    @Override
    public int WriteSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int WriteSm2PriKey(long handle, byte[] prifid, XDJA_SM2_PRIKEY priKey) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReadCert(long handle, byte[] fid, byte[] certBuf, int[] certLen) {
        return blueApi.ReadCert(fid, certBuf, certLen);
    }

    @Override
    public int WriteCert(long handle, byte[] fid, byte[] certBuf, int certLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GenRandom(long handle, int len, byte[] random) {
        return blueApi.GenRandom(len, random);
    }

    @Override
    public int DESKEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int DES3KEY(long handle, byte[] tmpKey, int tmpkeyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int AESKEY(long handle, byte[] tmpKey, int keyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CreateKey(long handle, XDJA_KEY_ATTR keyAttr) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ImportKey(long handle, int type, byte[] dataIn, byte kID) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        return blueApi.SM1(dataIn, inLen, flag, dataOut, kID, IV);
    }

    @Override
    public int ImportTmpKey(long handle, byte[] tmpKey) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int TmpSM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ImportCipherKey(long handle, byte[] tmpKey, int alg) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int TmpCipher(long handle, byte[] dataIn, int inLen, int alg, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM1KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return blueApi.SM1KEY(tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    @Override
    public int SSF33(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM4KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM4KEYEx(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return blueApi.SM4KEYEx(tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    @Override
    public int SM6KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GenRSAKeyPair(long handle, int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pubkey, XDJA_RSA_PRIKEY prikey) {
        return blueApi.GenRSAKeyPair(bits, pubfid, prifid, pubkey, prikey);
    }

    @Override
    public int RSAPubKeyCalc(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return blueApi.RSAPubKeyCalc(pubfid, pubkey, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int RSAPriKeyCalc(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return blueApi.RSAPriKeyCalc(prifid, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int RSAPriKeyCalcEx(long handle, byte[] pin, int pinLen, int pinRole, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int RSASign(long handle, int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int RSASignVerify(long handle, int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int PackEnvelope(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int alg, byte[] dataOut, int[] outLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int UnpackEnvelope(long handle, byte[] prifid, int alg, byte[] dataIn, int inLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int KeyDisperse(long handle, int keyId, byte[] keyParam, int keyParamLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SetSM2Id(long handle, byte[] sm2Id, int inLen) {
        return blueApi.SetSM2Id(sm2Id, inLen);
    }

    @Override
    public int GetSM2Id(long handle, byte[] sm2Id, int[] outLen) {
        return blueApi.GetSM2Id(sm2Id, outLen);
    }

    @Override
    public int SetSM2Param(long handle, XDJA_SM2_PARAM param) {
        return blueApi.SetSM2Param(param);
    }

    @Override
    public int GetSM2Param(long handle, XDJA_SM2_PARAM param) {
        return blueApi.GetSM2Param(param);
    }

    @Override
    public int GenSM2KeyPair(long handle, byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey) {
        return blueApi.GenSM2KeyPair(pubfid, prifid, pubkey, prikey);
    }

    @Override
    public int SM2Encrypt(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return blueApi.SM2Encrypt(pubfid, pubkey, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int SM2EncryptGM(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM2Decrypt(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return blueApi.SM2Decrypt(prifid, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int SM2DecryptGM(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM2Sign(long handle, byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return blueApi.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int SM2SignVerify(long handle, byte[] pubfid, int dataType, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        return blueApi.SM2SignVerify(pubfid, dataType, pubkey, dataIn, inLen, signatureData);
    }

    @Override
    public int SM2SignEx(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] signatureData, int[] signatureDataLen) {
        return RET_NOT_SUPPORT_METHOD;
    }


    @Override
    public int SM2SignVerifyEx(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SHA1(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SHA1Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return blueApi.SHA1Ex(dataIn, inLen, dataOut);
    }

    @Override
    public int SM3(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return blueApi.SM3(dataIn, inLen, dataOut);
    }

    @Override
    public int SM3Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return blueApi.SM3Ex(dataIn, inLen, dataOut);
    }

    @Override
    public int SM2KeyGenInit(long handle, byte[] pubfid, byte[] dataOut, int[] outLen) {
        return blueApi.SM2KeyGenInit(pubfid, dataOut, outLen);
    }

    @Override
    public int SM2KeyGenCompute(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, byte dictFlag, byte keyFlag) {
        return blueApi.SM2KeyGenCompute(pubfid, prifid, dataIn, inLen, dataOut, outLen, dictFlag, keyFlag);
    }

    @Override
    public int SM2KeyGenVerify(long handle, byte[] dataIn, int inLen) {
        return blueApi.SM2KeyGenVerify(dataIn, inLen);
    }

    @Override
    public int GetUsbMountPath(long handle, int type, byte[] path) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SetUsbRWMode(long handle, int mode) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReadUsbNormalSecs(long handle, int addr, short secs, byte[] data) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int WriteUsbNormalSecs(long handle, int addr, short secs, byte[] data) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int OpenUsbSecuZone(long handle, byte[] pass, int passLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CloseUsbSecuZone(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ChgUsbSecuZonePin(long handle, byte[] oldPass, int oldLen, byte[] newPass, int newLen, int type) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int UnlockUsbSecuZone(long handle, byte[] key, int keyLen, byte[] pin, int pinLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int InitUsbHiddZone(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetUsbHiddZoneSize(long handle, int[] size) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReadUsbHiddZone(long handle, int addr, byte[] dataOut, int readLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int WriteUsbHiddZone(long handle, int addr, byte[] dataIn, int writeLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ExecUsbScsiCmd(long handle, byte[] CDBbuff, int cdbLength, byte[] sendDataBuf, int sendDataLen, byte[] recvDataBuf, int[] recvDataLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int If2gKey(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int gKeySign(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, int dataType) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetRemainPower(long handle, int[] power) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetTFMountPath(long handle, byte[] mountPath, int[] pathLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetTFZoneSize(long handle, int[] size) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReadTFZone(long handle, int sectorStart, byte[] dataBuf, int buffSize) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int WriteTFZone(long handle, int sectorStart, byte[] dataBuf, int buffSize) {
        return RET_NOT_SUPPORT_METHOD;
    }
}
