package com.xdja.multichip.process.vhsm.net;

import android.content.Context;
import android.os.Bundle;

import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/11/16 <br/>
 */
public class NetVhsmJniApiHandle {

    private static NetVhsmJniApiHandle instance;

    public static NetVhsmJniApiHandle getInstance() {
        if (instance == null) {
            synchronized (NetVhsmJniApiHandle.class) {
                if (instance == null) {
                    instance = new NetVhsmJniApiHandle();
                }
            }
        }
        return instance;
    }


    /**
     * 得到默认虚拟卡；
     *
     * @param context
     * @return
     */
    public Bundle getNetVhsm(Context context) {
        NetVhsmJniapiBinder binder = NetVhsmJniapiBinder.getInstance(context);
        Bundle bundle = convertToBundle(context, binder);
        return bundle;
    }


    private Bundle convertToBundle(Context context, NetVhsmJniapiBinder binder) {
        Bundle bundle = new Bundle();

        JniApiParam param = binder.getJniApiParam();
        if (param != null) {
            JarMultiChipStatusManager.getInstance().sendCardStatus(context, param.cardId, param.chipType, 1);

            bundle.putInt(ParamKeywords.KEY_int_ret, 0);
            bundle.putBinder(ParamKeywords.KEY_Binder_Binder, binder);
            bundle.putParcelable(ParamKeywords.KEY_Parcelable_JniApiParam, param);
            return bundle;
        }
        return null;
    }

}
