package com.xdja.multichip.process.vhsm.net;

import java.lang.reflect.Field;

/**
 * 将VHSM的Bean 和 JNIAPI中用的Bean相互转换
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2021/12/28 <br/>
 */
class VhsmBeanConvert {

    /**
     * 将
     *
     * @param src
     * @param tClass
     * @param <T>
     * @return
     */
    public static <T> T convertTo(Object src, Class<T> tClass) throws NoSuchFieldException, InstantiationException, IllegalAccessException {
        if (src == null) {
            return null;
        }
        T t = tClass.newInstance();

        Field[] fields = tClass.getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            field.set(t, src.getClass().getDeclaredField(field.getName()).get(src));
        }
        return t;

    }

    public static void convert(Object src, Object obj) throws NoSuchFieldException, IllegalAccessException {
        if (src == null || obj == null) {
            return;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        for (Field field : fields) {
            if (field.getName().equals("CREATOR")) {
                continue;
            }
            field.setAccessible(true);
            if (field.getType() == byte[].class) {
                byte[] objBytes = (byte[]) field.get(obj);
                byte[] srcBytes = (byte[]) src.getClass().getDeclaredField(field.getName()).get(src);
                int len = Math.min(objBytes.length, srcBytes.length);
                System.arraycopy(srcBytes, 0, objBytes, 0, len);
            } else {
                field.set(obj, src.getClass().getDeclaredField(field.getName()).get(src));
            }
        }
    }
}
