/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.anno.AutoWriteList;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.IChipForCall;
import com.xdja.multichip.process.board.OnboardChipForCall;
import com.xdja.multichip.process.coveredcard.CCChipForCall;
import com.xdja.multichip.process.tfcard.TFChipForCall;
import com.xdja.multichip.process.vhsm.net.NetVhsmChipForCall;
import com.xdja.multichip.utils.SharedPreferencesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class GetMultiJniApiBinder
extends IGetMultiJniApi.Stub {
    private static final String TAG = "GetMultiJniApiBinder";
    private static final int WAIT_TIMEOUT = 10;
    private static GetMultiJniApiBinder instance;
    private Context context;
    private ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    private long lastCall = 0L;
    @AutoWriteList
    private ArrayList<IChipForCall> chipForCallList = new ArrayList();
    List<Bundle> lastResult = new ArrayList<Bundle>();
    private static final String TAG_CHIPFORCALL = "chipForCall: ";
    private ActivityInfo[] activities;
    private ProviderInfo[] providers;
    private ActivityInfo[] receivers;
    private ServiceInfo[] services;
    private HashMap<String, List<String>> processClassMap = new HashMap(5);

    private GetMultiJniApiBinder(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        this.init(this.context);
    }

    private void init(Context context) {
        this.chipForCallList.clear();
        this.chipForCallList.add(new CCChipForCall());
        this.chipForCallList.add(new TFChipForCall());
        this.chipForCallList.add(new OnboardChipForCall());
        this.chipForCallList.add(new NetVhsmChipForCall());
        for (IChipForCall chipForCall : this.chipForCallList) {
            chipForCall.setContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GetMultiJniApiBinder getInstance(Context context) {
        if (instance != null) return instance;
        Class<GetMultiJniApiBinder> clazz = GetMultiJniApiBinder.class;
        synchronized (GetMultiJniApiBinder.class) {
            if (instance != null) return instance;
            instance = new GetMultiJniApiBinder(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        return super.onTransact(code, data, reply, flags);
    }

    public synchronized List<Bundle> getMultiJniApi() throws RemoteException {
        Log.w((String)TAG, (String)"getMultiJniApi start: ");
        long curCall = SystemClock.elapsedRealtime();
        if (curCall - this.lastCall < 1000L) {
            return this.lastResult;
        }
        this.lastResult.clear();
        this.lastResult.addAll(this.getJniApiBinder(this.chipForCallList));
        this.lastCall = SystemClock.elapsedRealtime();
        Log.w((String)TAG, (String)" getMultiJniApi end: ");
        this.saveJniApiParam(this.lastResult);
        return this.lastResult;
    }

    private ArrayList<Bundle> getJniApiBinder(ArrayList<IChipForCall> chipForCallList) {
        final ArrayList<Bundle> resultList = new ArrayList<Bundle>();
        final CountDownLatch latch = new CountDownLatch(chipForCallList.size());
        for (final IChipForCall chipForCall : chipForCallList) {
            this.cachedThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (!GetMultiJniApiBinder.this.judgeChipCanUse(chipForCall)) {
                            Log.e((String)GetMultiJniApiBinder.TAG, (String)(GetMultiJniApiBinder.TAG_CHIPFORCALL + chipForCall.getChipName() + " false"));
                            return;
                        }
                        Log.e((String)GetMultiJniApiBinder.TAG, (String)(GetMultiJniApiBinder.TAG_CHIPFORCALL + chipForCall.getChipName() + " true"));
                        List<Bundle> bundles = chipForCall.getJniApiBinder();
                        if (bundles == null) {
                            Log.e((String)GetMultiJniApiBinder.TAG, (String)(GetMultiJniApiBinder.TAG_CHIPFORCALL + chipForCall.getChipName() + " bundles = null"));
                            return;
                        }
                        Log.e((String)GetMultiJniApiBinder.TAG, (String)(GetMultiJniApiBinder.TAG_CHIPFORCALL + chipForCall.getChipName() + " bundles size:" + bundles.size()));
                        for (Bundle singleBundle : bundles) {
                            singleBundle.setClassLoader(JniApiParam.class.getClassLoader());
                            if (singleBundle.getParcelable("JniApiParam") == null) continue;
                            resultList.add(singleBundle);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public Bundle callMethod(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        if (bundle.containsKey("method")) {
            String method = bundle.getString("method");
            if ("makeByType".equals(method)) {
                return this.makeByType(bundle);
            }
            if ("setProvideCard".equals(method)) {
                return this.setSingleChipCanUse(bundle);
            }
            if ("getProvideCardFlag".equals(method)) {
                return this.getSingleChipCanUseFlag(bundle);
            }
            if ("SpiConfig".equals(method)) {
                return this.setChipSpiConfig(bundle);
            }
            if ("GetAllAsync".equals(method)) {
                return this.getAllAsync(bundle);
            }
            if ("CcSetLogFlag".equals(method)) {
                return this.handleCcSetLogFlag(bundle);
            }
        }
        Bundle result = new Bundle();
        result.putInt("ret", -10027);
        return result;
    }

    private Bundle makeByType(Bundle callBundle) {
        Bundle result = new Bundle();
        int cardType = callBundle.getInt("cardType");
        IChipForCall chipForCall = this.findChipForCallByCardType(cardType);
        ArrayList<Bundle> resultList = new ArrayList();
        if (chipForCall != null) {
            ArrayList<IChipForCall> list = new ArrayList<IChipForCall>();
            list.add(chipForCall);
            resultList = this.getJniApiBinder(list);
            this.saveJniApiParam(resultList);
        }
        result.putInt("ret", 0);
        result.putParcelableArrayList("BundleList", resultList);
        return result;
    }

    private Bundle setChipSpiConfig(Bundle bundle) {
        int chipType = bundle.getInt("spiconfig_support_chiptype", 1);
        IChipForCall iChipForCall = this.findChipForCallByCardType(chipType);
        if (iChipForCall == null) {
            Log.e((String)TAG, (String)("spiConfig find Chip ForCall fail By CardType " + chipType));
            return null;
        }
        return iChipForCall.callMethod("SpiConfig", "", bundle);
    }

    private IChipForCall findChipForCallByCardType(int cardType) {
        if (this.chipForCallList == null) {
            return null;
        }
        for (IChipForCall chipForCall : this.chipForCallList) {
            if (chipForCall.getChipType() != cardType) continue;
            return chipForCall;
        }
        return null;
    }

    private synchronized Bundle setSingleChipCanUse(Bundle bundle) {
        Bundle result = new Bundle();
        int uid = GetMultiJniApiBinder.getCallingUid();
        if (uid != Process.myUid()) {
            result.putInt("ret", -10028);
            return result;
        }
        String chipName = bundle.getString("chipName", "");
        String value = bundle.getString("value", "");
        if (TextUtils.isEmpty((CharSequence)chipName) || TextUtils.isEmpty((CharSequence)value)) {
            result.putInt("ret", -10000);
            return result;
        }
        MultiJniApiConfig.CanUseFlag flag = MultiJniApiConfig.CanUseFlag.ENABLE.name().equals(value) ? MultiJniApiConfig.CanUseFlag.ENABLE : (MultiJniApiConfig.CanUseFlag.UNABLE.name().equals(value) ? MultiJniApiConfig.CanUseFlag.UNABLE : MultiJniApiConfig.CanUseFlag.DEFAULTED);
        MultiJniApiConfig.getInstance(this.context).setChipCanUseFlag(chipName, flag);
        this.setChipStatus(chipName, flag);
        result.putInt("ret", 0);
        return result;
    }

    private Bundle getSingleChipCanUseFlag(Bundle bundle) {
        Bundle result = new Bundle();
        int uid = GetMultiJniApiBinder.getCallingUid();
        if (uid != Process.myUid()) {
            result.putInt("ret", -10028);
            return result;
        }
        String chipName = bundle.getString("chipName", "");
        boolean flag = MultiJniApiConfig.getInstance(this.context).judgeChipCanUse(chipName);
        result.putInt("ret", 0);
        result.putBoolean("flag", flag);
        result.putString("chipName", chipName);
        return result;
    }

    private Bundle getAllAsync(Bundle bundle) {
        Log.w((String)TAG, (String)"getAllAsync start: ");
        IBinder binder = bundle.getBinder("Binder");
        final Messenger messenger = new Messenger(binder);
        final CountDownLatch latch = new CountDownLatch(this.chipForCallList.size());
        for (final IChipForCall chipForCall : this.chipForCallList) {
            this.cachedThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block17: {
                        List<Bundle> bundles;
                        Bundle result;
                        block15: {
                            block16: {
                                block13: {
                                    block14: {
                                        result = null;
                                        try {
                                            if (GetMultiJniApiBinder.this.judgeChipCanUse(chipForCall)) break block13;
                                            Log.e((String)GetMultiJniApiBinder.TAG, (String)(GetMultiJniApiBinder.TAG_CHIPFORCALL + chipForCall.getChipName() + " false"));
                                            if (result == null) break block14;
                                        }
                                        catch (Throwable throwable) {
                                            if (result != null) {
                                                Message msg = Message.obtain();
                                                msg.what = 1;
                                                msg.obj = result;
                                                try {
                                                    messenger.send(msg);
                                                }
                                                catch (RemoteException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            latch.countDown();
                                            throw throwable;
                                        }
                                        Message msg = Message.obtain();
                                        msg.what = 1;
                                        msg.obj = result;
                                        try {
                                            messenger.send(msg);
                                        }
                                        catch (RemoteException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    latch.countDown();
                                    return;
                                }
                                Log.e((String)GetMultiJniApiBinder.TAG, (String)(GetMultiJniApiBinder.TAG_CHIPFORCALL + chipForCall.getChipName() + " true"));
                                bundles = chipForCall.getJniApiBinder();
                                if (bundles != null && bundles.size() != 0) break block15;
                                Log.e((String)GetMultiJniApiBinder.TAG, (String)(GetMultiJniApiBinder.TAG_CHIPFORCALL + chipForCall.getChipName() + " bundles = null"));
                                if (result == null) break block16;
                                Message msg = Message.obtain();
                                msg.what = 1;
                                msg.obj = result;
                                try {
                                    messenger.send(msg);
                                }
                                catch (RemoteException e) {
                                    e.printStackTrace();
                                }
                            }
                            latch.countDown();
                            return;
                        }
                        Log.e((String)GetMultiJniApiBinder.TAG, (String)(GetMultiJniApiBinder.TAG_CHIPFORCALL + chipForCall.getChipName() + " bundles size:" + bundles.size()));
                        result = bundles.get(0);
                        if (result == null) break block17;
                        Message msg = Message.obtain();
                        msg.what = 1;
                        msg.obj = result;
                        try {
                            messenger.send(msg);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                    latch.countDown();
                }
            });
        }
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                    Message msg = Message.obtain();
                    msg.what = 2;
                    messenger.send(msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Log.w((String)TAG, (String)" getAllAsync end: ");
        Bundle result = new Bundle();
        result.putInt("ret", 0);
        return result;
    }

    private void saveJniApiParam(List<Bundle> list) {
        final ArrayList<Bundle> saveList = new ArrayList<Bundle>();
        saveList.addAll(list);
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                for (Bundle bundle : saveList) {
                    JniApiParam param = (JniApiParam)bundle.getParcelable("JniApiParam");
                    if (param == null) continue;
                    SharedPreferencesUtil.saveCardIdAndType(GetMultiJniApiBinder.this.context, param.cardId, param.chipType);
                }
            }
        });
    }

    private List<String> getClassInProcessList(String processName) {
        List<String> processClassList = this.processClassMap.get(processName);
        if (processClassList != null) {
            return processClassList;
        }
        List<String> classInProcessListBySearch = this.getClassInProcessListBySearch(processName);
        this.processClassMap.put(processName, classInProcessListBySearch);
        return classInProcessListBySearch;
    }

    private List<String> getClassInProcessListBySearch(String processName) {
        PackageManager pm = this.context.getPackageManager();
        ArrayList<String> result = new ArrayList<String>();
        try {
            String pkgName = this.context.getPackageName();
            processName = pkgName + ":" + processName;
            this.searchForActivity(processName, pm, result);
            this.searchForProvider(processName, pm, result);
            this.searchForReceiver(processName, pm, result);
            this.searchForService(processName, pm, result);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void searchForService(String processName, PackageManager pm, ArrayList<String> result) throws PackageManager.NameNotFoundException {
        if (this.services == null) {
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 516);
            for (ServiceInfo info : this.services = pi.services) {
                if (!info.processName.equals(processName)) continue;
                result.add(info.name);
            }
        }
    }

    private void searchForReceiver(String processName, PackageManager pm, ArrayList<String> result) throws PackageManager.NameNotFoundException {
        if (this.receivers == null) {
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 514);
            for (ActivityInfo info : this.receivers = pi.receivers) {
                if (!info.processName.equals(processName)) continue;
                result.add(info.name);
            }
        }
    }

    private void searchForProvider(String processName, PackageManager pm, ArrayList<String> result) throws PackageManager.NameNotFoundException {
        if (this.providers == null) {
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 520);
            for (ProviderInfo info : this.providers = pi.providers) {
                if (!info.processName.equals(processName)) continue;
                result.add(info.name);
            }
        }
    }

    private void searchForActivity(String processName, PackageManager pm, ArrayList<String> result) throws PackageManager.NameNotFoundException {
        if (this.activities == null) {
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 513);
            for (ActivityInfo info : this.activities = pi.activities) {
                if (!info.processName.equals(processName)) continue;
                result.add(info.name);
            }
        }
    }

    private void setChipStatus(String chipName, MultiJniApiConfig.CanUseFlag flag) {
        List<String> classInProcessList = this.getClassInProcessList(chipName);
        PackageManager pm = this.context.getPackageManager();
        int setFlag = 1;
        if (flag == MultiJniApiConfig.CanUseFlag.ENABLE) {
            setFlag = 1;
        } else if (flag == MultiJniApiConfig.CanUseFlag.UNABLE) {
            setFlag = 2;
        } else if (flag == MultiJniApiConfig.CanUseFlag.DEFAULTED) {
            boolean b = MultiJniApiConfig.getInstance(this.context).judgeStateFromProperties(chipName);
            setFlag = b ? 1 : 2;
        }
        for (String process : classInProcessList) {
            ComponentName cn = new ComponentName(this.context, process);
            pm.setComponentEnabledSetting(cn, setFlag, 1);
        }
    }

    private boolean judgeChipCanUse(IChipForCall chipForCall) {
        boolean flag = MultiJniApiConfig.getInstance(this.context).judgeChipCanUse(chipForCall.getChipName());
        return flag;
    }

    private ArrayList<IChipForCall> getChipForCallList() {
        return this.chipForCallList;
    }

    private Bundle handleCcSetLogFlag(Bundle bundle) {
        CCChipForCall ccChipForCall = new CCChipForCall();
        ccChipForCall.setContext(this.context);
        String method = bundle.getString("method");
        return ccChipForCall.callMethod(method, "", bundle);
    }
}

