/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process;

import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.multichip.process.SuperJniApiBinder;
import com.xdja.multichip.process.Util;
import java.nio.ByteBuffer;

public class SuperHandleContainer {
    public static final String TAG = SuperHandleContainer.class.getSimpleName();

    public int createContainer(SuperJniApiBinder binder, int ctnId, String ctnName) throws RemoteException {
        byte fid;
        if (TextUtils.isEmpty((CharSequence)ctnName)) {
            ctnName = "content " + ctnId;
        }
        int ret = 0;
        byte[] ctnListFid = new byte[]{0, 3};
        byte[] ctnNameFid = new byte[]{0, 0};
        XDJA_FILE file = new XDJA_FILE();
        file.id = new byte[2];
        ctnNameFid[1] = fid = (byte)(40 + ctnId * 7);
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = (short)256;
        file.read_Acl = (byte)-16;
        file.write_Acl = (byte)this.convertPermission(ctnId);
        file.type = 1;
        ret = binder.CreateFile(binder.mHandle, file);
        if (0 != ret && -23 != ret) {
            Log.e((String)TAG, (String)("[erro] CreateContainer Create Container name File failed r=" + ret));
            return ret;
        }
        XDJA_DEVINFO dev = new XDJA_DEVINFO();
        ret = binder.GetDevInfo(binder.mHandle, dev);
        if (0 != ret) {
            Log.e((String)TAG, (String)("[erro] CreateContainer GetDevInfo File failed r=" + ret));
            return ret;
        }
        byte[] info = new byte[32];
        int[] len = new int[1];
        Util.Str2Byte(new String(dev.cardid, 0, 32), info, len);
        long t = System.currentTimeMillis();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(0, t);
        System.arraycopy(buffer.array(), 2, info, 18, 4);
        info[14] = (byte)(info[14] ^ info[18]);
        info[15] = (byte)(info[14] ^ info[19]);
        info[16] = (byte)(info[14] ^ info[20]);
        info[17] = (byte)(info[14] ^ info[21]);
        String name = Util.Byte2Str(info, 0, 18);
        info[0] = (byte)(ctnName.length() * 2);
        byte[] namearray = ctnName.getBytes();
        int j = 0;
        int i = 0;
        do {
            info[1 + i] = 0 == i % 2 ? namearray[j++] : (byte)0;
            ++i;
        } while (ctnName.length() != j);
        byte[] value = new byte[37 + ctnName.length() * 2];
        len[0] = name.length();
        System.arraycopy(name.getBytes(), 0, value, 0, len[0]);
        System.arraycopy(info, 0, value, len[0], ctnName.length() * 2 + 1);
        len[0] = len[0] + (ctnName.length() * 2 + 1);
        ret = binder.WriteFile(binder.mHandle, ctnNameFid, 0, len[0], value);
        if (0 != ret) {
            Log.e((String)TAG, (String)("[erro] CreateContainer Write Container name failed r=" + ret));
            return ret;
        }
        ret = this.createExchangeCertFile(binder, ctnId, fid = (byte)(fid + 1), file);
        if (ret != 0) {
            return ret;
        }
        ret = this.createExchangePubFile(binder, ctnId, fid = (byte)(fid + 1), file);
        if (ret != 0) {
            return ret;
        }
        ret = this.createExchangePriFile(binder, ctnId, fid = (byte)(fid + 1), file);
        if (ret != 0) {
            return ret;
        }
        ret = this.createSignCertFile(binder, ctnId, fid = (byte)(fid + 1), file);
        if (ret != 0) {
            return ret;
        }
        ret = this.createSignPubFile(binder, ctnId, fid = (byte)(fid + 1), file);
        if (ret != 0) {
            return ret;
        }
        ret = this.createSignPriFile(binder, ctnId, fid = (byte)(fid + 1), file);
        if (ret != 0) {
            return ret;
        }
        info[0] = 0;
        info[1] = ctnNameFid[1];
        info[2] = 0;
        info[3] = 36;
        info[4] = 64;
        ret = binder.WriteFile(binder.mHandle, ctnListFid, ctnId * 5, 5, info);
        if (0 != ret) {
            Log.e((String)TAG, (String)("[erro] CreateContainer Update Container info failed r=" + ret));
            return ret;
        }
        return 0;
    }

    private int createSignPriFile(SuperJniApiBinder binder, int ctnId, byte fid, XDJA_FILE file) throws RemoteException {
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = (short)1024;
        file.use_Acl = (byte)this.convertPermission(ctnId);
        file.read_Acl = (byte)15;
        file.write_Acl = (byte)this.convertPermission(ctnId);
        file.type = (byte)3;
        int ret = binder.CreateFile(binder.mHandle, file);
        if (0 != ret && -23 != ret) {
            Log.e((String)TAG, (String)("[erro] CreateContainer Create signature pirvate File failed r=" + ret));
            return ret;
        }
        return 0;
    }

    private int createSignPubFile(SuperJniApiBinder binder, int ctnId, byte fid, XDJA_FILE file) throws RemoteException {
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = (short)512;
        file.use_Acl = (byte)-16;
        file.read_Acl = (byte)-16;
        file.write_Acl = (byte)this.convertPermission(ctnId);
        file.type = (byte)2;
        int ret = binder.CreateFile(binder.mHandle, file);
        if (0 != ret && -23 != ret) {
            Log.e((String)TAG, (String)("[erro] CreateContainer Create signature public File failed r=" + ret));
            return ret;
        }
        return 0;
    }

    private int createSignCertFile(SuperJniApiBinder binder, int ctnId, byte fid, XDJA_FILE file) throws RemoteException {
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = (short)1536;
        file.read_Acl = (byte)-16;
        file.write_Acl = (byte)this.convertPermission(ctnId);
        file.type = 1;
        int ret = binder.CreateFile(binder.mHandle, file);
        if (0 != ret && -23 != ret) {
            Log.e((String)TAG, (String)("[erro] CreateContainer Create signature cert File failed r=" + ret));
            return ret;
        }
        return 0;
    }

    private int createExchangePriFile(SuperJniApiBinder binder, int ctnId, byte fid, XDJA_FILE file) throws RemoteException {
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = (short)1024;
        file.use_Acl = (byte)this.convertPermission(ctnId);
        file.read_Acl = (byte)15;
        file.write_Acl = (byte)this.convertPermission(ctnId);
        file.type = (byte)3;
        int ret = binder.CreateFile(binder.mHandle, file);
        if (0 != ret && -23 != ret) {
            Log.e((String)TAG, (String)("[erro] CreateContainer Create exchange pirvate File failed r=" + ret));
            return ret;
        }
        return 0;
    }

    private int createExchangePubFile(SuperJniApiBinder binder, int ctnId, byte fid, XDJA_FILE file) throws RemoteException {
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = (short)512;
        file.use_Acl = (byte)-16;
        file.read_Acl = (byte)-16;
        file.write_Acl = (byte)this.convertPermission(ctnId);
        file.type = (byte)2;
        int ret = binder.CreateFile(binder.mHandle, file);
        if (0 != ret && -23 != ret) {
            Log.e((String)TAG, (String)("[erro] CreateContainer Create exchange public File failed r=" + ret));
            return ret;
        }
        return 0;
    }

    private int createExchangeCertFile(SuperJniApiBinder binder, int ctnId, byte fid, XDJA_FILE file) throws RemoteException {
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = (short)1536;
        file.read_Acl = (byte)-16;
        file.write_Acl = (byte)this.convertPermission(ctnId);
        file.type = 1;
        int ret = binder.CreateFile(binder.mHandle, file);
        if (0 != ret && -23 != ret) {
            Log.e((String)TAG, (String)("[erro] CreateContainer Create exchange cert File failed r=" + ret));
            return ret;
        }
        return 0;
    }

    public int updateContainer(SuperJniApiBinder binder, int ctnId, int alg, int type) throws RemoteException {
        byte[] ctnListFid = new byte[]{0, 3};
        byte[] info = new byte[5];
        int r = binder.ReadFile(binder.mHandle, ctnListFid, ctnId * 5, 5, info);
        if (0 != r) {
            Log.e((String)TAG, (String)("[erro] updateContainer Read Container info failed r=" + r));
            return r;
        }
        if (0 == alg) {
            info[4] = this.changeBitTo0(info[4], 7);
        } else if (1 == alg) {
            info[4] = this.changeBitTo1(info[4], 7);
        } else {
            return -12;
        }
        if (0 == type) {
            info[4] = this.changeBitTo1(info[4], 3);
            info[4] = this.changeBitTo1(info[4], 4);
            info[4] = this.changeBitTo1(info[4], 5);
            info[4] = this.changeBitTo0(info[4], 0);
            info[4] = this.changeBitTo0(info[4], 1);
            info[4] = this.changeBitTo0(info[4], 2);
        } else if (1 == type) {
            info[4] = this.changeBitTo1(info[4], 0);
            info[4] = this.changeBitTo1(info[4], 1);
            info[4] = this.changeBitTo1(info[4], 2);
            info[4] = this.changeBitTo0(info[4], 3);
            info[4] = this.changeBitTo0(info[4], 4);
            info[4] = this.changeBitTo0(info[4], 5);
        } else if (2 == type) {
            info[4] = this.changeBitTo1(info[4], 0);
            info[4] = this.changeBitTo1(info[4], 1);
            info[4] = this.changeBitTo1(info[4], 2);
            info[4] = this.changeBitTo1(info[4], 3);
            info[4] = this.changeBitTo1(info[4], 4);
            info[4] = this.changeBitTo1(info[4], 5);
        } else {
            return -12;
        }
        r = binder.WriteFile(binder.mHandle, ctnListFid, ctnId * 5, 5, info);
        if (0 != r) {
            Log.e((String)TAG, (String)("[erro] updateContainer Write Container info failed r=" + r));
            return r;
        }
        return 0;
    }

    private int convertPermission(int containerId) {
        if (containerId == 4 || containerId == 6) {
            return 68;
        }
        return 17;
    }

    private byte changeBitTo0(byte b, int pos) {
        byte ret = (byte)(b & 255 - (byte)Math.pow(2.0, pos));
        return ret;
    }

    private byte changeBitTo1(byte b, int pos) {
        byte ret = (byte)(b | (byte)Math.pow(2.0, pos));
        return ret;
    }
}

