/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.board;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.board.OnboardJniApiBinder;
import java.util.ArrayList;

public class OnboardJniApiHandle {
    private static OnboardJniApiHandle instance;

    private OnboardJniApiHandle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OnboardJniApiHandle getInstance() {
        if (instance != null) return instance;
        Class<OnboardJniApiHandle> clazz = OnboardJniApiHandle.class;
        synchronized (OnboardJniApiHandle.class) {
            if (instance != null) return instance;
            instance = new OnboardJniApiHandle();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ArrayList<Bundle> getAllJniApiParams(Context context) {
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        boolean flag = MultiJniApiConfig.getInstance(context).judgeChipCanUse("onboardchip");
        if (!flag) {
            return list;
        }
        OnboardJniApiBinder binder = OnboardJniApiBinder.getInstance(context);
        JniApiParam param = binder.getJniApiParam();
        if (param != null) {
            this.sendCardStatus(context, param);
            Bundle bundle = new Bundle();
            bundle.putBinder("Binder", (IBinder)binder);
            bundle.putParcelable("JniApiParam", (Parcelable)param);
            list.add(bundle);
        }
        return list;
    }

    public Bundle spiConfig(Context context, Bundle configBundle) {
        if (configBundle == null) {
            return null;
        }
        int int0 = configBundle.getInt("int0");
        int int1 = configBundle.getInt("int1");
        int por = configBundle.getInt("por");
        int power = configBundle.getInt("power");
        int qwk = configBundle.getInt("qwk");
        int speed = configBundle.getInt("speed");
        Bundle result = new Bundle();
        int ret = OnboardJniApiBinder.getInstance(context).SpiConfig(int0, int1, por, power, qwk, speed);
        result.putInt("spiconfig_ret", ret);
        return result;
    }

    private void sendCardStatus(Context context, JniApiParam param) {
        if (param == null) {
            return;
        }
        JarMultiChipStatusManager.getInstance().sendCardStatus(context, param.cardId, param.chipType, 1);
    }
}

