/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.board;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import com.xdja.multichip.CallBackInfo;
import com.xdja.multichip.ISkfChip;
import com.xdja.multichip.param.ChipParam;
import com.xdja.multichip.process.IChipParamChangeListener;
import com.xdja.multichip.process.SupperChipBinder;
import com.xdja.multichip.process.board.OnboardDoubleSystemChipBinder;
import com.xdja.multichip.process.board.XdjaBinderManager;
import java.util.ArrayList;

public class OnboardHandle
implements IChipParamChangeListener {
    private ArrayList<IBinder> chipParamChangeBinderList = new ArrayList();
    private static OnboardHandle instance;

    private OnboardHandle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OnboardHandle getInstance() {
        if (instance != null) return instance;
        Class<OnboardHandle> clazz = OnboardHandle.class;
        synchronized (OnboardHandle.class) {
            if (instance != null) return instance;
            instance = new OnboardHandle();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int handleOnStartCommand(Context context, Intent intent, int flags, int startId) {
        if (intent != null) {
            this.actionHandle(context, intent);
        }
        return 0;
    }

    private void actionHandle(Context context, Intent intent) {
        String actionValue = intent.getAction();
        if (actionValue.equals("getChipInfo")) {
            this.actionGetChipInfoHandle(context, intent);
        }
    }

    private void actionGetChipInfoHandle(Context context, Intent intent) {
        String latchTag = intent.getStringExtra("latchTag");
        Bundle bundle = intent.getBundleExtra("bundle");
        IBinder binder = bundle.getBinder("binder");
        try {
            CallBackInfo.Stub.asInterface((IBinder)binder).callBack(latchTag, OnboardHandle.class.getName(), this.getAllChipParams(context));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void handleChipBinder(Context context) {
        if (this.chipParamChangeBinderList.size() > 0) {
            return;
        }
        if (OnboardDoubleSystemChipBinder.judgeConnectSystemService(context)) {
            this.chipParamChangeBinderList.add((IBinder)OnboardDoubleSystemChipBinder.getInstance(context));
        } else {
            this.chipParamChangeBinderList.addAll(XdjaBinderManager.getInstance(context).getAllXdjaChipBinder());
        }
        int size = this.chipParamChangeBinderList.size();
        if (size == 0) {
            return;
        }
        for (IBinder iBinder : this.chipParamChangeBinderList) {
            ((SupperChipBinder)iBinder).regist(this);
        }
    }

    public ArrayList<Bundle> getAllChipParams(Context context) throws RemoteException {
        this.handleChipBinder(context);
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (this.chipParamChangeBinderList.size() > 0) {
            for (IBinder binder : this.chipParamChangeBinderList) {
                ISkfChip skfChip = (ISkfChip)binder;
                Bundle bundle = new Bundle();
                bundle.putBinder("Binder", binder);
                bundle.putParcelable("ChipParam", (Parcelable)skfChip.getChipParam());
                bundles.add(bundle);
            }
        }
        return bundles;
    }

    @Override
    public void change(ChipParam chipParam) {
        int i = 0;
        while (i < this.chipParamChangeBinderList.size()) {
            IBinder binder = this.chipParamChangeBinderList.get(i);
            if (binder != null) {
                try {
                    CallBackInfo.Stub.asInterface((IBinder)binder).chipParamChange(OnboardHandle.class.getName(), binder, chipParam);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                ++i;
                continue;
            }
            this.chipParamChangeBinderList.remove(binder);
        }
    }
}

