/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.board;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.AccessControlManager;
import com.xdja.multichip.InsideMultiChipUnitePinManager;
import com.xdja.multichip.JNIPinManager;
import com.xdja.multichip.param.ChipParam;
import com.xdja.multichip.process.IChipParamChangeListener;
import com.xdja.multichip.process.board.OnboardChipBinder;
import com.xdja.skfapi.BlockCipherParam;
import com.xdja.skfapi.DevInfo;
import com.xdja.skfapi.EccCipherBlob;
import com.xdja.skfapi.EccPrivateKeyBlob;
import com.xdja.skfapi.EccPublicKeyBlob;
import com.xdja.skfapi.EccSignatureBlob;
import com.xdja.skfapi.EnvelopedKeyBlob;
import com.xdja.skfapi.FileAttribute;
import com.xdja.skfapi.RsaPrivateKeyBlob;
import com.xdja.skfapi.RsaPublicKeyBlob;
import com.xdja.skfapi.SkfApi;

public class OnboardXdjaChipBinder
extends OnboardChipBinder {
    private static SkfApi skfApi = new SkfApi();
    private static final String tag = "OnboardXdjaChipBinder";
    private long[] phDdev = new long[1];

    protected OnboardXdjaChipBinder(Context context, String dev) {
        super(context, dev);
    }

    public ChipParam getChipParam() throws RemoteException {
        DevInfo devinfo = new DevInfo();
        int ret = this.GetDevInfo(this.phDdev[0], devinfo);
        if (ret == 0) {
            ChipParam chipParam = new ChipParam();
            chipParam.chipType = 1;
            chipParam.manufacturer = "xdja";
            chipParam.uniqueID = new String(devinfo.serialNumber);
            return chipParam;
        }
        return null;
    }

    public int WaitForDevEvent(byte[] szDevName, int[] pulDevNameLen, int[] pulEvent) throws RemoteException {
        return skfApi.WaitForDevEvent(this.devName, pulDevNameLen, pulEvent);
    }

    public int CancelWaitForDevEvent() throws RemoteException {
        return skfApi.CancelWaitForDevEvent();
    }

    public int EnumDev(int bPresent, byte[] szNameList, int[] pulSize) throws RemoteException {
        return skfApi.EnumDev(bPresent, szNameList, pulSize);
    }

    public int ConnectDev(byte[] szName, long[] phDdev) throws RemoteException {
        return skfApi.ConnectDev(this.devName, this.phDdev);
    }

    public int DisConnectDev(long hDev) throws RemoteException {
        return skfApi.DisConnectDev(this.phDdev[0]);
    }

    public int GetDevState(byte[] szDevName, int[] pulDevState) throws RemoteException {
        return skfApi.GetDevState(this.devName, pulDevState);
    }

    public int SetLabel(long hDev, byte[] szLabel) throws RemoteException {
        int ret = skfApi.SetLabel(this.phDdev[0], szLabel);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.SetLabel(this.phDdev[0], szLabel);
        }
        return ret;
    }

    public int GetDevInfo(long hDev, DevInfo pDevInfo) throws RemoteException {
        int ret = skfApi.GetDevInfo(this.phDdev[0], pDevInfo);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.GetDevInfo(this.phDdev[0], pDevInfo);
        }
        return ret;
    }

    public int LockDev(long hDev, int ulTimeOut) throws RemoteException {
        int ret = skfApi.LockDev(this.phDdev[0], ulTimeOut);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.LockDev(this.phDdev[0], ulTimeOut);
        }
        return ret;
    }

    public int UnlockDev(long hDev) throws RemoteException {
        return skfApi.UnlockDev(this.phDdev[0]);
    }

    public int Transmit(long hDev, byte[] pbCommand, int ulCommandLen, byte[] pbData, int[] pulDataLen) throws RemoteException {
        int ret = skfApi.Transmit(this.phDdev[0], pbCommand, ulCommandLen, pbData, pulDataLen);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.Transmit(this.phDdev[0], pbCommand, ulCommandLen, pbData, pulDataLen);
        }
        return ret;
    }

    public int ChangeDevAuthKey(long hDev, byte[] pbKeyValue, int ulKeyLen) throws RemoteException {
        int ret = skfApi.ChangeDevAuthKey(this.phDdev[0], pbKeyValue, ulKeyLen);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.ChangeDevAuthKey(this.phDdev[0], pbKeyValue, ulKeyLen);
        }
        return ret;
    }

    public int DevAuth(long hDev, byte[] pbAuthData, int ulLen) throws RemoteException {
        int ret = skfApi.DevAuth(this.phDdev[0], pbAuthData, ulLen);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.DevAuth(this.phDdev[0], pbAuthData, ulLen);
        }
        return ret;
    }

    public int ChangePIN(long hApplication, int ulPINType, byte[] szOldPin, byte[] szNewPin, int[] pulRetryCount) throws RemoteException {
        int ret = AccessControlManager.getInstance(this.context).checkByUidPid(OnboardXdjaChipBinder.getCallingUid(), OnboardXdjaChipBinder.getCallingPid(), "ChangePIN");
        if (ret != 0) {
            return -101;
        }
        ret = skfApi.ChangePIN(hApplication, ulPINType, szOldPin, szNewPin, pulRetryCount);
        this.callUnitePin(ret, ulPINType, szNewPin, "ChangePIN");
        return ret;
    }

    public int GetPINInfo(long hApplication, int ulPINType, int[] pulMaxRetryCount, int[] pulRemainRetryCount, int[] pbDefaultPin) throws RemoteException {
        return skfApi.GetPINInfo(hApplication, ulPINType, pulMaxRetryCount, pulRemainRetryCount, pbDefaultPin);
    }

    public int VerifyPIN(long hApplication, int ulPINType, byte[] szPIN, int[] pulRetryCount) throws RemoteException {
        int ret = AccessControlManager.getInstance(this.context).checkByUidPid(OnboardXdjaChipBinder.getCallingUid(), OnboardXdjaChipBinder.getCallingPid(), "VerifyPIN");
        if (ret != 0) {
            return -101;
        }
        ret = skfApi.VerifyPIN(hApplication, ulPINType, szPIN, pulRetryCount);
        this.callUnitePin(ret, ulPINType, szPIN, "VerifyPIN");
        return ret;
    }

    public int UnblockPIN(long hApplication, byte[] szAdminPIN, byte[] szNewUserPIN, int[] pulRetryCount) throws RemoteException {
        int ret = AccessControlManager.getInstance(this.context).checkByUidPid(OnboardXdjaChipBinder.getCallingUid(), OnboardXdjaChipBinder.getCallingPid(), "UnblockPIN");
        if (ret != 0) {
            return -101;
        }
        ret = skfApi.UnblockPIN(hApplication, szAdminPIN, szNewUserPIN, pulRetryCount);
        this.callUnitePin(ret, 1, szNewUserPIN, "UnblockPIN");
        return ret;
    }

    public int ClearSecureState(long hApplication) throws RemoteException {
        return skfApi.ClearSecureState(hApplication);
    }

    public int CreateApplication(long hDev, byte[] szAppName, byte[] szAdminPin, int dwAdminPinRetryCount, byte[] szUserPin, int dwUserPinRetryCount, int dwCreateFileRights, long[] phApplication) throws RemoteException {
        int ret = skfApi.CreateApplication(this.phDdev[0], szAppName, szAdminPin, dwAdminPinRetryCount, szUserPin, dwUserPinRetryCount, dwCreateFileRights, phApplication);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.CreateApplication(this.phDdev[0], szAppName, szAdminPin, dwAdminPinRetryCount, szUserPin, dwUserPinRetryCount, dwCreateFileRights, phApplication);
        }
        return ret;
    }

    public int EnumApplication(long hDev, byte[] szAppName, int[] pulSize) throws RemoteException {
        int ret = skfApi.EnumApplication(this.phDdev[0], szAppName, pulSize);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.EnumApplication(this.phDdev[0], szAppName, pulSize);
        }
        return ret;
    }

    public int DeleteApplication(long hDev, byte[] szAppName) throws RemoteException {
        int ret = skfApi.DeleteApplication(this.phDdev[0], szAppName);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.DeleteApplication(this.phDdev[0], szAppName);
        }
        return ret;
    }

    public int OpenApplication(long hDev, byte[] szAppName, long[] phApplication) throws RemoteException {
        int ret = skfApi.OpenApplication(this.phDdev[0], szAppName, phApplication);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.OpenApplication(this.phDdev[0], szAppName, phApplication);
        }
        return ret;
    }

    public int CloseApplication(long hApplication) throws RemoteException {
        return skfApi.CloseApplication(hApplication);
    }

    public int CreateFile(long hApplication, byte[] szFileName, int ulFileSize, int ulReadRights, int ulWriteRights) throws RemoteException {
        return skfApi.CreateFile(hApplication, szFileName, ulFileSize, ulReadRights, ulWriteRights);
    }

    public int DeleteFile(long hApplication, byte[] szFileName) throws RemoteException {
        return skfApi.DeleteFile(hApplication, szFileName);
    }

    public int EnumFiles(long hApplication, byte[] szFileList, int[] pulSize) throws RemoteException {
        return skfApi.EnumFiles(hApplication, szFileList, pulSize);
    }

    public int GetFileInfo(long hApplication, byte[] szFileName, FileAttribute pFileInfo) throws RemoteException {
        return skfApi.GetFileInfo(hApplication, szFileName, pFileInfo);
    }

    public int ReadFile(long hApplication, byte[] szFileName, int ulOfffset, int ulSize, byte[] pbOutData, int[] pulOutLen) throws RemoteException {
        return skfApi.ReadFile(hApplication, szFileName, ulOfffset, ulSize, pbOutData, pulOutLen);
    }

    public int WriteFile(long hApplication, byte[] szFileName, int ulOfffset, byte[] pbData, int ulSize) throws RemoteException {
        return skfApi.WriteFile(hApplication, szFileName, ulOfffset, pbData, ulSize);
    }

    public int CreateContainer(long hApplication, byte[] szContainerName, long[] pbContainer) throws RemoteException {
        return skfApi.CreateContainer(hApplication, szContainerName, pbContainer);
    }

    public int DeleteContainer(long hApplication, byte[] szContainerName) throws RemoteException {
        return skfApi.DeleteContainer(hApplication, szContainerName);
    }

    public int EnumContainer(long hApplication, byte[] szContainerName, int[] pulSize) throws RemoteException {
        return skfApi.EnumContainer(hApplication, szContainerName, pulSize);
    }

    public int OpenContainer(long hApplication, byte[] szContainerName, long[] pbContainer) throws RemoteException {
        return skfApi.OpenContainer(hApplication, szContainerName, pbContainer);
    }

    public int CloseContainer(long hContainer) throws RemoteException {
        return skfApi.CloseContainer(hContainer);
    }

    public int GetContainerType(long hContainer, int[] pulContainerType) throws RemoteException {
        return skfApi.GetContainerType(hContainer, pulContainerType);
    }

    public int ImportCertificate(long hContainer, int bSignFlag, byte[] pbCert, int ulCertLen) throws RemoteException {
        return skfApi.ImportCertificate(hContainer, bSignFlag, pbCert, ulCertLen);
    }

    public int ExportCertificate(long hContainer, int bSignFlag, byte[] pbCert, int[] pulCertLen) throws RemoteException {
        return skfApi.ExportCertificate(hContainer, bSignFlag, pbCert, pulCertLen);
    }

    public int GenRandom(long hDev, byte[] pbRandom, int ulRandomLen) throws RemoteException {
        int ret = skfApi.GenRandom(this.phDdev[0], pbRandom, ulRandomLen);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.GenRandom(this.phDdev[0], pbRandom, ulRandomLen);
        }
        return ret;
    }

    public int GenExtRSAKey(long hDev, int ulBitsLen, RsaPrivateKeyBlob pBlob) throws RemoteException {
        int ret = skfApi.GenExtRSAKey(this.phDdev[0], ulBitsLen, pBlob);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.GenExtRSAKey(this.phDdev[0], ulBitsLen, pBlob);
        }
        return ret;
    }

    public int GenRSAKeyPair(long hContainer, int ulBitsLen, RsaPublicKeyBlob pBlob) throws RemoteException {
        return skfApi.GenRSAKeyPair(hContainer, ulBitsLen, pBlob);
    }

    public int ImportRSAKeyPair(long hContainer, int ulSymAlgId, byte[] pbWrappedKey, int ulWrappedKeyLen, byte[] pbEncryptedData, int ulEncryptedDataLen) throws RemoteException {
        return skfApi.ImportRSAKeyPair(hContainer, ulSymAlgId, pbWrappedKey, ulWrappedKeyLen, pbEncryptedData, ulEncryptedDataLen);
    }

    public int RSASignData(long hContainer, byte[] pbData, int ulDataLen, byte[] pbSignature, int[] pulSignLen) throws RemoteException {
        return skfApi.RSASignData(hContainer, pbData, ulDataLen, pbSignature, pulSignLen);
    }

    public int RSAVerify(long hDev, RsaPublicKeyBlob pRSAPubKeyBlob, byte[] pbData, int ulDataLen, byte[] pbSignature, int ulSignLen) throws RemoteException {
        int ret = skfApi.RSAVerify(this.phDdev[0], pRSAPubKeyBlob, pbData, ulDataLen, pbSignature, ulSignLen);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.RSAVerify(this.phDdev[0], pRSAPubKeyBlob, pbData, ulDataLen, pbSignature, ulSignLen);
        }
        return ret;
    }

    public int RSAExportSessionKey(long hContainer, int ulAlgId, RsaPublicKeyBlob pPubKey, byte[] pbData, int[] pulDataLen, long[] phSessionKey) throws RemoteException {
        return skfApi.RSAExportSessionKey(hContainer, ulAlgId, pPubKey, pbData, pulDataLen, phSessionKey);
    }

    public int ExtRSAPubKeyOperation(long hDev, RsaPublicKeyBlob pRSAPubKeyBlob, byte[] pbInput, int ulInputLen, byte[] pbOutput, int[] pulOutputLen) throws RemoteException {
        int ret = skfApi.ExtRSAPubKeyOperation(this.phDdev[0], pRSAPubKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.ExtRSAPubKeyOperation(this.phDdev[0], pRSAPubKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);
        }
        return ret;
    }

    public int ExtRSAPriKeyOperation(long hDev, RsaPrivateKeyBlob pRSAPriKeyBlob, byte[] pbInput, int ulInputLen, byte[] pbOutput, int[] pulOutputLen) throws RemoteException {
        int ret = skfApi.ExtRSAPriKeyOperation(this.phDdev[0], pRSAPriKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.ExtRSAPriKeyOperation(this.phDdev[0], pRSAPriKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);
        }
        return ret;
    }

    public int GenECCKeyPair(long hContainer, int ulAlgId, EccPublicKeyBlob pBlob) throws RemoteException {
        return skfApi.GenECCKeyPair(hContainer, ulAlgId, pBlob);
    }

    public int ImportECCKeyPair(long hContainer, EnvelopedKeyBlob pEenvlopedKeyBlob) throws RemoteException {
        return skfApi.ImportECCKeyPair(hContainer, pEenvlopedKeyBlob);
    }

    public int ECCSignData(long hContainer, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {
        return skfApi.ECCSignData(hContainer, pbData, ulDataLen, pSignature);
    }

    public int ECCVerify(long hDev, EccPublicKeyBlob pECCPubKeyBlob, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {
        int ret = skfApi.ECCVerify(this.phDdev[0], pECCPubKeyBlob, pbData, ulDataLen, pSignature);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.ECCVerify(this.phDdev[0], pECCPubKeyBlob, pbData, ulDataLen, pSignature);
        }
        return ret;
    }

    public int ECCExportSessionKey(long hContainer, int ulAlgId, EccPublicKeyBlob pPubKey, EccCipherBlob pData, long[] phSessionKey) throws RemoteException {
        return skfApi.ECCExportSessionKey(hContainer, ulAlgId, pPubKey, pData, phSessionKey);
    }

    public int ExtECCEncrypt(long hDev, EccPublicKeyBlob pECCPubkeyBlob, byte[] pbPlainText, int ulPlainTextLen, EccCipherBlob pCipherText) throws RemoteException {
        int ret = skfApi.ExtECCEncrypt(this.phDdev[0], pECCPubkeyBlob, pbPlainText, ulPlainTextLen, pCipherText);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.ExtECCEncrypt(this.phDdev[0], pECCPubkeyBlob, pbPlainText, ulPlainTextLen, pCipherText);
        }
        return ret;
    }

    public int ExtECCDecrypt(long hDev, EccPrivateKeyBlob pECCPriKeyBlob, EccCipherBlob pCipherText, byte[] pbPlainText, int[] pulPlainTextLen) throws RemoteException {
        int ret = skfApi.ExtECCDecrypt(this.phDdev[0], pECCPriKeyBlob, pCipherText, pbPlainText, pulPlainTextLen);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.ExtECCDecrypt(this.phDdev[0], pECCPriKeyBlob, pCipherText, pbPlainText, pulPlainTextLen);
        }
        return ret;
    }

    public int ExtECCSign(long hDev, EccPrivateKeyBlob pECCPriKeyBlob, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {
        int ret = skfApi.ExtECCSign(this.phDdev[0], pECCPriKeyBlob, pbData, ulDataLen, pSignature);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.ExtECCSign(this.phDdev[0], pECCPriKeyBlob, pbData, ulDataLen, pSignature);
        }
        return ret;
    }

    public int ExtECCVerify(long hDev, EccPublicKeyBlob pECCPubKeyBlob, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {
        int ret = skfApi.ExtECCVerify(this.phDdev[0], pECCPubKeyBlob, pbData, ulDataLen, pSignature);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.ExtECCVerify(this.phDdev[0], pECCPubKeyBlob, pbData, ulDataLen, pSignature);
        }
        return ret;
    }

    public int GenerateAgreementDataWithECC(long hContainer, int ulAlgId, EccPublicKeyBlob pTempECCPubKeyBlob, byte[] pbID, int ulIDLen, long[] phAgreementHandle) throws RemoteException {
        return skfApi.GenerateAgreementDataWithECC(hContainer, ulAlgId, pTempECCPubKeyBlob, pbID, ulIDLen, phAgreementHandle);
    }

    public int GenerateAgreementDataAndKeyWithECC(long hContainer, int ulAlgId, EccPublicKeyBlob pSponsorECCPubKeyBlob, EccPublicKeyBlob pSponsorTempECCPubKeyBlob, EccPublicKeyBlob pTempECCPubKeyBlob, byte[] pbID, int ulIDLen, byte[] pbSponsorID, int ulSponsorIDLen, long[] phKeyHandle) throws RemoteException {
        return skfApi.GenerateAgreementDataAndKeyWithECC(hContainer, ulAlgId, pSponsorECCPubKeyBlob, pSponsorTempECCPubKeyBlob, pTempECCPubKeyBlob, pbID, ulIDLen, pbSponsorID, ulSponsorIDLen, phKeyHandle);
    }

    public int GenerateKeyWithECC(long hAgreementHandle, EccPublicKeyBlob pECCPubKeyBlob, EccPublicKeyBlob pTempECCPubKeyBlob, byte[] pbID, int ulIDLen, long[] phKeyHandle) throws RemoteException {
        return skfApi.GenerateKeyWithECC(hAgreementHandle, pECCPubKeyBlob, pTempECCPubKeyBlob, pbID, ulIDLen, phKeyHandle);
    }

    public int ExportPublicKey(long hContainer, int bSignFlag, byte[] pbBlob, int[] pulBlobLen) throws RemoteException {
        return skfApi.ExportPublicKey(hContainer, bSignFlag, pbBlob, pulBlobLen);
    }

    public int ImportSessionKey(long hContainer, int ulAlgId, byte[] pbWrapedData, int ulWrapedLen, long[] phKey) throws RemoteException {
        return skfApi.ImportSessionKey(hContainer, ulAlgId, pbWrapedData, ulWrapedLen, phKey);
    }

    public int SetSymmKey(long hDev, byte[] pbKey, int ulAlgID, long[] phKey) throws RemoteException {
        int ret = skfApi.SetSymmKey(this.phDdev[0], pbKey, ulAlgID, phKey);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.SetSymmKey(this.phDdev[0], pbKey, ulAlgID, phKey);
        }
        return ret;
    }

    public int EncryptInit(long hKey, BlockCipherParam EncryptParam) throws RemoteException {
        return skfApi.EncryptInit(hKey, EncryptParam);
    }

    public int Encrypt(long hKey, byte[] pbData, int ulDataLen, byte[] pbEncryptedData, int[] pulEncryptedLen) throws RemoteException {
        return skfApi.Encrypt(hKey, pbData, ulDataLen, pbEncryptedData, pulEncryptedLen);
    }

    public int EncryptUpdate(long hKey, byte[] pbData, int ulDataLen, byte[] pbEncryptedData, int[] pulEncryptedLen) throws RemoteException {
        return skfApi.EncryptUpdate(hKey, pbData, ulDataLen, pbEncryptedData, pulEncryptedLen);
    }

    public int EncryptFinal(long hKey, byte[] pbEncryptedData, int[] pulEncryptedLen) throws RemoteException {
        return skfApi.EncryptFinal(hKey, pbEncryptedData, pulEncryptedLen);
    }

    public int DecryptInit(long hKey, BlockCipherParam EncryptParam) throws RemoteException {
        return skfApi.DecryptInit(hKey, EncryptParam);
    }

    public int Decrypt(long hKey, byte[] pbEncryptedData, int ulEncryptedLen, byte[] pbData, int[] pulDataLen) throws RemoteException {
        return skfApi.Decrypt(hKey, pbEncryptedData, ulEncryptedLen, pbData, pulDataLen);
    }

    public int DecryptUpdate(long hKey, byte[] pbEncryptedData, int ulEncryptedLen, byte[] pbData, int[] pulDataLen) throws RemoteException {
        return skfApi.DecryptUpdate(hKey, pbEncryptedData, ulEncryptedLen, pbData, pulDataLen);
    }

    public int DecryptFinal(long hKey, byte[] pbDecryptedData, int[] pulDecryptedDataLen) throws RemoteException {
        return skfApi.DecryptFinal(hKey, pbDecryptedData, pulDecryptedDataLen);
    }

    public int DigestInit(long hDev, int ulAlgID, EccPublicKeyBlob pPubKey, byte[] pucID, int ulIDLen, long[] phHash) throws RemoteException {
        int ret = skfApi.DigestInit(this.phDdev[0], ulAlgID, pPubKey, pucID, ulIDLen, phHash);
        if (ret == 0xA000006) {
            ret = this.ConnectDev(this.devName, this.phDdev);
            if (ret != 0) {
                return ret;
            }
            ret = skfApi.DigestInit(this.phDdev[0], ulAlgID, pPubKey, pucID, ulIDLen, phHash);
        }
        return ret;
    }

    public int Digest(long hHash, byte[] pbData, int ulDataLen, byte[] phHashData, int[] pulHashLen) throws RemoteException {
        return skfApi.Digest(hHash, pbData, ulDataLen, phHashData, pulHashLen);
    }

    public int DigestUpdate(long hHash, byte[] pbData, int ulDataLen) throws RemoteException {
        return skfApi.DigestUpdate(hHash, pbData, ulDataLen);
    }

    public int DigestFinal(long hHash, byte[] pHashData, int[] pulHashLen) throws RemoteException {
        return skfApi.DigestFinal(hHash, pHashData, pulHashLen);
    }

    public int MacInit(long hKey, BlockCipherParam pMacParam, long[] phMac) throws RemoteException {
        return skfApi.MacInit(hKey, pMacParam, phMac);
    }

    public int Mac(long hMac, byte[] pbData, int ulDataLen, byte[] pbMacData, int[] pulMacLen) throws RemoteException {
        return skfApi.Mac(hMac, pbData, ulDataLen, pbMacData, pulMacLen);
    }

    public int MacUpdate(long hMac, byte[] pbData, int ulDataLen) throws RemoteException {
        return skfApi.MacUpdate(hMac, pbData, ulDataLen);
    }

    public int MacFinal(long hMac, byte[] pbMacData, int[] pulMacDataLen) throws RemoteException {
        return skfApi.MacFinal(hMac, pbMacData, pulMacDataLen);
    }

    public int CloseHandle(long hHandle) throws RemoteException {
        return skfApi.CloseHandle(hHandle);
    }

    public int XdjaUnlockPin(int role, byte[] key, byte[] newPin) throws RemoteException {
        AccessControlManager accessControlManager = AccessControlManager.getInstance(this.context);
        int checkRes = accessControlManager.checkByUidPid(OnboardXdjaChipBinder.getCallingUid(), OnboardXdjaChipBinder.getCallingPid(), "XdjaUnlockPin");
        if (checkRes != 0) {
            Log.i((String)tag, (String)("checkByUidPid res: " + checkRes));
            return -101;
        }
        JNIAPI jniapi = new JNIAPI();
        long[] handle = new long[1];
        int ret = jniapi.OpenDev(0, handle);
        if (ret != 0) {
            return ret;
        }
        ret = JNIPinManager.getInstance().XdjaUnlockPin(jniapi, handle[0], role, key, newPin);
        this.callUnitePin(ret, role, newPin, "XdjaUnlockPin");
        return ret;
    }

    public int XdjaUnlockPinUseUsn(int role, byte[] usn, byte[] usnlockCode, byte[] newPin) throws RemoteException {
        AccessControlManager accessControlManager = AccessControlManager.getInstance(this.context);
        int checkRes = accessControlManager.checkByUidPid(OnboardXdjaChipBinder.getCallingUid(), OnboardXdjaChipBinder.getCallingPid(), "XdjaUnlockPinUseUsn");
        if (checkRes != 0) {
            Log.i((String)tag, (String)("checkByUidPid res: " + checkRes));
            return -101;
        }
        JNIAPI jniapi = new JNIAPI();
        long[] handle = new long[1];
        int ret = jniapi.OpenDev(0, handle);
        if (ret != 0) {
            return ret;
        }
        ret = JNIPinManager.getInstance().XdjaUnlockPinUseUsn(jniapi, handle[0], role, usn, usnlockCode, newPin);
        this.callUnitePin(ret, role, newPin, "XdjaUnlockPinUseUsn");
        return ret;
    }

    public String XdjaGetCosInfo() throws RemoteException {
        JNIAPI jniapi = new JNIAPI();
        long[] handle = new long[1];
        int ret = jniapi.OpenDev(0, handle);
        if (ret != 0) {
            return "";
        }
        XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
        int getDevInfoRet = jniapi.GetDevInfo(handle[0], devinfo);
        if (getDevInfoRet == 0) {
            return JNIPinManager.getInstance().getCosVer(devinfo);
        }
        return "";
    }

    @Override
    public void regist(IChipParamChangeListener listener) {
    }

    @Override
    public void unRegist(IChipParamChangeListener listener) {
    }

    private String getCardId() {
        DevInfo devInfo = new DevInfo();
        try {
            int ret = this.GetDevInfo(0L, devInfo);
            if (ret == 0) {
                return new String(devInfo.serialNumber);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getPkgName(int callingUid, int callingPid) {
        PackageManager pm = this.context.getPackageManager();
        String[] pkgList = pm.getPackagesForUid(callingUid);
        if (pkgList != null && pkgList.length > 0) {
            return pkgList[0];
        }
        Log.i((String)tag, (String)("XdjaChipBinder getPkgName null, uid: " + callingUid));
        return "";
    }

    private void callUnitePin(int ret, int role, byte[] pin, String method) {
        String cardId = this.getCardId();
        InsideMultiChipUnitePinManager.getInstance().handlePinResult(this.context, cardId, role, pin, ret, method, OnboardXdjaChipBinder.getCallingUid(), OnboardXdjaChipBinder.getCallingPid(), "SkfApi");
    }
}

