/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.tfcard;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.xdja.multichip.CallBackInfo;
import com.xdja.multichip.ISkfChip;
import com.xdja.multichip.param.ChipParam;
import com.xdja.multichip.process.IChipParamChangeListener;
import com.xdja.multichip.process.SupperChipBinder;
import com.xdja.multichip.process.tfcard.TFCardUtils;
import com.xdja.multichip.process.tfcard.XdjaTFBinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class TFHandle
implements IChipParamChangeListener {
    public static final String action_tf_mounted = "com_xdja_safekeyservice_tf_mounted";
    public static final String action_tf_removed = "com_xdja_safekeyservice_tf_removed";
    public static final String tag_currrent_tf = "tag_current_safe_tf";
    private ArrayList<IBinder> chipParamChangeBinderList = new ArrayList();
    private final String tag = "XdjaTFProcessService";
    ArrayList<Bundle> tfInfoBundleList = new ArrayList();
    private HashMap<String, SupperChipBinder> tfBinderMap = new HashMap();
    private static TFHandle instance;
    private BroadcastReceiver tfCardEventReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Log.v((String)"XdjaTFProcessService", (String)"xdjatfprocessService BroadcastReceiver");
            if ("android.intent.action.MEDIA_EJECT".equals(intent.getAction()) || "android.intent.action.MEDIA_REMOVED".equals(intent.getAction())) {
                Log.v((String)"XdjaTFProcessService", (String)"tf\u5361\u79fb\u9664");
                TFHandle.this.handleMediaRemoved(context);
            } else if ("android.intent.action.MEDIA_MOUNTED".equals(intent.getAction())) {
                Log.v((String)"XdjaTFProcessService", (String)"tf\u5361\u88ab\u6302\u8f7d");
                TFHandle.this.handleMediaMounted(context);
            }
        }
    };

    private TFHandle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TFHandle getInstance() {
        if (instance != null) return instance;
        Class<TFHandle> clazz = TFHandle.class;
        synchronized (TFHandle.class) {
            if (instance != null) return instance;
            instance = new TFHandle();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int handleOnStartCommand(Context context, Intent intent, int flags, int startId) {
        if (intent != null) {
            this.actionHandle(context, intent);
            this.registerTFEventReceiver(context);
        }
        return 0;
    }

    private void registerTFEventReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.MEDIA_MOUNTED");
        intentFilter.addAction("android.intent.action.MEDIA_REMOVED");
        intentFilter.addAction("android.intent.action.MEDIA_EJECT");
        intentFilter.addDataScheme("file");
        context.registerReceiver(this.tfCardEventReceiver, intentFilter);
        Log.i((String)"XdjaTFProcessService", (String)"registerTFEventReceiver");
    }

    private void actionHandle(Context context, Intent intent) {
        String actionValue = intent.getAction();
        if (actionValue.equals("getChipInfo")) {
            this.actionGetChipInfoHandle(context, intent);
        }
    }

    private void actionGetChipInfoHandle(Context context, Intent intent) {
        String latchTag = intent.getStringExtra("latchTag");
        Bundle bundle = intent.getBundleExtra("bundle");
        IBinder binder = bundle.getBinder("binder");
        Log.v((String)"testBinder", (String)("TF latchTag: " + latchTag));
        try {
            this.tfInfoBundleList = this.getCurrentTFCardInfo(context);
            CallBackInfo.Stub.asInterface((IBinder)binder).callBack(latchTag, TFHandle.class.getName(), this.tfInfoBundleList);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.tfInfoBundleList = this.getCurrentTFCardInfo(context);
        if (!this.chipParamChangeBinderList.contains(binder)) {
            this.chipParamChangeBinderList.add(binder);
        }
    }

    public ArrayList<Bundle> getCurrentTFCardInfo(Context context) {
        if (context != null) {
            this.registerTFEventReceiver(context);
        }
        ArrayList<Bundle> bundleList = new ArrayList<Bundle>();
        List<String> allExternalSdCardPath = TFCardUtils.getSuspicionSDCardPath(context);
        if (allExternalSdCardPath.size() > 0) {
            for (String sdcardPath : allExternalSdCardPath) {
                Log.i((String)"XdjaTFProcessService", (String)("sdcardPath: " + sdcardPath));
                ISkfChip iSkfChip = this.handleChipBinder(context, sdcardPath);
                ChipParam chipParam = null;
                try {
                    Log.i((String)"XdjaTFProcessService", (String)"get chip param");
                    chipParam = iSkfChip.getChipParam();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                if (chipParam == null || this.isChipGetted(bundleList, chipParam)) continue;
                Bundle bundle = new Bundle();
                bundle.putBinder("Binder", iSkfChip.asBinder());
                bundle.putParcelable("ChipParam", (Parcelable)chipParam);
                bundleList.add(bundle);
                break;
            }
        }
        return bundleList;
    }

    private boolean isChipGetted(ArrayList<Bundle> bundleList, ChipParam chipParam) {
        boolean isInList = false;
        for (Bundle bundle : bundleList) {
            ChipParam chipParamInList = (ChipParam)bundle.getParcelable("ChipParam");
            if (chipParamInList == null || !chipParam.uniqueID.equalsIgnoreCase(chipParamInList.uniqueID)) continue;
            isInList = true;
            break;
        }
        Log.i((String)"XdjaTFProcessService", (String)("checkChipIsGetted res\uff1a " + isInList));
        Log.i((String)"XdjaTFProcessService", (String)("bundleList size\uff1a " + bundleList.size()));
        return isInList;
    }

    private ISkfChip handleChipBinder(Context context, String tfcardPath) {
        Log.i((String)"XdjaTFProcessService", (String)("handleChipBinder path: " + tfcardPath));
        SupperChipBinder chipBinder = this.tfBinderMap.get(tfcardPath);
        Log.i((String)"XdjaTFProcessService", (String)("handleChipBinder chipBinder: " + (Object)((Object)chipBinder)));
        if (chipBinder == null) {
            chipBinder = this.createSkfChip(context, tfcardPath);
            chipBinder.regist(this);
            this.tfBinderMap.put(tfcardPath, chipBinder);
        }
        return chipBinder;
    }

    private SupperChipBinder createSkfChip(Context context, String tfcardPath) {
        return new XdjaTFBinder(context, tfcardPath);
    }

    @Override
    public void change(ChipParam chipParam) {
    }

    private void handleMediaRemoved(Context context) {
        if (this.tfInfoBundleList.size() > 0) {
            ArrayList<Bundle> currentTFCardInfo = this.getCurrentTFCardInfo(context);
            this.updateTFInfoInCache(currentTFCardInfo);
            Log.i((String)"XdjaTFProcessService", (String)"handleMediaRemoved, sendTFInfoChangeBroadcast");
            this.sendTFInfoChangeBroadcast(context, action_tf_removed, this.tfInfoBundleList);
        }
    }

    private void handleMediaMounted(Context context) {
        ArrayList<Bundle> currentTFCardInfo = this.getCurrentTFCardInfo(context);
        if (!currentTFCardInfo.isEmpty()) {
            if (this.tfInfoBundleList.isEmpty()) {
                this.tfInfoBundleList.addAll(currentTFCardInfo);
                this.sendTFInfoChangeBroadcast(context, action_tf_mounted, this.tfInfoBundleList);
            } else {
                this.updateTFInfoInCache(currentTFCardInfo);
                this.sendTFInfoChangeBroadcast(context, action_tf_mounted, this.tfInfoBundleList);
            }
        } else {
            this.tfInfoBundleList.clear();
            this.sendTFInfoChangeBroadcast(context, action_tf_mounted, new ArrayList<Bundle>(0));
        }
    }

    private void sendTFInfoChangeBroadcast(Context context, String action, ArrayList<Bundle> bundles) {
        Intent tfAddBroadcastIntent = new Intent();
        tfAddBroadcastIntent.setAction(action);
        tfAddBroadcastIntent.putParcelableArrayListExtra(tag_currrent_tf, bundles);
        context.sendBroadcast(tfAddBroadcastIntent);
    }

    private void updateTFInfoInCache(List<Bundle> currentTFCardInfo) {
        ChipParam chipParam;
        HashMap<String, Bundle> currentInfoMap = new HashMap<String, Bundle>();
        for (Bundle bundle : currentTFCardInfo) {
            ChipParam chipParam2 = (ChipParam)bundle.getParcelable("ChipParam");
            if (chipParam2 == null) continue;
            currentInfoMap.put(chipParam2.uniqueID, bundle);
        }
        int cacheListSize = this.tfInfoBundleList.size();
        for (int i = cacheListSize - 1; i >= 0; --i) {
            Bundle bundle = this.tfInfoBundleList.get(i);
            ChipParam chipParam3 = (ChipParam)bundle.getParcelable("ChipParam");
            if (chipParam3 == null || currentInfoMap.get(chipParam3.uniqueID) != null) continue;
            this.tfInfoBundleList.remove(i);
        }
        HashMap<String, Bundle> tfInfoInCacheMap = new HashMap<String, Bundle>();
        for (Bundle bundle : this.tfInfoBundleList) {
            chipParam = (ChipParam)bundle.getParcelable("ChipParam");
            if (chipParam == null) continue;
            tfInfoInCacheMap.put(chipParam.uniqueID, bundle);
        }
        for (Bundle bundle : currentTFCardInfo) {
            chipParam = (ChipParam)bundle.getParcelable("ChipParam");
            if (chipParam == null || tfInfoInCacheMap.get(chipParam.uniqueID) != null) continue;
            this.tfInfoBundleList.add(bundle);
        }
    }
}

