/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cc;

import com.taisys.model.Card;
import java.util.HashMap;

public class BaseCard {
    protected Card mcc;
    protected static final String TAG = "CoverCard";
    public static final int XKR_OK = 0;
    public static final int XKR_FAIL = 1;
    public static final int XKR_IO_FAILED = -2;
    public static final int XKR_PASSWORD = -10;
    public static final int XKR_PARAMETER = -12;
    public static final int XKR_NO_POWER = -15;
    public static final int XKR_KEY_LOCKED = -16;
    public static final int XKR_FILE_NOT_EXIST = -20;
    public static final int XKR_FILE_EXIST = -23;
    public static final int XKR_CARD_LOCKED = -26;
    public static final int XKR_WRONG_LE = -27;
    public static final int XKR_NOT_FIND_DATA = -42;
    public static final int XKR_WRONG_MAC = -30;
    public static final int XKR_NOT_SUPPORT = -98;
    public static final int XKR_UNKNOWN = -100;
    public static final int XKR_KEYFILE_NOT_EXIST = -31;
    public static final int XKR_KEY_NOT_EXIST = -32;
    public static final int XKR_WRONG_KEY_TYPE = -33;
    private static HashMap<String, Integer> errcode = new HashMap();
    public static final int ECB_MODE = 0;
    public static final int CBC_MODE = 16;
    public static final int ECB_DECRYPT = 0;
    public static final int ECB_ENCRYPT = 1;
    public static final int CBC_DECRYPT = 16;
    public static final int CBC_ENCRYPT = 17;
    protected static final int APDU_CODE_SIZE = 4;
    protected static final int ONCE_MAX_LENGHT = 128;

    public BaseCard() {
        this.mcc = new Card();
    }

    public BaseCard(Card cc) {
        this.mcc = cc;
    }

    protected int HandleApduErrCode(String code) {
        if (code == null) {
            return -2;
        }
        if (code.length() < 4) {
            return -100;
        }
        String err = code.toUpperCase();
        if (err.substring(0, 2).equals("6C")) {
            String siz = err.substring(2);
            return Integer.parseInt(siz, 16);
        }
        if (err.substring(0, 2).equals("66")) {
            String bytes = err.substring(2);
            return Integer.parseInt(bytes, 16);
        }
        if (err.substring(0, 3).equals("63C")) {
            String times = err.substring(3);
            return Integer.parseInt(times, 16);
        }
        if (errcode.containsKey(err)) {
            return errcode.get(err);
        }
        return -100;
    }

    protected String getCode(String data) {
        if (data == null || data.length() < 4) {
            return data;
        }
        return data.substring(data.length() - 4);
    }

    static {
        errcode.put("9000", 0);
        errcode.put("6700", -12);
        errcode.put("6A86", -12);
        errcode.put("6F01", -100);
        errcode.put("6CXX", -27);
        errcode.put("6983", -16);
        errcode.put("6982", -15);
        errcode.put("6989", -42);
        errcode.put("6F00", -100);
        errcode.put("6F88", -23);
        errcode.put("698F", -15);
        errcode.put("6A82", -20);
        errcode.put("6A83", -98);
        errcode.put("6985", -30);
    }
}

