/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cc;

public class XDJA_FILE {
    public byte type;
    public static final byte FILE_TYPE_BINARY = 1;
    public static final byte FILE_TYPE_PUBLIC = 2;
    public static final byte FILE_TYPE_PRIVATE = 3;
    public short room;
    public byte read_Acl;
    public byte write_Acl;
    public byte use_Acl;
    public static final byte FOP_PERMIT = -16;
    public static final byte FOP_FORBID = 15;
    public static final byte FOP_PERMISSION = 17;
    public byte[] id;
    private static final int SIZE = 8;

    public int parse(String data) {
        this.id = new byte[2];
        int pos = 0;
        int end = pos + 2;
        if (data.length() < end) {
            return -1;
        }
        this.type = (byte)Integer.parseInt(data.substring(pos, end), 16);
        pos = end;
        end = pos + 4;
        if (data.length() < end) {
            return -1;
        }
        this.room = (short)Integer.parseInt(data.substring(pos, end), 16);
        pos = end;
        end = pos + 2;
        if (data.length() < end) {
            return -1;
        }
        this.read_Acl = (byte)Integer.parseInt(data.substring(pos, end), 16);
        pos = end;
        end = pos + 2;
        if (data.length() < end) {
            return -1;
        }
        this.write_Acl = (byte)Integer.parseInt(data.substring(pos, end), 16);
        pos = end;
        end = pos + 2;
        if (data.length() < end) {
            return -1;
        }
        this.use_Acl = (byte)Integer.parseInt(data.substring(pos, end), 16);
        pos = end;
        end = pos + 2;
        if (data.length() < end) {
            return -1;
        }
        this.id[0] = (byte)Integer.parseInt(data.substring(pos, end), 16);
        pos = end;
        end = pos + 2;
        if (data.length() < end) {
            return -1;
        }
        this.id[1] = (byte)Integer.parseInt(data.substring(pos, end), 16);
        return 0;
    }

    public XDJA_FILE() {
    }

    public XDJA_FILE(String data) {
        this.parse(data);
    }

    public XDJA_FILE(byte[] id, byte type) {
        this.id = new byte[2];
        this.id[0] = id[0];
        this.id[1] = id[1];
        this.type = type;
        switch (type) {
            case 2: {
                this.room = (short)512;
                this.read_Acl = (byte)-16;
                this.write_Acl = (byte)17;
                this.use_Acl = (byte)-16;
                break;
            }
            case 3: {
                this.room = (short)1024;
                this.read_Acl = (byte)-16;
                this.write_Acl = (byte)17;
                this.use_Acl = (byte)17;
                break;
            }
            default: {
                this.room = (short)1536;
                this.read_Acl = (byte)-16;
                this.write_Acl = (byte)17;
                this.use_Acl = (byte)-16;
            }
        }
    }

    private byte AclWrapper(byte acl) {
        byte minor = (byte)(acl & 0xF);
        byte major = (byte)(acl >> 4 & 0xF);
        if (minor == 0) {
            return -16;
        }
        if (minor == 1 && minor == major || minor < major) {
            return 17;
        }
        return 15;
    }

    public XDJA_FILE(byte[] id, byte type, short room, byte read_Acl, byte write_Acl, byte use_Acl) {
        this.id = new byte[2];
        this.id[0] = id[0];
        this.id[1] = id[1];
        this.type = type;
        this.room = room;
        this.read_Acl = this.AclWrapper(read_Acl);
        this.write_Acl = this.AclWrapper(write_Acl);
        this.use_Acl = this.AclWrapper(use_Acl);
    }

    public String toApduData() {
        return String.format("%02x%02x%04x%02x%02x%02x%02x%02x", 8, this.type, this.room, this.read_Acl, this.write_Acl, this.use_Acl, this.id[0], this.id[1]);
    }

    public static int size() {
        return 8;
    }

    public String toString() {
        return String.format("ID:(%02X,%02X), TYPE:%X ROOM:%X, R:%02X, W:%02X, U:%02X", this.id[0], this.id[1], this.type, this.room, this.read_Acl, this.write_Acl, this.use_Acl);
    }

    public boolean equals(XDJA_FILE file) {
        if (file == null) {
            return false;
        }
        if (this == file) {
            return true;
        }
        if (this.id[0] != file.id[0] || this.id[1] != file.id[1]) {
            return false;
        }
        if (this.type != file.type) {
            return false;
        }
        if (this.room != file.room) {
            return false;
        }
        if (this.read_Acl != file.read_Acl) {
            return false;
        }
        if (this.write_Acl != file.write_Acl) {
            return false;
        }
        return this.use_Acl == file.use_Acl;
    }
}

