/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.sm2cipher.ec;

import com.xdja.cssp.sm2cipher.ec.ECFieldElement;
import com.xdja.cssp.sm2cipher.ec.ECPoint;
import java.math.BigInteger;

public abstract class ECCurve {
    ECFieldElement a;
    ECFieldElement b;

    public abstract int getFieldSize();

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract ECPoint createPoint(BigInteger var1, BigInteger var2, boolean var3);

    public abstract ECPoint decodePoint(byte[] var1);

    public abstract ECPoint getInfinity();

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    public static class Fp
    extends ECCurve {
        BigInteger q;
        ECPoint.Fp infinity;

        public Fp(BigInteger q, BigInteger a2, BigInteger b2) {
            this.q = q;
            this.a = this.fromBigInteger(a2);
            this.b = this.fromBigInteger(b2);
            this.infinity = new ECPoint.Fp(this, null, null);
        }

        public BigInteger getQ() {
            return this.q;
        }

        @Override
        public int getFieldSize() {
            return this.q.bitLength();
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger x) {
            return new ECFieldElement.Fp(this.q, x);
        }

        @Override
        public ECPoint createPoint(BigInteger x, BigInteger y, boolean withCompression) {
            return new ECPoint.Fp(this, this.fromBigInteger(x), this.fromBigInteger(y), withCompression);
        }

        @Override
        public ECPoint decodePoint(byte[] encoded) {
            ECPoint p = null;
            switch (encoded[0]) {
                case 0: {
                    if (encoded.length > 1) {
                        throw new RuntimeException("Invalid point encoding");
                    }
                    p = this.getInfinity();
                    break;
                }
                case 2: 
                case 3: {
                    int bit0;
                    int ytilde = encoded[0] & 1;
                    byte[] i2 = new byte[encoded.length - 1];
                    System.arraycopy(encoded, 1, i2, 0, i2.length);
                    ECFieldElement.Fp x = new ECFieldElement.Fp(this.q, new BigInteger(1, i2));
                    ECFieldElement alpha = ((ECFieldElement)x).multiply(((ECFieldElement)x).square().add(this.a)).add(this.b);
                    ECFieldElement beta = alpha.sqrt();
                    if (beta == null) {
                        throw new RuntimeException("Invalid point compression");
                    }
                    int n = bit0 = beta.toBigInteger().testBit(0) ? 1 : 0;
                    if (bit0 == ytilde) {
                        p = new ECPoint.Fp(this, x, beta, true);
                        break;
                    }
                    p = new ECPoint.Fp(this, x, new ECFieldElement.Fp(this.q, this.q.subtract(beta.toBigInteger())), true);
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    byte[] xEnc = new byte[(encoded.length - 1) / 2];
                    byte[] yEnc = new byte[(encoded.length - 1) / 2];
                    System.arraycopy(encoded, 1, xEnc, 0, xEnc.length);
                    System.arraycopy(encoded, xEnc.length + 1, yEnc, 0, yEnc.length);
                    p = new ECPoint.Fp(this, new ECFieldElement.Fp(this.q, new BigInteger(1, xEnc)), new ECFieldElement.Fp(this.q, new BigInteger(1, yEnc)));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid point encoding 0x" + Integer.toString(encoded[0], 16));
                }
            }
            return p;
        }

        @Override
        public ECPoint getInfinity() {
            return this.infinity;
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (!(anObject instanceof Fp)) {
                return false;
            }
            Fp other = (Fp)anObject;
            return this.q.equals(other.q) && this.a.equals(other.a) && this.b.equals(other.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.q.hashCode();
        }
    }
}

