/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.sm2cipher.ec;

import com.xdja.cssp.sm2cipher.ec.ECCurve;
import com.xdja.cssp.sm2cipher.ec.ECFieldElement;
import com.xdja.cssp.sm2cipher.ec.ECMultiplier;
import com.xdja.cssp.sm2cipher.ec.FpNafMultiplier;
import com.xdja.cssp.sm2cipher.ec.IntegerConverter;
import java.math.BigInteger;

public abstract class ECPoint {
    ECCurve curve;
    ECFieldElement x;
    ECFieldElement y;
    protected boolean withCompression;
    protected ECMultiplier multiplier = null;
    private static IntegerConverter converter = new IntegerConverter();

    protected ECPoint(ECCurve curve, ECFieldElement x, ECFieldElement y) {
        this.curve = curve;
        this.x = x;
        this.y = y;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECFieldElement getX() {
        return this.x;
    }

    public ECFieldElement getY() {
        return this.y;
    }

    public boolean isInfinity() {
        return this.x == null && this.y == null;
    }

    public boolean isCompressed() {
        return this.withCompression;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ECPoint)) {
            return false;
        }
        ECPoint o = (ECPoint)other;
        if (this.isInfinity()) {
            return o.isInfinity();
        }
        return this.x.equals(o.x) && this.y.equals(o.y);
    }

    public int hashCode() {
        if (this.isInfinity()) {
            return 0;
        }
        return this.x.hashCode() ^ this.y.hashCode();
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint negate();

    public abstract ECPoint twice();

    synchronized void assertECMultiplier() {
        if (this.multiplier == null) {
            this.multiplier = new FpNafMultiplier();
        }
    }

    public ECPoint multiply(BigInteger k2) {
        if (k2.signum() < 0) {
            throw new IllegalArgumentException("The multiplicator cannot be negative");
        }
        if (this.isInfinity()) {
            return this;
        }
        if (k2.signum() == 0) {
            return this.curve.getInfinity();
        }
        this.assertECMultiplier();
        return this.multiplier.multiply(this, k2);
    }

    public static class Fp
    extends ECPoint {
        public Fp(ECCurve curve, ECFieldElement x, ECFieldElement y) {
            this(curve, x, y, false);
        }

        public Fp(ECCurve curve, ECFieldElement x, ECFieldElement y, boolean withCompression) {
            super(curve, x, y);
            if (x != null && y == null || x == null && y != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            this.withCompression = withCompression;
        }

        @Override
        public byte[] getEncoded() {
            if (this.isInfinity()) {
                return new byte[1];
            }
            int qLength = converter.getByteLength(this.x);
            if (this.withCompression) {
                int PC = this.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] X = converter.integerToBytes(this.getX().toBigInteger(), qLength);
                byte[] PO = new byte[X.length + 1];
                PO[0] = PC;
                System.arraycopy(X, 0, PO, 1, X.length);
                return PO;
            }
            byte[] X = converter.integerToBytes(this.getX().toBigInteger(), qLength);
            byte[] Y = converter.integerToBytes(this.getY().toBigInteger(), qLength);
            byte[] PO = new byte[X.length + Y.length + 1];
            PO[0] = 4;
            System.arraycopy(X, 0, PO, 1, X.length);
            System.arraycopy(Y, 0, PO, X.length + 1, Y.length);
            return PO;
        }

        @Override
        public ECPoint add(ECPoint b2) {
            if (this.isInfinity()) {
                return b2;
            }
            if (b2.isInfinity()) {
                return this;
            }
            if (this.x.equals(b2.x)) {
                if (this.y.equals(b2.y)) {
                    return this.twice();
                }
                return this.curve.getInfinity();
            }
            ECFieldElement gamma = b2.y.subtract(this.y).divide(b2.x.subtract(this.x));
            ECFieldElement x3 = gamma.square().subtract(this.x).subtract(b2.x);
            ECFieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
            return new Fp(this.curve, x3, y3);
        }

        @Override
        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            if (this.y.toBigInteger().signum() == 0) {
                return this.curve.getInfinity();
            }
            ECFieldElement TWO = this.curve.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement THREE = this.curve.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement gamma = this.x.square().multiply(THREE).add(this.curve.a).divide(this.y.multiply(TWO));
            ECFieldElement x3 = gamma.square().subtract(this.x.multiply(TWO));
            ECFieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
            return new Fp(this.curve, x3, y3, this.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint b2) {
            if (b2.isInfinity()) {
                return this;
            }
            return this.add(b2.negate());
        }

        @Override
        public ECPoint negate() {
            return new Fp(this.curve, this.x, this.y.negate(), this.withCompression);
        }
    }
}

