/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.sm2cipher.sm2.cipher;

import com.xdja.cssp.sm2cipher.ec.ECCurve;
import com.xdja.cssp.sm2cipher.ec.ECPoint;
import com.xdja.cssp.sm2cipher.ec.IntegerConverter;
import com.xdja.cssp.sm2cipher.ec.NamedEllipse;
import com.xdja.cssp.sm2cipher.ec.RandomGen;
import com.xdja.cssp.sm2cipher.sm2.cipher.ConvertUtil;
import com.xdja.cssp.sm2cipher.sm2.cipher.KDF;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM3Digest;
import com.xdja.cssp.sm2cipher.sm2.cipher.ServiceException;
import java.math.BigInteger;

public class SM2EncryptGB {
    private NamedEllipse namedEllipse = new NamedEllipse();
    private SM3Digest digest;

    public SM2EncryptGB(NamedEllipse namedEllipse) {
        if (namedEllipse == null) {
            namedEllipse = new NamedEllipse();
        }
        this.namedEllipse = namedEllipse;
        this.digest = new SM3Digest();
    }

    public byte[] pubkeyEncrypt(byte[] plainText, byte[] pubkey) {
        if (plainText != null && plainText.length > 0) {
            ECCurve.Fp eCurve = new ECCurve.Fp(this.namedEllipse.getQ(), this.namedEllipse.getA(), this.namedEllipse.getB());
            KDF kdf = new KDF(this.digest);
            IntegerConverter converter = new IntegerConverter();
            int klen = plainText.length;
            BigInteger M = new BigInteger(ConvertUtil.bytesToHexString(plainText), 16);
            byte[] kP = null;
            byte[] C = null;
            byte[] C1 = new byte[64];
            byte[] C2 = null;
            byte[] C3 = null;
            byte[] temp = null;
            byte[] tempT = null;
            byte[] temp_hash = null;
            byte[] x = null;
            byte[] y = null;
            byte[] cipherLength = this.int2Bytes(klen);
            ECPoint.Fp G = new ECPoint.Fp(eCurve, this.namedEllipse.getGx(), this.namedEllipse.getGy());
            ECPoint P = ((ECCurve)eCurve).decodePoint(pubkey);
            do {
                BigInteger k2 = RandomGen.randomGenerate();
                while (k2.signum() < 0) {
                    k2 = RandomGen.randomGenerate();
                }
                ECPoint pointC1 = G.multiply(k2);
                x = ConvertUtil.hexStringToBytes(pointC1.getX().toBigInteger().toString(16));
                y = ConvertUtil.hexStringToBytes(pointC1.getY().toBigInteger().toString(16));
                System.arraycopy(x, 0, C1, 32 - x.length, x.length);
                System.arraycopy(y, 0, C1, 32 + (32 - y.length), y.length);
                ECPoint pointS = P.multiply(this.namedEllipse.getH());
                if (pointS.isInfinity()) {
                    throw new RuntimeException("fatal error when encrypt data. reason: S is infinity point");
                }
                ECPoint point2 = P.multiply(k2);
                temp = point2.getEncoded();
                kP = new byte[temp.length - 1];
                System.arraycopy(temp, 1, kP, 0, kP.length);
                try {
                    tempT = kdf.genetateKey(kP, klen);
                }
                catch (ServiceException e2) {
                    e2.printStackTrace();
                    throw new RuntimeException("fatal error when encrypt data. reason: data to be encrypted is too large, the max length can only be 1024 * 4 byte");
                }
            } while (this.isAllZero(tempT));
            BigInteger t = new BigInteger(1, tempT);
            C2 = converter.integerToBytes(M.xor(t), klen);
            temp_hash = new byte[kP.length + klen];
            System.arraycopy(kP, 0, temp_hash, 0, kP.length / 2);
            System.arraycopy(plainText, 0, temp_hash, kP.length / 2, klen);
            System.arraycopy(kP, kP.length / 2, temp_hash, kP.length / 2 + klen, kP.length / 2);
            this.digest.update(temp_hash);
            C3 = this.digest.doFinal();
            C = new byte[68 + klen + this.digest.getDigestSize()];
            System.arraycopy(C1, 0, C, 0, 64);
            System.arraycopy(C3, 0, C, 64, this.digest.getDigestSize());
            System.arraycopy(cipherLength, 0, C, 64 + this.digest.getDigestSize(), 4);
            System.arraycopy(C2, 0, C, 64 + this.digest.getDigestSize() + 4, klen);
            return C;
        }
        return null;
    }

    public byte[] privateKeyDecrypt(byte[] cipherText, byte[] prikey) {
        if (cipherText != null && cipherText.length > 100) {
            ECCurve.Fp eCurve = new ECCurve.Fp(this.namedEllipse.getQ(), this.namedEllipse.getA(), this.namedEllipse.getB());
            KDF kdf = new KDF(this.digest);
            IntegerConverter converter = new IntegerConverter();
            int klen = cipherText.length - 64 - 32 - 4;
            BigInteger d2 = new BigInteger(ConvertUtil.bytesToHexString(prikey), 16);
            byte[] C1 = new byte[65];
            byte[] C2 = new byte[klen];
            byte[] C3 = new byte[32];
            byte[] temp_hash = null;
            byte[] temp_t = new byte[klen];
            byte[] tempM = new byte[klen];
            byte[] dC1 = new byte[64];
            C1[0] = 4;
            System.arraycopy(cipherText, 0, C1, 1, 64);
            System.arraycopy(cipherText, 64, C3, 0, 32);
            System.arraycopy(cipherText, 100, C2, 0, klen);
            ECPoint pointC1 = ((ECCurve)eCurve).decodePoint(C1);
            ECPoint pointS = pointC1.multiply(this.namedEllipse.getH());
            if (pointS.isInfinity()) {
                throw new RuntimeException("fatal error when decrypt data. reason: S is infinity point");
            }
            ECPoint point2 = pointC1.multiply(d2);
            System.arraycopy(point2.getEncoded(), 1, dC1, 0, 64);
            try {
                temp_t = kdf.genetateKey(dC1, klen);
            }
            catch (ServiceException e2) {
                e2.printStackTrace();
                throw new RuntimeException("atal error when encrypt data. reason: data to be decrypted is too large");
            }
            if (this.isAllZero(temp_t)) {
                throw new RuntimeException("fatal error when decrypt data. reason: t is all zero");
            }
            BigInteger t = new BigInteger(temp_t);
            BigInteger M = new BigInteger(C2).xor(t);
            tempM = converter.integerToBytes(M, klen);
            temp_hash = new byte[64 + klen];
            System.arraycopy(dC1, 0, temp_hash, 0, 32);
            System.arraycopy(tempM, 0, temp_hash, 32, klen);
            System.arraycopy(dC1, 32, temp_hash, 32 + klen, 32);
            this.digest.update(temp_hash);
            byte[] u = this.digest.doFinal();
            BigInteger U = new BigInteger(1, u);
            BigInteger c3 = new BigInteger(1, C3);
            if (U.compareTo(c3) == 0) {
                return M.toByteArray();
            }
            throw new RuntimeException("fatal error when decrypt data. reason: decrypt data failure");
        }
        throw new RuntimeException("fatal error when decrypt data. reason: cipher data is empty");
    }

    public byte[] hashData(byte[] bytes) {
        this.digest.update(bytes);
        return this.digest.doFinal();
    }

    private boolean isAllZero(byte[] bytes) {
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            if (bytes[i2] == 0) continue;
            return false;
        }
        return true;
    }

    private byte[] int2Bytes(int length) {
        byte[] bytes = new byte[]{(byte)(length >> 24), (byte)(length >> 16), (byte)(length >> 8), (byte)length};
        return bytes;
    }
}

