/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.jar.forcallprovider.ForCallProvider;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.bluetooth.BluetoothKeyProcessProvider;
import com.xdja.multichip.process.bluetooth.BluetoothKeyProcessService;
import com.xdja.multichip.process.board.OnboardProcessProvider;
import com.xdja.multichip.process.coveredcard.CCProcessProvider;
import com.xdja.multichip.process.tfcard.TFProcessProvider;
import com.xdja.multichip.utils.PermissionUtil;
import com.xdja.multichip.utils.SharedPreferencesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class GetMultiJniApiBinder
extends IGetMultiJniApi.Stub {
    private static final String NAME_PROCESS_ONBOARD = "onboard";
    private static final String NAME_PROCESS_TF = "TF";
    private static final String NAME_PROCESS_CC = "CC";
    private static final String NAME_PROCESS_BLUETOOTH = "bluetooth";
    private static HashMap<String, String> providerNameMap = new HashMap();
    private static final int WAIT_TIMEOUT = 10;
    private static ArrayList<String> hasChipDevList = new ArrayList();
    private static ArrayList<String> hasNotTFDevList = new ArrayList();
    private static GetMultiJniApiBinder instance;
    private Context context;
    private ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    private long lastCall = 0L;
    List<Bundle> lastRusult = new ArrayList<Bundle>();
    private static final int FLAG_ONBOARD_CHIP_EXIST = 1;
    private static final int FLAG_ONBOARD_CHIP_NOT_EXIST = -1;
    private static final int FLAG_ONBOARD_CHIP_UNKNOW = 0;
    private int onboardChipIsExist = 0;
    private int bluetoothFlag = 0;
    private BroadcastReceiver bluetoothReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int blueState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
            if (10 == blueState) {
                Intent stopIntent = new Intent();
                stopIntent.setClassName(context.getPackageName(), BluetoothKeyProcessService.class.getName());
                context.stopService(stopIntent);
            }
        }
    };

    private GetMultiJniApiBinder(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GetMultiJniApiBinder getInstance(Context context) {
        if (instance != null) return instance;
        Class<GetMultiJniApiBinder> clazz = GetMultiJniApiBinder.class;
        synchronized (GetMultiJniApiBinder.class) {
            if (instance != null) return instance;
            instance = new GetMultiJniApiBinder(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        String pkgName = this.context.getPackageName();
        ArrayList<String> list = new ArrayList<String>();
        list.add("com.xdja.safekeyservice");
        list.add("com.xdja.safeclient");
        list.add("com.xdja.uaac");
        if (!list.contains(pkgName)) {
            return false;
        }
        return super.onTransact(code, data, reply, flags);
    }

    public synchronized List<Bundle> getMultiJniApi() throws RemoteException {
        Log.w((String)"GetAll", (String)" getMultiJniApi start: ");
        long curCall = SystemClock.elapsedRealtime();
        if (curCall - this.lastCall < 1000L) {
            return this.lastRusult;
        }
        this.lastRusult.clear();
        List<String> chipProcessList = this.getChipProcessList();
        final CountDownLatch latch = new CountDownLatch(chipProcessList.size());
        for (String chipProcess : chipProcessList) {
            final String name = this.convertToProviderName(chipProcess);
            if (TextUtils.isEmpty((CharSequence)name)) {
                latch.countDown();
                continue;
            }
            this.cachedThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ArrayList bundle;
                        int ret;
                        Uri uri = Uri.parse((String)("content://" + name));
                        ContentResolver resolver = GetMultiJniApiBinder.this.context.getContentResolver();
                        Bundle bundleResult = resolver.call(uri, "GetJniApiBinder", "", null);
                        if (bundleResult != null && (ret = bundleResult.getInt("ret")) == 0 && (bundle = bundleResult.getParcelableArrayList("result")) != null) {
                            for (Bundle singleBundle : bundle) {
                                singleBundle.setClassLoader(JniApiParam.class.getClassLoader());
                                if (singleBundle.getParcelable("JniApiParam") == null) continue;
                                GetMultiJniApiBinder.this.lastRusult.add(singleBundle);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.lastCall = SystemClock.elapsedRealtime();
        Log.w((String)"GetAll", (String)" getMultiJniApi end: ");
        this.saveJniApiParam(this.lastRusult);
        return this.lastRusult;
    }

    public Bundle callMethod(Bundle bundle) throws RemoteException {
        String method;
        if (bundle == null) {
            return null;
        }
        if (bundle.containsKey("method") && "makeByType".equals(method = bundle.getString("method"))) {
            return this.makeByType(bundle);
        }
        Bundle result = new Bundle();
        result.putInt("ret", -10027);
        return result;
    }

    private Bundle makeByType(Bundle bundle) {
        int cardType = bundle.getInt("cardType");
        List<String> list = null;
        if (cardType == 1) {
            list = this.getOnboardChipProcessList();
        } else if (cardType == 2) {
            list = this.getTFChipProcessList();
        } else if (cardType == 4) {
            list = this.getBluekeyChipProcessList();
        } else if (cardType == 8) {
            list = this.getCoveredCardProcessList();
        }
        String processName = "";
        if (list != null && list.size() > 0) {
            processName = list.get(0);
        }
        Bundle result = new Bundle();
        if (TextUtils.isEmpty((CharSequence)processName)) {
            result.putInt("ret", 0);
            ArrayList paramList = new ArrayList();
            result.putParcelableArrayList("BundleList", paramList);
            return result;
        }
        processName = this.convertToProviderName(processName);
        ArrayList<Bundle> resultList = this.getMultiJniApiByType(processName);
        result.putInt("ret", 0);
        result.putParcelableArrayList("BundleList", resultList);
        return result;
    }

    private synchronized ArrayList<Bundle> getMultiJniApiByType(final String providerName) {
        final ArrayList<Bundle> resultList = new ArrayList<Bundle>();
        if (TextUtils.isEmpty((CharSequence)providerName)) {
            return resultList;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList bundle;
                int ret;
                Uri uri = Uri.parse((String)("content://" + providerName));
                ContentResolver resolver = GetMultiJniApiBinder.this.context.getContentResolver();
                Bundle bundleResult = resolver.call(uri, "GetJniApiBinder", "", null);
                if (bundleResult != null && (ret = bundleResult.getInt("ret")) == 0 && (bundle = bundleResult.getParcelableArrayList("result")) != null) {
                    for (Bundle singleBundle : bundle) {
                        singleBundle.setClassLoader(JniApiParam.class.getClassLoader());
                        if (singleBundle.getParcelable("JniApiParam") == null) continue;
                        resultList.add(singleBundle);
                    }
                }
                latch.countDown();
            }
        });
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    private List<String> getChipProcessList() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getOnboardChipProcessList());
        result.addAll(this.getTFChipProcessList());
        result.addAll(this.getBluekeyChipProcessList());
        result.addAll(this.getCoveredCardProcessList());
        return result;
    }

    private synchronized List<String> getOnboardChipProcessList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.onboardChipIsExist == -1) {
            return list;
        }
        if (this.onboardChipIsExist == 1) {
            list.add(NAME_PROCESS_ONBOARD);
        } else if (this.onboardChipIsExist == 0) {
            boolean flag = this.checkCurDevIsKownHasChip();
            if (flag) {
                this.onboardChipIsExist = 1;
            }
            list.add(NAME_PROCESS_ONBOARD);
        }
        return list;
    }

    private List<String> getTFChipProcessList() {
        String model = Build.MODEL;
        ArrayList<String> result = new ArrayList<String>();
        if (hasNotTFDevList.contains(model)) {
            return result;
        }
        result.add(NAME_PROCESS_TF);
        return result;
    }

    private List<String> getCoveredCardProcessList() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add("android.permission.READ_SMS");
        permissions.add("android.permission.SEND_SMS");
        permissions.add("android.permission.RECEIVE_SMS");
        permissions.add("android.permission.READ_CONTACTS");
        permissions.add("android.permission.WRITE_CONTACTS");
        List<String> deniedPermissions = PermissionUtil.getDeniedPermissions(this.context, permissions);
        if (deniedPermissions.size() == 0) {
            result.add(NAME_PROCESS_CC);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBluekeyChipProcessList() {
        this.regeditBluetoothListener();
        ArrayList<String> result = new ArrayList<String>();
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            int state = adapter.getState();
            if (state == 10 || state == 13) {
                ArrayList<String> arrayList = result;
                return arrayList;
            }
            result.add(NAME_PROCESS_BLUETOOTH);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return result;
        }
    }

    private boolean checkCurDevIsKownHasChip() {
        boolean flag = false;
        String model = Build.MODEL;
        if (hasChipDevList.contains(model)) {
            flag = true;
        }
        return flag;
    }

    private synchronized void regeditBluetoothListener() {
        if (this.bluetoothFlag != 0) {
            return;
        }
        this.bluetoothFlag = 1;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        this.context.registerReceiver(this.bluetoothReceiver, filter);
    }

    private String convertToProviderName(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return "";
        }
        String pkgName = ForCallProvider.getCallPkg((Context)this.context);
        if (TextUtils.isEmpty((CharSequence)pkgName)) {
            return providerNameMap.get(name);
        }
        PackageManager pm = this.context.getPackageManager();
        ComponentName cn = new ComponentName(pkgName, providerNameMap.get(name));
        String authority = "";
        try {
            ProviderInfo pi = pm.getProviderInfo(cn, 128);
            authority = pi.authority;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)authority)) {
            return providerNameMap.get(name);
        }
        return authority;
    }

    private void saveJniApiParam(List<Bundle> list) {
        final ArrayList<Bundle> saveList = new ArrayList<Bundle>();
        saveList.addAll(list);
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                for (Bundle bundle : saveList) {
                    JniApiParam param = (JniApiParam)bundle.getParcelable("JniApiParam");
                    if (param == null) continue;
                    SharedPreferencesUtil.saveCardIdAndType(GetMultiJniApiBinder.this.context, param.cardId, param.chipType);
                }
            }
        });
    }

    static {
        hasChipDevList.add("ACTOMA ACE");
        hasChipDevList.add("HUAWEI eH880");
        hasNotTFDevList.add("ACTOMA ACE");
        providerNameMap.put(NAME_PROCESS_ONBOARD, OnboardProcessProvider.class.getName());
        providerNameMap.put(NAME_PROCESS_TF, TFProcessProvider.class.getName());
        providerNameMap.put(NAME_PROCESS_BLUETOOTH, BluetoothKeyProcessProvider.class.getName());
        providerNameMap.put(NAME_PROCESS_CC, CCProcessProvider.class.getName());
    }
}

