/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.tfcard;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.InsideMultiChipUnitePinManager;
import com.xdja.multichip.JNIPinManager;
import com.xdja.multichip.param.ChipParam;
import com.xdja.multichip.process.IChipParamChangeListener;
import com.xdja.multichip.process.SupperChipBinder;
import com.xdja.skfapi.BlockCipherParam;
import com.xdja.skfapi.DevInfo;
import com.xdja.skfapi.EccCipherBlob;
import com.xdja.skfapi.EccPrivateKeyBlob;
import com.xdja.skfapi.EccPublicKeyBlob;
import com.xdja.skfapi.EccSignatureBlob;
import com.xdja.skfapi.EnvelopedKeyBlob;
import com.xdja.skfapi.FileAttribute;
import com.xdja.skfapi.RsaPrivateKeyBlob;
import com.xdja.skfapi.RsaPublicKeyBlob;
import com.xdja.skfapi.SkfApi;

public class XdjaTFBinder
extends SupperChipBinder {
    private static final String tag = "XdjaTFBinder";
    private long tfDevHandle = -1L;
    private long xdjaTFDevHandle = -1L;
    private final String tf_oper_path_part1 = "/Android/data/";
    private final String tf_oper_path_part2 = "/files/";
    private String tfcardOperFullPath;
    private String tfcardPath;
    private Context context;
    private static JNIAPI jniapi = new JNIAPI();
    private static SkfApi skfApi = new SkfApi();

    XdjaTFBinder(Context context, String tfcardPath) {
        this.context = context;
        this.tfcardOperFullPath = this.getTFOperFullPath(tfcardPath);
        this.tfcardPath = tfcardPath;
    }

    String getTfcardPath() {
        return this.tfcardPath;
    }

    private String getTFOperFullPath(String tfcardPath) {
        return tfcardPath + "/Android/data/" + this.context.getPackageName() + "/files/";
    }

    public ChipParam getChipParam() throws RemoteException {
        String cardId;
        int ret = this.openTFDev();
        Log.i((String)tag, (String)("openRet: " + ret));
        if (ret == 0 && !TextUtils.isEmpty((CharSequence)(cardId = this.getTFCardId()))) {
            ChipParam chipParam = new ChipParam();
            chipParam.chipType = 2;
            chipParam.uniqueID = cardId;
            chipParam.manufacturer = "xdja";
            return chipParam;
        }
        return null;
    }

    private String getTFCardId() {
        long[] devHandle;
        Log.i((String)tag, (String)"getTFCardId: ");
        XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
        int ret = jniapi.GetDevInfo(this.xdjaTFDevHandle, devinfo);
        if (ret == 0) {
            return new String(devinfo.cardid, 0, 32);
        }
        if (ret == -1 && (ret = this.jniOpenTFDev(devHandle = new long[1])) == 0) {
            this.xdjaTFDevHandle = devHandle[0];
            if (jniapi.GetDevInfo(devHandle[0], devinfo) == 0) {
                return new String(devinfo.cardid, 0, 32);
            }
        }
        return "";
    }

    private int openTFDev() {
        long[] devHandle = new long[1];
        int ret = this.jniOpenTFDev(devHandle);
        Log.i((String)tag, (String)("openTFDev: " + ret));
        if (ret == 0) {
            this.xdjaTFDevHandle = devHandle[0];
            XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
            ret = jniapi.GetDevInfo(devHandle[0], devinfo);
            if (ret == 0) {
                String tfCardId = new String(devinfo.cardid, 0, 32);
                Pair<Integer, Long> skfDevHandlePair = this.getSkfDevHandle(tfCardId);
                if ((Integer)skfDevHandlePair.first == 0) {
                    this.tfDevHandle = (Long)skfDevHandlePair.second;
                } else {
                    ret = (Integer)skfDevHandlePair.first;
                }
            }
        }
        return ret;
    }

    private void testEnumDev() {
        int[] devNum = new int[1];
        int enumDevRet = jniapi.EnumDev(528, devNum);
        Log.i((String)tag, (String)("EnumDev ret: " + enumDevRet));
        if (enumDevRet == 0) {
            Log.i((String)tag, (String)("EnumDev num: " + devNum[0]));
        }
    }

    private int jniOpenTFDev(long[] devHandle) {
        int ret = jniapi.OpenDevByNameEx(this.context.getPackageName().getBytes(), devHandle);
        Log.i((String)tag, (String)("jniOpenTFDev OpenDevByNameEx: " + ret));
        if (ret != 0) {
            String tfPathTmp = this.tfcardPath;
            if (!tfPathTmp.endsWith("/")) {
                tfPathTmp = this.tfcardPath + "/";
            }
            Log.i((String)tag, (String)("tfPathTmp : " + tfPathTmp));
            ret = jniapi.OpenDevByName(tfPathTmp.getBytes(), devHandle);
            Log.i((String)tag, (String)("OpenDevByName: " + ret));
        }
        return ret;
    }

    private Pair<Integer, Long> getSkfDevHandle(String cardID) {
        Pair getSfkDevHandleResPair = Pair.create((Object)-97, (Object)-1L);
        long devHandle = -1L;
        byte[] szDevNameList = new byte[260];
        int[] ulSize = new int[1];
        int ret = skfApi.EnumDev(1, szDevNameList, ulSize);
        Log.i((String)tag, (String)("skfApi.EnumDev ret: " + ret));
        if (ret == 0) {
            String namesStr = new String(szDevNameList);
            if (namesStr.contains("\u0000")) {
                String[] devNames = namesStr.split("\u0000");
                Log.i((String)tag, (String)("skfApi.EnumDev: " + namesStr));
                for (String devName : devNames) {
                    long[] phDdev = new long[1];
                    ret = skfApi.ConnectDev(devName.getBytes(), phDdev);
                    Log.i((String)tag, (String)("skfApi.ConnectDev name: " + devName));
                    Log.i((String)tag, (String)("skfApi.ConnectDev ret: " + ret));
                    if (ret != 0) continue;
                    DevInfo devInfo = new DevInfo();
                    ret = skfApi.GetDevInfo(phDdev[0], devInfo);
                    Log.i((String)tag, (String)("skfApi.GetDevInfo ret: " + ret));
                    Log.i((String)tag, (String)("xdja safektf id: " + cardID));
                    Log.i((String)tag, (String)("skfApi.GetDevInfo id: " + new String(devInfo.serialNumber)));
                    String cardIdBySkf = new String(devInfo.reserved, 0, 32);
                    Log.i((String)tag, (String)("skfApi.reserved : " + cardIdBySkf));
                    if (ret != 0 || !cardID.equalsIgnoreCase(cardIdBySkf)) continue;
                    getSfkDevHandleResPair = Pair.create((Object)0, (Object)phDdev[0]);
                    break;
                }
            }
        } else {
            getSfkDevHandleResPair = Pair.create((Object)ret, (Object)-1L);
        }
        return getSfkDevHandleResPair;
    }

    private int checkTfDevHandle() {
        if (this.tfDevHandle != -1L) {
            return 0;
        }
        return this.reOpenTFDev();
    }

    private int reOpenTFDev() {
        int openRet = this.openTFDev();
        if (openRet != 0) {
            int ret = 0xA000001;
            if (openRet == -97) {
                ret = 167772212;
            }
            return ret;
        }
        return 0;
    }

    private boolean isByteArrayEmpty(byte[] bytes) {
        return bytes == null || bytes.length < 0;
    }

    public int WaitForDevEvent(byte[] szDevName, int[] pulDevNameLen, int[] pulEvent) throws RemoteException {
        return -1;
    }

    public int CancelWaitForDevEvent() throws RemoteException {
        return -1;
    }

    public int EnumDev(int bPresent, byte[] szNameList, int[] pulSize) throws RemoteException {
        return 0xA000003;
    }

    public int ConnectDev(byte[] szName, long[] phDdev) throws RemoteException {
        if (phDdev == null || phDdev.length < 1) {
            return 0xA000006;
        }
        int connectRet = 0xA000001;
        if (this.tfDevHandle == -1L) {
            int openTFDevRet = this.openTFDev();
            if (openTFDevRet == 0) {
                phDdev[0] = this.tfDevHandle;
                connectRet = 0;
            }
        } else {
            phDdev[0] = this.tfDevHandle;
            connectRet = 0;
        }
        return connectRet;
    }

    public int DisConnectDev(long hDev) throws RemoteException {
        return 0;
    }

    public int GetDevState(byte[] szDevName, int[] pulDevState) throws RemoteException {
        return skfApi.GetDevState(szDevName, pulDevState);
    }

    public int SetLabel(long hDev, byte[] szLabel) throws RemoteException {
        if (szLabel == null || szLabel.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.SetLabel(this.tfDevHandle, szLabel);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.SetLabel(this.tfDevHandle, szLabel);
        }
        return ret;
    }

    public int GetDevInfo(long hDev, DevInfo pDevInfo) throws RemoteException {
        if (pDevInfo == null) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.GetDevInfo(this.tfDevHandle, pDevInfo);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.GetDevInfo(this.tfDevHandle, pDevInfo);
        }
        return ret;
    }

    public int LockDev(long hDev, int ulTimeOut) throws RemoteException {
        if (ulTimeOut < 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.LockDev(this.tfDevHandle, ulTimeOut);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.LockDev(this.tfDevHandle, ulTimeOut);
        }
        return ret;
    }

    public int UnlockDev(long hDev) throws RemoteException {
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.UnlockDev(this.tfDevHandle);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.UnlockDev(this.tfDevHandle);
        }
        return ret;
    }

    public int Transmit(long hDev, byte[] pbCommand, int ulCommandLen, byte[] pbData, int[] pulDataLen) throws RemoteException {
        if (pbCommand == null || ulCommandLen <= 0 || pbData == null || pbData.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.Transmit(this.tfDevHandle, pbCommand, ulCommandLen, pbData, pulDataLen);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.Transmit(this.tfDevHandle, pbCommand, ulCommandLen, pbData, pulDataLen);
        }
        return ret;
    }

    public int ChangeDevAuthKey(long hDev, byte[] pbKeyValue, int ulKeyLen) throws RemoteException {
        if (pbKeyValue == null || pbKeyValue.length <= 0 || ulKeyLen <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.ChangeDevAuthKey(this.tfDevHandle, pbKeyValue, ulKeyLen);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.ChangeDevAuthKey(this.tfDevHandle, pbKeyValue, ulKeyLen);
        }
        return ret;
    }

    public int DevAuth(long hDev, byte[] pbAuthData, int ulLen) throws RemoteException {
        if (pbAuthData == null || pbAuthData.length <= 0 || ulLen <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.DevAuth(this.tfDevHandle, pbAuthData, ulLen);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.DevAuth(this.tfDevHandle, pbAuthData, ulLen);
        }
        return ret;
    }

    public int ChangePIN(long hApplication, int ulPINType, byte[] szOldPin, byte[] szNewPin, int[] pulRetryCount) throws RemoteException {
        if (hApplication <= 0L || szOldPin == null || szOldPin.length <= 0 || szNewPin == null || szNewPin.length <= 0 || pulRetryCount == null || pulRetryCount.length <= 0) {
            return 0xA000006;
        }
        int ret = skfApi.ChangePIN(hApplication, ulPINType, szOldPin, szNewPin, pulRetryCount);
        this.callUnitePin(ret, ulPINType, szNewPin, "ChangePIN");
        return ret;
    }

    public int GetPINInfo(long hApplication, int ulPINType, int[] pulMaxRetryCount, int[] pulRemainRetryCount, int[] pbDefaultPin) throws RemoteException {
        if (hApplication <= 0L || pulMaxRetryCount == null || pulMaxRetryCount.length <= 0 || pulRemainRetryCount == null || pulRemainRetryCount.length <= 0 || pbDefaultPin == null || pbDefaultPin.length <= 0) {
            return 0xA000006;
        }
        return skfApi.GetPINInfo(hApplication, ulPINType, pulMaxRetryCount, pulRemainRetryCount, pbDefaultPin);
    }

    public int VerifyPIN(long hApplication, int ulPINType, byte[] szPIN, int[] pulRetryCount) throws RemoteException {
        if (hApplication <= 0L || szPIN == null || szPIN.length <= 0 || pulRetryCount == null || pulRetryCount.length <= 0) {
            return 0xA000006;
        }
        int ret = skfApi.VerifyPIN(hApplication, ulPINType, szPIN, pulRetryCount);
        this.callUnitePin(ret, ulPINType, szPIN, "VerifyPIN");
        return ret;
    }

    public int UnblockPIN(long hApplication, byte[] szAdminPIN, byte[] szNewUserPIN, int[] pulRetryCount) throws RemoteException {
        if (hApplication <= 0L || szAdminPIN == null || szAdminPIN.length <= 0 || szNewUserPIN == null || szNewUserPIN.length <= 0 || pulRetryCount == null || pulRetryCount.length <= 0) {
            return 0xA000006;
        }
        int ret = skfApi.UnblockPIN(hApplication, szAdminPIN, szNewUserPIN, pulRetryCount);
        this.callUnitePin(ret, 1, szNewUserPIN, "UnblockPIN");
        return ret;
    }

    public int ClearSecureState(long hApplication) throws RemoteException {
        return skfApi.ClearSecureState(hApplication);
    }

    public int CreateApplication(long hDev, byte[] szAppName, byte[] szAdminPin, int dwAdminPinRetryCount, byte[] szUserPin, int dwUserPinRetryCount, int dwCreateFileRights, long[] phApplication) throws RemoteException {
        if (szAppName == null || szAppName.length <= 0 || szAdminPin == null || szAdminPin.length <= 0 || szUserPin == null || szUserPin.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        return skfApi.CreateApplication(this.tfDevHandle, szAppName, szAdminPin, dwAdminPinRetryCount, szUserPin, dwUserPinRetryCount, dwCreateFileRights, phApplication);
    }

    public int EnumApplication(long hDev, byte[] szAppName, int[] pulSize) throws RemoteException {
        if (szAppName == null || pulSize == null || pulSize.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        return skfApi.EnumApplication(this.tfDevHandle, szAppName, pulSize);
    }

    public int DeleteApplication(long hDev, byte[] szAppName) throws RemoteException {
        if (szAppName == null || szAppName.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        return skfApi.DeleteApplication(this.tfDevHandle, szAppName);
    }

    public int OpenApplication(long hDev, byte[] szAppName, long[] phApplication) throws RemoteException {
        if (szAppName == null || szAppName.length <= 0 || phApplication == null || phApplication.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        return skfApi.OpenApplication(this.tfDevHandle, szAppName, phApplication);
    }

    public int CloseApplication(long hApplication) throws RemoteException {
        if (hApplication <= 0L) {
            return 0xA000006;
        }
        return skfApi.CloseApplication(hApplication);
    }

    public int CreateFile(long hApplication, byte[] szFileName, int ulFileSize, int ulReadRights, int ulWriteRights) throws RemoteException {
        if (hApplication <= 0L || szFileName == null || szFileName.length <= 0 || szFileName.length > 32) {
            return 0xA000006;
        }
        return skfApi.CreateFile(hApplication, szFileName, ulFileSize, ulReadRights, ulWriteRights);
    }

    public int DeleteFile(long hApplication, byte[] szFileName) throws RemoteException {
        if (hApplication <= 0L || szFileName == null || szFileName.length <= 0 || szFileName.length > 32) {
            return 0xA000006;
        }
        return skfApi.DeleteFile(hApplication, szFileName);
    }

    public int EnumFiles(long hApplication, byte[] szFileList, int[] pulSize) throws RemoteException {
        if (hApplication <= 0L || szFileList == null || pulSize == null || pulSize.length <= 0) {
            return 0xA000006;
        }
        return skfApi.EnumFiles(hApplication, szFileList, pulSize);
    }

    public int GetFileInfo(long hApplication, byte[] szFileName, FileAttribute pFileInfo) throws RemoteException {
        if (hApplication <= 0L || szFileName == null || szFileName.length <= 0) {
            return 0xA000006;
        }
        return skfApi.GetFileInfo(hApplication, szFileName, pFileInfo);
    }

    public int ReadFile(long hApplication, byte[] szFileName, int ulOfffset, int ulSize, byte[] pbOutData, int[] pulOutLen) throws RemoteException {
        if (hApplication <= 0L || szFileName == null || szFileName.length <= 0 || pbOutData == null || pbOutData.length <= 0 || pulOutLen == null || pulOutLen.length <= 0) {
            return 0xA000006;
        }
        return skfApi.ReadFile(hApplication, szFileName, ulOfffset, ulSize, pbOutData, pulOutLen);
    }

    public int WriteFile(long hApplication, byte[] szFileName, int ulOfffset, byte[] pbData, int ulSize) throws RemoteException {
        if (hApplication <= 0L || szFileName == null || szFileName.length <= 0 || pbData == null || pbData.length <= 0) {
            return 0xA000006;
        }
        return skfApi.WriteFile(hApplication, szFileName, ulOfffset, pbData, ulSize);
    }

    public int CreateContainer(long hApplication, byte[] szContainerName, long[] pbContainer) throws RemoteException {
        if (hApplication <= 0L || szContainerName == null || szContainerName.length <= 0 || szContainerName.length > 64 || pbContainer == null || pbContainer.length <= 0) {
            return 0xA000006;
        }
        return skfApi.CreateContainer(hApplication, szContainerName, pbContainer);
    }

    public int DeleteContainer(long hApplication, byte[] szContainerName) throws RemoteException {
        if (hApplication <= 0L || szContainerName == null || szContainerName.length <= 0 || szContainerName.length > 64) {
            return 0xA000006;
        }
        return skfApi.DeleteContainer(hApplication, szContainerName);
    }

    public int EnumContainer(long hApplication, byte[] szContainerName, int[] pulSize) throws RemoteException {
        if (hApplication <= 0L || szContainerName == null) {
            return 0xA000006;
        }
        return skfApi.EnumContainer(hApplication, szContainerName, pulSize);
    }

    public int OpenContainer(long hApplication, byte[] szContainerName, long[] pbContainer) throws RemoteException {
        if (hApplication <= 0L || szContainerName == null || szContainerName.length <= 0 || szContainerName.length > 64 || pbContainer == null || pbContainer.length <= 0) {
            return 0xA000006;
        }
        return skfApi.OpenContainer(hApplication, szContainerName, pbContainer);
    }

    public int CloseContainer(long hContainer) throws RemoteException {
        return skfApi.CloseContainer(hContainer);
    }

    public int GetContainerType(long hContainer, int[] pulContainerType) throws RemoteException {
        if (pulContainerType == null || pulContainerType.length <= 0) {
            return 0xA000006;
        }
        return skfApi.GetContainerType(hContainer, pulContainerType);
    }

    public int ImportCertificate(long hContainer, int bSignFlag, byte[] pbCert, int ulCertLen) throws RemoteException {
        if (pbCert == null || pbCert.length <= 0 || ulCertLen <= 0) {
            return 0xA000006;
        }
        return skfApi.ImportCertificate(hContainer, bSignFlag, pbCert, ulCertLen);
    }

    public int ExportCertificate(long hContainer, int bSignFlag, byte[] pbCert, int[] pulCertLen) throws RemoteException {
        return skfApi.ExportCertificate(hContainer, bSignFlag, pbCert, pulCertLen);
    }

    public int GenRandom(long hDev, byte[] pbRandom, int ulRandomLen) throws RemoteException {
        if (pbRandom == null || pbRandom.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.GenRandom(this.tfDevHandle, pbRandom, ulRandomLen);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.GenRandom(this.tfDevHandle, pbRandom, ulRandomLen);
        }
        return ret;
    }

    public int GenExtRSAKey(long hDev, int ulBitsLen, RsaPrivateKeyBlob pBlob) throws RemoteException {
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.GenExtRSAKey(this.tfDevHandle, ulBitsLen, pBlob);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.GenExtRSAKey(this.tfDevHandle, ulBitsLen, pBlob);
        }
        return ret;
    }

    public int GenRSAKeyPair(long hContainer, int ulBitsLen, RsaPublicKeyBlob pBlob) throws RemoteException {
        return skfApi.GenRSAKeyPair(hContainer, ulBitsLen, pBlob);
    }

    public int ImportRSAKeyPair(long hContainer, int ulSymAlgId, byte[] pbWrappedKey, int ulWrappedKeyLen, byte[] pbEncryptedData, int ulEncryptedDataLen) throws RemoteException {
        if (pbWrappedKey == null || pbWrappedKey.length <= 0 || ulWrappedKeyLen <= 0 || pbEncryptedData == null || pbEncryptedData.length <= 0 || ulEncryptedDataLen <= 0) {
            return 0xA000006;
        }
        return skfApi.ImportRSAKeyPair(hContainer, ulSymAlgId, pbWrappedKey, ulWrappedKeyLen, pbEncryptedData, ulEncryptedDataLen);
    }

    public int RSASignData(long hContainer, byte[] pbData, int ulDataLen, byte[] pbSignature, int[] pulSignLen) throws RemoteException {
        if (hContainer <= 0L || pbData == null || pbData.length <= 0 || ulDataLen <= 0 || pbSignature == null || pbSignature.length <= 0 || pulSignLen == null || pulSignLen.length <= 0) {
            return 0xA000006;
        }
        return skfApi.RSASignData(hContainer, pbData, ulDataLen, pbSignature, pulSignLen);
    }

    public int RSAVerify(long hDev, RsaPublicKeyBlob pRSAPubKeyBlob, byte[] pbData, int ulDataLen, byte[] pbSignature, int ulSignLen) throws RemoteException {
        if (pbData == null || pbData.length <= 0 || ulDataLen <= 0 || pbSignature == null || pbSignature.length <= 0 || ulSignLen <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.RSAVerify(this.tfDevHandle, pRSAPubKeyBlob, pbData, ulDataLen, pbSignature, ulSignLen);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.RSAVerify(this.tfDevHandle, pRSAPubKeyBlob, pbData, ulDataLen, pbSignature, ulSignLen);
        }
        return ret;
    }

    public int RSAExportSessionKey(long hContainer, int ulAlgId, RsaPublicKeyBlob pPubKey, byte[] pbData, int[] pulDataLen, long[] phSessionKey) throws RemoteException {
        if (pbData == null || pbData.length <= 0 || pulDataLen == null || pulDataLen.length <= 0 || phSessionKey == null || phSessionKey.length <= 0) {
            return 0xA000006;
        }
        return skfApi.RSAExportSessionKey(hContainer, ulAlgId, pPubKey, pbData, pulDataLen, phSessionKey);
    }

    public int ExtRSAPubKeyOperation(long hDev, RsaPublicKeyBlob pRSAPubKeyBlob, byte[] pbInput, int ulInputLen, byte[] pbOutput, int[] pulOutputLen) throws RemoteException {
        if (pRSAPubKeyBlob == null || pbInput == null || pbInput.length <= 0 || ulInputLen <= 0 || pbOutput == null || pbOutput.length <= 0 || pulOutputLen == null || pulOutputLen.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.ExtRSAPubKeyOperation(this.tfDevHandle, pRSAPubKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.ExtRSAPubKeyOperation(this.tfDevHandle, pRSAPubKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);
        }
        return ret;
    }

    public int ExtRSAPriKeyOperation(long hDev, RsaPrivateKeyBlob pRSAPriKeyBlob, byte[] pbInput, int ulInputLen, byte[] pbOutput, int[] pulOutputLen) throws RemoteException {
        if (pRSAPriKeyBlob == null || pbInput == null || pbInput.length <= 0 || ulInputLen <= 0 || pbOutput == null || pbOutput.length <= 0 || pulOutputLen == null || pulOutputLen.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.ExtRSAPriKeyOperation(this.tfDevHandle, pRSAPriKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.ExtRSAPriKeyOperation(this.tfDevHandle, pRSAPriKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);
        }
        return ret;
    }

    public int GenECCKeyPair(long hContainer, int ulAlgId, EccPublicKeyBlob pBlob) throws RemoteException {
        if (pBlob == null || ulAlgId != 131584) {
            return 0xA000006;
        }
        return skfApi.GenECCKeyPair(hContainer, ulAlgId, pBlob);
    }

    public int ImportECCKeyPair(long hContainer, EnvelopedKeyBlob pEenvlopedKeyBlob) throws RemoteException {
        if (pEenvlopedKeyBlob == null) {
            return 0xA000006;
        }
        return skfApi.ImportECCKeyPair(hContainer, pEenvlopedKeyBlob);
    }

    public int ECCSignData(long hContainer, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {
        if (pbData == null || pbData.length <= 0 || ulDataLen <= 0 || pSignature == null) {
            return 0xA000006;
        }
        return skfApi.ECCSignData(hContainer, pbData, ulDataLen, pSignature);
    }

    public int ECCVerify(long hDev, EccPublicKeyBlob pECCPubKeyBlob, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {
        if (pECCPubKeyBlob == null || pbData == null || pbData.length <= 0 || ulDataLen <= 0 || pSignature == null) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.ECCVerify(this.tfDevHandle, pECCPubKeyBlob, pbData, ulDataLen, pSignature);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.ECCVerify(this.tfDevHandle, pECCPubKeyBlob, pbData, ulDataLen, pSignature);
        }
        return ret;
    }

    public int ECCExportSessionKey(long hContainer, int ulAlgId, EccPublicKeyBlob pPubKey, EccCipherBlob pData, long[] phSessionKey) throws RemoteException {
        if (hContainer <= 0L || pPubKey == null || phSessionKey == null || phSessionKey.length <= 0 || pData == null) {
            return 0xA000006;
        }
        return skfApi.ECCExportSessionKey(hContainer, ulAlgId, pPubKey, pData, phSessionKey);
    }

    public int ExtECCEncrypt(long hDev, EccPublicKeyBlob pECCPubkeyBlob, byte[] pbPlainText, int ulPlainTextLen, EccCipherBlob pCipherText) throws RemoteException {
        if (pECCPubkeyBlob == null || pbPlainText == null || pbPlainText.length <= 0 || ulPlainTextLen <= 0 || pCipherText == null) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.ExtECCEncrypt(this.tfDevHandle, pECCPubkeyBlob, pbPlainText, ulPlainTextLen, pCipherText);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.ExtECCEncrypt(this.tfDevHandle, pECCPubkeyBlob, pbPlainText, ulPlainTextLen, pCipherText);
        }
        return ret;
    }

    public int ExtECCDecrypt(long hDev, EccPrivateKeyBlob pECCPriKeyBlob, EccCipherBlob pCipherText, byte[] pbPlainText, int[] pulPlainTextLen) throws RemoteException {
        if (pECCPriKeyBlob == null) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.ExtECCDecrypt(this.tfDevHandle, pECCPriKeyBlob, pCipherText, pbPlainText, pulPlainTextLen);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.ExtECCDecrypt(this.tfDevHandle, pECCPriKeyBlob, pCipherText, pbPlainText, pulPlainTextLen);
        }
        return ret;
    }

    public int ExtECCSign(long hDev, EccPrivateKeyBlob pECCPriKeyBlob, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {
        if (pECCPriKeyBlob == null || pbData == null || pbData.length <= 0 || ulDataLen <= 0 || pSignature == null) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.ExtECCSign(this.tfDevHandle, pECCPriKeyBlob, pbData, ulDataLen, pSignature);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.ExtECCSign(this.tfDevHandle, pECCPriKeyBlob, pbData, ulDataLen, pSignature);
        }
        return ret;
    }

    public int ExtECCVerify(long hDev, EccPublicKeyBlob pECCPubKeyBlob, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {
        if (pECCPubKeyBlob == null || pbData == null || pbData.length <= 0 || ulDataLen <= 0 || pSignature == null) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.ExtECCVerify(this.tfDevHandle, pECCPubKeyBlob, pbData, ulDataLen, pSignature);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.ExtECCVerify(this.tfDevHandle, pECCPubKeyBlob, pbData, ulDataLen, pSignature);
        }
        return ret;
    }

    public int GenerateAgreementDataWithECC(long hContainer, int ulAlgId, EccPublicKeyBlob pTempECCPubKeyBlob, byte[] pbID, int ulIDLen, long[] phAgreementHandle) throws RemoteException {
        if (hContainer <= 0L || pTempECCPubKeyBlob == null || pbID == null || pbID.length <= 0 || ulIDLen <= 0 || phAgreementHandle == null || phAgreementHandle.length <= 0) {
            return 0xA000006;
        }
        return skfApi.GenerateAgreementDataWithECC(hContainer, ulAlgId, pTempECCPubKeyBlob, pbID, ulIDLen, phAgreementHandle);
    }

    public int GenerateAgreementDataAndKeyWithECC(long hContainer, int ulAlgId, EccPublicKeyBlob pSponsorECCPubKeyBlob, EccPublicKeyBlob pSponsorTempECCPubKeyBlob, EccPublicKeyBlob pTempECCPubKeyBlob, byte[] pbID, int ulIDLen, byte[] pbSponsorID, int ulSponsorIDLen, long[] phKeyHandle) throws RemoteException {
        if (hContainer <= 0L || pTempECCPubKeyBlob == null || pSponsorTempECCPubKeyBlob == null || pbID == null || pbID.length <= 0 || ulIDLen <= 0 || ulIDLen > 32 || pbSponsorID == null || pbSponsorID.length <= 0 || ulSponsorIDLen <= 0 || ulSponsorIDLen > 32 || phKeyHandle == null || phKeyHandle.length <= 0) {
            return 0xA000006;
        }
        return skfApi.GenerateAgreementDataAndKeyWithECC(hContainer, ulAlgId, pSponsorECCPubKeyBlob, pSponsorTempECCPubKeyBlob, pTempECCPubKeyBlob, pbID, ulIDLen, pbSponsorID, ulSponsorIDLen, phKeyHandle);
    }

    public int GenerateKeyWithECC(long hAgreementHandle, EccPublicKeyBlob pECCPubKeyBlob, EccPublicKeyBlob pTempECCPubKeyBlob, byte[] pbID, int ulIDLen, long[] phKeyHandle) throws RemoteException {
        if (hAgreementHandle <= 0L || pbID == null || pbID.length <= 0 || ulIDLen <= 0 || ulIDLen > 32 || phKeyHandle == null || phKeyHandle.length <= 0) {
            return 0xA000006;
        }
        return skfApi.GenerateKeyWithECC(hAgreementHandle, pECCPubKeyBlob, pTempECCPubKeyBlob, pbID, ulIDLen, phKeyHandle);
    }

    public int ExportPublicKey(long hContainer, int bSignFlag, byte[] pbBlob, int[] pulBlobLen) throws RemoteException {
        if (hContainer <= 0L || pulBlobLen == null) {
            return 0xA000006;
        }
        return skfApi.ExportPublicKey(hContainer, bSignFlag, pbBlob, pulBlobLen);
    }

    public int ImportSessionKey(long hContainer, int ulAlgId, byte[] pbWrapedData, int ulWrapedLen, long[] phKey) throws RemoteException {
        if (hContainer <= 0L || pbWrapedData == null || pbWrapedData.length <= 0 || ulWrapedLen <= 0 || phKey == null || phKey.length <= 0) {
            return 0xA000006;
        }
        return skfApi.ImportSessionKey(hContainer, ulAlgId, pbWrapedData, ulWrapedLen, phKey);
    }

    public int SetSymmKey(long hDev, byte[] pbKey, int ulAlgID, long[] phKey) throws RemoteException {
        if (pbKey == null || pbKey.length <= 0 || phKey == null || phKey.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.SetSymmKey(this.tfDevHandle, pbKey, ulAlgID, phKey);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.SetSymmKey(this.tfDevHandle, pbKey, ulAlgID, phKey);
        }
        return ret;
    }

    public int EncryptInit(long hKey, BlockCipherParam EncryptParam) throws RemoteException {
        if (EncryptParam == null) {
            return 0xA000006;
        }
        return skfApi.EncryptInit(hKey, EncryptParam);
    }

    public int Encrypt(long hKey, byte[] pbData, int ulDataLen, byte[] pbEncryptedData, int[] pulEncryptedLen) throws RemoteException {
        if (pbData == null || pbData.length <= 0 || pulEncryptedLen == null) {
            return 0xA000006;
        }
        return skfApi.Encrypt(hKey, pbData, ulDataLen, pbEncryptedData, pulEncryptedLen);
    }

    public int EncryptUpdate(long hKey, byte[] pbData, int ulDataLen, byte[] pbEncryptedData, int[] pulEncryptedLen) throws RemoteException {
        if (pbData == null || pbData.length <= 0 || pulEncryptedLen == null) {
            return 0xA000006;
        }
        return skfApi.EncryptUpdate(hKey, pbData, ulDataLen, pbEncryptedData, pulEncryptedLen);
    }

    public int EncryptFinal(long hKey, byte[] pbEncryptedData, int[] pulEncryptedLen) throws RemoteException {
        if (pulEncryptedLen == null) {
            return 0xA000006;
        }
        return skfApi.EncryptFinal(hKey, pbEncryptedData, pulEncryptedLen);
    }

    public int DecryptInit(long hKey, BlockCipherParam EncryptParam) throws RemoteException {
        if (EncryptParam == null) {
            return 0xA000006;
        }
        return skfApi.DecryptInit(hKey, EncryptParam);
    }

    public int Decrypt(long hKey, byte[] pbEncryptedData, int ulEncryptedLen, byte[] pbData, int[] pulDataLen) throws RemoteException {
        if (pbEncryptedData == null || pbEncryptedData.length <= 0 || ulEncryptedLen <= 0) {
            return 0xA000006;
        }
        return skfApi.Decrypt(hKey, pbEncryptedData, ulEncryptedLen, pbData, pulDataLen);
    }

    public int DecryptUpdate(long hKey, byte[] pbEncryptedData, int ulEncryptedLen, byte[] pbData, int[] pulDataLen) throws RemoteException {
        if (pbEncryptedData == null || pbEncryptedData.length <= 0 || ulEncryptedLen <= 0 || pbData == null || pbData.length <= 0 || pulDataLen == null || pulDataLen.length <= 0) {
            return 0xA000006;
        }
        return skfApi.DecryptUpdate(hKey, pbEncryptedData, ulEncryptedLen, pbData, pulDataLen);
    }

    public int DecryptFinal(long hKey, byte[] pbDecryptedData, int[] pulDecryptedDataLen) throws RemoteException {
        return skfApi.DecryptFinal(hKey, pbDecryptedData, pulDecryptedDataLen);
    }

    public int DigestInit(long hDev, int ulAlgID, EccPublicKeyBlob pPubKey, byte[] pucID, int ulIDLen, long[] phHash) throws RemoteException {
        if (ulAlgID == 1 && (pPubKey == null || pucID == null || pucID.length <= 0)) {
            return 0xA000006;
        }
        if (phHash == null || phHash.length <= 0) {
            return 0xA000006;
        }
        int ret = this.checkTfDevHandle();
        if (ret != 0) {
            return ret;
        }
        ret = skfApi.DigestInit(this.tfDevHandle, ulAlgID, pPubKey, pucID, ulIDLen, phHash);
        if (ret == -1 && (ret = this.reOpenTFDev()) == 0) {
            ret = skfApi.DigestInit(this.tfDevHandle, ulAlgID, pPubKey, pucID, ulIDLen, phHash);
        }
        return ret;
    }

    public int Digest(long hHash, byte[] pbData, int ulDataLen, byte[] phHashData, int[] pulHashLen) throws RemoteException {
        if (pbData == null || pbData.length <= 0 || pulHashLen == null || pulHashLen.length <= 0) {
            return 0xA000006;
        }
        return skfApi.Digest(hHash, pbData, ulDataLen, phHashData, pulHashLen);
    }

    public int DigestUpdate(long hHash, byte[] pbData, int ulDataLen) throws RemoteException {
        if (pbData == null) {
            return 0xA000006;
        }
        return skfApi.DigestUpdate(hHash, pbData, ulDataLen);
    }

    public int DigestFinal(long hHash, byte[] pHashData, int[] pulHashLen) throws RemoteException {
        return skfApi.DigestFinal(hHash, pHashData, pulHashLen);
    }

    public int MacInit(long hKey, BlockCipherParam pMacParam, long[] phMac) throws RemoteException {
        if (phMac == null || phMac.length <= 0 || pMacParam == null) {
            return 0xA000006;
        }
        return skfApi.MacInit(hKey, pMacParam, phMac);
    }

    public int Mac(long hMac, byte[] pbData, int ulDataLen, byte[] pbMacData, int[] pulMacLen) throws RemoteException {
        return skfApi.Mac(hMac, pbData, ulDataLen, pbMacData, pulMacLen);
    }

    public int MacUpdate(long hMac, byte[] pbData, int ulDataLen) throws RemoteException {
        if (pbData == null || pbData.length <= 0 || ulDataLen <= 0) {
            return 0xA000006;
        }
        return skfApi.MacUpdate(hMac, pbData, ulDataLen);
    }

    public int MacFinal(long hMac, byte[] pbMacData, int[] pulMacDataLen) throws RemoteException {
        return skfApi.MacFinal(hMac, pbMacData, pulMacDataLen);
    }

    public int CloseHandle(long hHandle) throws RemoteException {
        return skfApi.CloseHandle(hHandle);
    }

    @Override
    public void regist(IChipParamChangeListener listener) {
    }

    @Override
    public void unRegist(IChipParamChangeListener listener) {
    }

    public int XdjaUnlockPin(int role, byte[] key, byte[] newPin) throws RemoteException {
        if (key == null || key.length <= 0 || newPin == null || newPin.length <= 0) {
            return 0xA000006;
        }
        long[] devHandle = new long[1];
        int ret = jniapi.UnlockPIN(this.xdjaTFDevHandle, role, key, key.length, newPin, newPin.length);
        if (ret == -1 && (ret = this.jniOpenTFDev(devHandle)) == 0) {
            this.xdjaTFDevHandle = devHandle[0];
            ret = jniapi.UnlockPIN(this.xdjaTFDevHandle, role, key, key.length, newPin, newPin.length);
        }
        this.callUnitePin(ret, role, newPin, "XdjaUnlockPin");
        return ret;
    }

    public int XdjaUnlockPinUseUsn(int role, byte[] usn, byte[] usnlockCode, byte[] newPin) throws RemoteException {
        if (usn == null || usn.length <= 0 || newPin == null || newPin.length <= 0 || usnlockCode == null || usnlockCode.length <= 0) {
            return 0xA000006;
        }
        JNIAPI jniapi = new JNIAPI();
        long[] devHandle = new long[1];
        int ret = JNIPinManager.getInstance().XdjaUnlockPinUseUsn(jniapi, this.xdjaTFDevHandle, role, usn, usnlockCode, newPin);
        if (ret == -1 && (ret = this.jniOpenTFDev(devHandle)) == 0) {
            this.xdjaTFDevHandle = devHandle[0];
            ret = JNIPinManager.getInstance().XdjaUnlockPinUseUsn(jniapi, this.xdjaTFDevHandle, role, usn, usnlockCode, newPin);
        }
        this.callUnitePin(ret, role, newPin, "XdjaUnlockPinUseUsn");
        return ret;
    }

    public String XdjaGetCosInfo() throws RemoteException {
        long[] devHandle = new long[1];
        XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
        int ret = jniapi.GetDevInfo(this.xdjaTFDevHandle, devinfo);
        if (ret == -1 && (ret = this.jniOpenTFDev(devHandle)) == 0) {
            this.xdjaTFDevHandle = devHandle[0];
            ret = jniapi.GetDevInfo(devHandle[0], devinfo);
        }
        if (ret == 0) {
            Log.i((String)tag, (String)("XdjaGetCosInfo getDevInof Ret: " + ret));
            return JNIPinManager.getInstance().getCosVer(devinfo);
        }
        return "";
    }

    private String getCardId() {
        DevInfo devInfo = new DevInfo();
        try {
            int ret = this.GetDevInfo(0L, devInfo);
            if (ret == 0) {
                return new String(devInfo.serialNumber);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getPkgName(int callingUid, int callingPid) {
        PackageManager pm = this.context.getPackageManager();
        String[] pkgList = pm.getPackagesForUid(callingUid);
        if (pkgList != null && pkgList.length > 0) {
            return pkgList[0];
        }
        Log.i((String)tag, (String)("TFBinder getPkgName null, uid: " + callingUid));
        return "";
    }

    private void callUnitePin(int ret, int role, byte[] pin, String method) {
        String cardId = this.getCardId();
        InsideMultiChipUnitePinManager.getInstance().handlePinResult(this.context, cardId, role, pin, ret, method, XdjaTFBinder.getCallingUid(), XdjaTFBinder.getCallingPid(), "SkfApi");
    }

    static {
        try {
            System.loadLibrary("skfproxy");
        }
        catch (Throwable t) {
            Log.i((String)tag, (String)"load skf lib exception");
            t.printStackTrace();
        }
    }
}

