package com.xdja.multichip;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Process;
import android.support.annotation.NonNull;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/6/7 <br/>
 * <p>
 * 访问控制，用于给多芯片管理这个module中的操作卡的进程提供权限校验功能
 */
public class AccessControlBinder extends IAccessControl.Stub {

    private Context context;
    private AccessControlJni jni;

    public AccessControlBinder(@NonNull Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        jni = new AccessControlJni(context);
    }

    /**
     * 根据包名判断
     *
     * @param pkgName 包名
     * @param method  要判断的方法
     * @return 0:可用；其他：不可用
     */
    public int checkByPkgName(String pkgName, String method) {
        if (context.getPackageName().equals(pkgName)){
            return 0;
        }
        return jni.checkByPkgName(pkgName, method);
    }

    /**
     * 根据Uid和Pid判断
     *
     * @param uid
     * @param pid
     * @param method 要判断的方法
     * @return 0:可用；其他：不可用
     */
    public int checkByUidPid(int uid, int pid, String method) {
        if (uid == Process.myUid()){
            return 0;
        }
        PackageManager pm = context.getPackageManager();
        String[] pkgList = pm.getPackagesForUid(uid);
        for (String pkgName : pkgList ){
            int ret = checkByPkgName(pkgName,method);
            if (ret == 0){
                return 0;
            }
        }
        return -1;
    }
}
