package com.xdja.multichip.process.board;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.InsideMultiChipUnitePinManager;
import com.xdja.multichip.JNIPinManager;
import com.xdja.multichip.param.ChipParam;
import com.xdja.multichip.process.IChipParamChangeListener;
import com.xdja.skfapi.BlockCipherParam;
import com.xdja.skfapi.DevInfo;
import com.xdja.skfapi.EccCipherBlob;
import com.xdja.skfapi.EccPrivateKeyBlob;
import com.xdja.skfapi.EccPublicKeyBlob;
import com.xdja.skfapi.EccSignatureBlob;
import com.xdja.skfapi.EnvelopedKeyBlob;
import com.xdja.skfapi.FileAttribute;
import com.xdja.skfapi.RsaPrivateKeyBlob;
import com.xdja.skfapi.RsaPublicKeyBlob;
import com.xdja.skfapi.SkfApi;
import com.xdja.skfapi.SkfApiCode;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/5/27 <br/>
 * <p>
 * 板载芯片 之 信大捷安芯片
 */

public class OnboardXdjaChipBinder extends OnboardChipBinder {

    private static SkfApi skfApi = new SkfApi();

    private static final String tag = "OnboardXdjaChipBinder";


    private long[] phDdev = new long[1];

    protected OnboardXdjaChipBinder(Context context, String dev) {
        super(context, dev);
    }

    @Override
    public ChipParam getChipParam() throws RemoteException {

        DevInfo devinfo = new DevInfo();
        int ret =GetDevInfo(phDdev[0],devinfo);
        if (ret ==  SkfApiCode.SAR_OK){
            ChipParam chipParam = new ChipParam();
            chipParam.chipType = ChipParam.TYPE_ONBOARD;
            chipParam.manufacturer = ChipParam.MANUFACTURER_XDJA;
            chipParam.uniqueID = new String(devinfo.serialNumber);
            return chipParam;
        }
        return null;
    }

    @Override
    public int WaitForDevEvent(byte[] szDevName, int[] pulDevNameLen, int[] pulEvent) throws RemoteException {
        return skfApi.WaitForDevEvent(this.devName, pulDevNameLen, pulEvent);
    }

    @Override
    public int CancelWaitForDevEvent() throws RemoteException {
        return skfApi.CancelWaitForDevEvent();
    }

    @Override
    public int EnumDev(int bPresent, byte[] szNameList, int[] pulSize) throws RemoteException {
        return skfApi.EnumDev(bPresent, szNameList, pulSize);
    }

    @Override
    public int ConnectDev(byte[] szName, long[] phDdev) throws RemoteException {
        return skfApi.ConnectDev(this.devName, this.phDdev);
    }


    @Override
    public int DisConnectDev(long hDev) throws RemoteException {
        return skfApi.DisConnectDev(this.phDdev[0]);
    }


    @Override
    public int GetDevState(byte[] szDevName, int[] pulDevState) throws RemoteException {
        return skfApi.GetDevState(this.devName, pulDevState);
    }

    @Override
    public int SetLabel(long hDev, byte[] szLabel) throws RemoteException {

        int ret = skfApi.SetLabel(this.phDdev[0], szLabel);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret = skfApi.SetLabel(this.phDdev[0], szLabel);
        }
        return ret;
    }

    @Override
    public int GetDevInfo(long hDev, DevInfo pDevInfo) throws RemoteException {
        int ret = skfApi.GetDevInfo(this.phDdev[0], pDevInfo);
        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret = skfApi.GetDevInfo(this.phDdev[0], pDevInfo);
        }
        return ret;
    }

    @Override
    public int LockDev(long hDev, int ulTimeOut) throws RemoteException {
        int ret = skfApi.LockDev(this.phDdev[0], ulTimeOut);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret = skfApi.LockDev(this.phDdev[0], ulTimeOut);
        }
        return ret;
    }

    @Override
    public int UnlockDev(long hDev) throws RemoteException {
        return skfApi.UnlockDev(this.phDdev[0]);
    }

    @Override
    public int Transmit(long hDev, byte[] pbCommand, int ulCommandLen, byte[] pbData, int[] pulDataLen) throws RemoteException {

        int ret =   skfApi.Transmit(this.phDdev[0], pbCommand, ulCommandLen, pbData, pulDataLen);


        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =  skfApi.Transmit(this.phDdev[0], pbCommand, ulCommandLen, pbData, pulDataLen);

        }
        return ret;

    }

    @Override
    public int ChangeDevAuthKey(long hDev, byte[] pbKeyValue, int ulKeyLen) throws RemoteException {

        int ret =    skfApi.ChangeDevAuthKey(this.phDdev[0], pbKeyValue, ulKeyLen);


        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =   skfApi.ChangeDevAuthKey(this.phDdev[0], pbKeyValue, ulKeyLen);

        }
        return ret;



    }

    @Override
    public int DevAuth(long hDev, byte[] pbAuthData, int ulLen) throws RemoteException {

        int ret =  skfApi.DevAuth(this.phDdev[0], pbAuthData, ulLen);


        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =   skfApi.DevAuth(this.phDdev[0], pbAuthData, ulLen);

        }
        return ret;



    }

    @Override
    public int ChangePIN(long hApplication, int ulPINType, byte[] szOldPin, byte[] szNewPin, int[] pulRetryCount) throws RemoteException {
        int ret;
//        ret = AccessControlManager.getInstance(this.context).checkByUidPid(getCallingUid(),getCallingPid(),"ChangePIN");
//        if (ret !=0){
//            return ErrorCode.RET_NO_POWER;
//        }
        ret = skfApi.ChangePIN(hApplication, ulPINType, szOldPin, szNewPin, pulRetryCount);
        callUnitePin(ret,ulPINType,szNewPin,"ChangePIN");
        return ret;
    }

    @Override
    public int GetPINInfo(long hApplication, int ulPINType, int[] pulMaxRetryCount, int[] pulRemainRetryCount, int[] pbDefaultPin) throws RemoteException {
        return skfApi.GetPINInfo(hApplication, ulPINType, pulMaxRetryCount, pulRemainRetryCount, pbDefaultPin);
    }

    @Override
    public int VerifyPIN(long hApplication, int ulPINType, byte[] szPIN, int[] pulRetryCount) throws RemoteException {
        int ret;
//        ret = AccessControlManager.getInstance(this.context).checkByUidPid(getCallingUid(),getCallingPid(),"VerifyPIN");
//        if (ret != 0){
//            return ErrorCode.RET_NO_POWER;
//        }
        ret = skfApi.VerifyPIN(hApplication, ulPINType, szPIN, pulRetryCount);
        callUnitePin(ret,ulPINType,szPIN,"VerifyPIN");
        return ret;
    }

    @Override
    public int UnblockPIN(long hApplication, byte[] szAdminPIN, byte[] szNewUserPIN, int[] pulRetryCount) throws RemoteException {
        int ret;
//        int ret = AccessControlManager.getInstance(this.context).checkByUidPid(getCallingUid(),getCallingPid(),"UnblockPIN");
//        if (ret!=0){
//            return ErrorCode.RET_NO_POWER;
//        }
        ret = skfApi.UnblockPIN(hApplication, szAdminPIN, szNewUserPIN, pulRetryCount);
        callUnitePin(ret,0x01,szNewUserPIN,"UnblockPIN");
        return ret;
    }


    @Override
    public int ClearSecureState(long hApplication) throws RemoteException {
        return skfApi.ClearSecureState(hApplication);
    }

    @Override
    public int CreateApplication(long hDev, byte[] szAppName, byte[] szAdminPin, int dwAdminPinRetryCount, byte[] szUserPin, int dwUserPinRetryCount, int dwCreateFileRights, long[] phApplication) throws RemoteException {


        int ret =  skfApi.CreateApplication(this.phDdev[0], szAppName, szAdminPin, dwAdminPinRetryCount, szUserPin, dwUserPinRetryCount, dwCreateFileRights, phApplication);


        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =   skfApi.CreateApplication(this.phDdev[0], szAppName, szAdminPin, dwAdminPinRetryCount, szUserPin, dwUserPinRetryCount, dwCreateFileRights, phApplication);

        }


        return ret;


    }

    @Override
    public int EnumApplication(long hDev, byte[] szAppName, int[] pulSize) throws RemoteException {
        int ret =   skfApi.EnumApplication(this.phDdev[0], szAppName, pulSize);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =    skfApi.EnumApplication(this.phDdev[0], szAppName, pulSize);
        }
        return ret;
    }

    @Override
    public int DeleteApplication(long hDev, byte[] szAppName) throws RemoteException {

        int ret =   skfApi.DeleteApplication(this.phDdev[0], szAppName);


        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =    skfApi.DeleteApplication(this.phDdev[0], szAppName);

        }

        return ret;
    }

    @Override
    public int OpenApplication(long hDev, byte[] szAppName, long[] phApplication) throws RemoteException {

        int ret =    skfApi.OpenApplication(this.phDdev[0], szAppName, phApplication);


        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =     skfApi.OpenApplication(this.phDdev[0], szAppName, phApplication);

        }


        return ret;


    }

    @Override
    public int CloseApplication(long hApplication) throws RemoteException {
        return skfApi.CloseApplication(hApplication);
    }

    @Override
    public int CreateFile(long hApplication, byte[] szFileName, int ulFileSize, int ulReadRights, int ulWriteRights) throws RemoteException {
        return skfApi.CreateFile(hApplication, szFileName, ulFileSize, ulReadRights, ulWriteRights);
    }

    @Override
    public int DeleteFile(long hApplication, byte[] szFileName) throws RemoteException {
        return skfApi.DeleteFile(hApplication, szFileName);
    }

    @Override
    public int EnumFiles(long hApplication, byte[] szFileList, int[] pulSize) throws RemoteException {

        return skfApi.EnumFiles(hApplication, szFileList, pulSize);
    }

    @Override
    public int GetFileInfo(long hApplication, byte[] szFileName, FileAttribute pFileInfo) throws RemoteException {
        return skfApi.GetFileInfo(hApplication, szFileName, pFileInfo);
    }

    @Override
    public int ReadFile(long hApplication, byte[] szFileName, int ulOfffset, int ulSize, byte[] pbOutData, int[] pulOutLen) throws RemoteException {
        return skfApi.ReadFile(hApplication, szFileName, ulOfffset, ulSize, pbOutData, pulOutLen);
    }

    @Override
    public int WriteFile(long hApplication, byte[] szFileName, int ulOfffset, byte[] pbData, int ulSize) throws RemoteException {
        return skfApi.WriteFile(hApplication, szFileName, ulOfffset, pbData, ulSize);
    }

    @Override
    public int CreateContainer(long hApplication, byte[] szContainerName, long[] pbContainer) throws RemoteException {
        return skfApi.CreateContainer(hApplication, szContainerName, pbContainer);
    }

    @Override
    public int DeleteContainer(long hApplication, byte[] szContainerName) throws RemoteException {
        return skfApi.DeleteContainer(hApplication, szContainerName);
    }

    @Override
    public int EnumContainer(long hApplication, byte[] szContainerName, int[] pulSize) throws RemoteException {

        return skfApi.EnumContainer(hApplication, szContainerName, pulSize);
    }

    @Override
    public int OpenContainer(long hApplication, byte[] szContainerName, long[] pbContainer) throws RemoteException {
        return skfApi.OpenContainer(hApplication, szContainerName, pbContainer);
    }

    @Override
    public int CloseContainer(long hContainer) throws RemoteException {
        return skfApi.CloseContainer(hContainer);
    }

    @Override
    public int GetContainerType(long hContainer, int[] pulContainerType) throws RemoteException {
        return skfApi.GetContainerType(hContainer, pulContainerType);
    }

    @Override
    public int ImportCertificate(long hContainer, int bSignFlag, byte[] pbCert, int ulCertLen) throws RemoteException {
        return skfApi.ImportCertificate(hContainer, bSignFlag, pbCert, ulCertLen);
    }

    @Override
    public int ExportCertificate(long hContainer, int bSignFlag, byte[] pbCert, int[] pulCertLen) throws RemoteException {

        return skfApi.ExportCertificate(hContainer, bSignFlag, pbCert, pulCertLen);
    }

    @Override
    public int GenRandom(long hDev, byte[] pbRandom, int ulRandomLen) throws RemoteException {

        int ret =    skfApi.GenRandom(this.phDdev[0], pbRandom, ulRandomLen);


        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =   skfApi.GenRandom(this.phDdev[0], pbRandom, ulRandomLen);
        }

        return ret;
    }

    @Override
    public int GenExtRSAKey(long hDev, int ulBitsLen, RsaPrivateKeyBlob pBlob) throws RemoteException {

        int ret =    skfApi.GenExtRSAKey(this.phDdev[0], ulBitsLen, pBlob);


        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =    skfApi.GenExtRSAKey(this.phDdev[0], ulBitsLen, pBlob);

        }


        return ret;


    }

    @Override
    public int GenRSAKeyPair(long hContainer, int ulBitsLen, RsaPublicKeyBlob pBlob) throws RemoteException {
        return skfApi.GenRSAKeyPair(hContainer, ulBitsLen, pBlob);
    }

    @Override
    public int ImportRSAKeyPair(long hContainer, int ulSymAlgId, byte[] pbWrappedKey, int ulWrappedKeyLen, byte[] pbEncryptedData, int ulEncryptedDataLen) throws RemoteException {
        return skfApi.ImportRSAKeyPair(hContainer, ulSymAlgId, pbWrappedKey, ulWrappedKeyLen, pbEncryptedData, ulEncryptedDataLen);
    }

    @Override
    public int RSASignData(long hContainer, byte[] pbData, int ulDataLen, byte[] pbSignature, int[] pulSignLen) throws RemoteException {
        return skfApi.RSASignData(hContainer, pbData, ulDataLen, pbSignature, pulSignLen);
    }

    @Override
    public int RSAVerify(long hDev, RsaPublicKeyBlob pRSAPubKeyBlob, byte[] pbData, int ulDataLen, byte[] pbSignature, int ulSignLen) throws RemoteException {


        int ret =     skfApi.RSAVerify(this.phDdev[0], pRSAPubKeyBlob, pbData, ulDataLen, pbSignature, ulSignLen);


        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =     skfApi.RSAVerify(this.phDdev[0], pRSAPubKeyBlob, pbData, ulDataLen, pbSignature, ulSignLen);

        }


        return ret;



    }

    @Override
    public int RSAExportSessionKey(long hContainer, int ulAlgId, RsaPublicKeyBlob pPubKey, byte[] pbData, int[] pulDataLen, long[] phSessionKey) throws RemoteException {
        return skfApi.RSAExportSessionKey(hContainer, ulAlgId, pPubKey, pbData, pulDataLen, phSessionKey);
    }

    @Override
    public int ExtRSAPubKeyOperation(long hDev, RsaPublicKeyBlob pRSAPubKeyBlob, byte[] pbInput, int ulInputLen, byte[] pbOutput, int[] pulOutputLen) throws RemoteException {

        int ret =   skfApi.ExtRSAPubKeyOperation(this.phDdev[0], pRSAPubKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =   skfApi.ExtRSAPubKeyOperation(this.phDdev[0], pRSAPubKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);

        }

        return ret;

    }

    @Override
    public int ExtRSAPriKeyOperation(long hDev, RsaPrivateKeyBlob pRSAPriKeyBlob, byte[] pbInput, int ulInputLen, byte[] pbOutput, int[] pulOutputLen) throws RemoteException {


        int ret =   skfApi.ExtRSAPriKeyOperation(this.phDdev[0], pRSAPriKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =   skfApi.ExtRSAPriKeyOperation(this.phDdev[0], pRSAPriKeyBlob, pbInput, ulInputLen, pbOutput, pulOutputLen);

        }

        return ret;

    }

    @Override
    public int GenECCKeyPair(long hContainer, int ulAlgId, EccPublicKeyBlob pBlob) throws RemoteException {
        return skfApi.GenECCKeyPair(hContainer, ulAlgId, pBlob);
    }

    @Override
    public int ImportECCKeyPair(long hContainer, EnvelopedKeyBlob pEenvlopedKeyBlob) throws RemoteException {
        return skfApi.ImportECCKeyPair(hContainer, pEenvlopedKeyBlob);
    }

    @Override
    public int ECCSignData(long hContainer, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {
        return skfApi.ECCSignData(hContainer, pbData, ulDataLen, pSignature);
    }

    @Override
    public int ECCVerify(long hDev, EccPublicKeyBlob pECCPubKeyBlob, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {

        int ret =   skfApi.ECCVerify(this.phDdev[0], pECCPubKeyBlob, pbData, ulDataLen, pSignature);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =   skfApi.ECCVerify(this.phDdev[0], pECCPubKeyBlob, pbData, ulDataLen, pSignature);

        }

        return ret;


    }

    @Override
    public int ECCExportSessionKey(long hContainer, int ulAlgId, EccPublicKeyBlob pPubKey, EccCipherBlob pData, long[] phSessionKey) throws RemoteException {
        return skfApi.ECCExportSessionKey(hContainer, ulAlgId, pPubKey, pData, phSessionKey);
    }


    @Override
    public int ExtECCEncrypt(long hDev, EccPublicKeyBlob pECCPubkeyBlob, byte[] pbPlainText, int ulPlainTextLen, EccCipherBlob pCipherText) throws RemoteException {


        int ret =   skfApi.ExtECCEncrypt(this.phDdev[0], pECCPubkeyBlob, pbPlainText, ulPlainTextLen, pCipherText);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =   skfApi.ExtECCEncrypt(this.phDdev[0], pECCPubkeyBlob, pbPlainText, ulPlainTextLen, pCipherText);

        }

        return ret;

    }

    @Override
    public int ExtECCDecrypt(long hDev, EccPrivateKeyBlob pECCPriKeyBlob, EccCipherBlob pCipherText, byte[] pbPlainText, int[] pulPlainTextLen) throws RemoteException {

        int ret =   skfApi.ExtECCDecrypt(this.phDdev[0], pECCPriKeyBlob, pCipherText, pbPlainText, pulPlainTextLen);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =  skfApi.ExtECCDecrypt(this.phDdev[0], pECCPriKeyBlob, pCipherText, pbPlainText, pulPlainTextLen);

        }

        return ret;

    }

    @Override
    public int ExtECCSign(long hDev, EccPrivateKeyBlob pECCPriKeyBlob, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {
        int ret =   skfApi.ExtECCSign(this.phDdev[0], pECCPriKeyBlob, pbData, ulDataLen, pSignature);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =  skfApi.ExtECCSign(this.phDdev[0], pECCPriKeyBlob, pbData, ulDataLen, pSignature);

        }

        return ret;


    }

    @Override
    public int ExtECCVerify(long hDev, EccPublicKeyBlob pECCPubKeyBlob, byte[] pbData, int ulDataLen, EccSignatureBlob pSignature) throws RemoteException {

        int ret =   skfApi.ExtECCVerify(this.phDdev[0], pECCPubKeyBlob, pbData, ulDataLen, pSignature);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =  skfApi.ExtECCVerify(this.phDdev[0], pECCPubKeyBlob, pbData, ulDataLen, pSignature);

        }

        return ret;
    }

    @Override
    public int GenerateAgreementDataWithECC(long hContainer, int ulAlgId, EccPublicKeyBlob pTempECCPubKeyBlob, byte[] pbID, int ulIDLen, long[] phAgreementHandle) throws RemoteException {
        return skfApi.GenerateAgreementDataWithECC(hContainer, ulAlgId, pTempECCPubKeyBlob, pbID, ulIDLen, phAgreementHandle);
    }

    @Override
    public int GenerateAgreementDataAndKeyWithECC(long hContainer, int ulAlgId, EccPublicKeyBlob pSponsorECCPubKeyBlob, EccPublicKeyBlob pSponsorTempECCPubKeyBlob, EccPublicKeyBlob pTempECCPubKeyBlob, byte[] pbID, int ulIDLen, byte[] pbSponsorID, int ulSponsorIDLen, long[] phKeyHandle) throws RemoteException {
        return skfApi.GenerateAgreementDataAndKeyWithECC(hContainer, ulAlgId, pSponsorECCPubKeyBlob, pSponsorTempECCPubKeyBlob, pTempECCPubKeyBlob, pbID, ulIDLen, pbSponsorID, ulSponsorIDLen, phKeyHandle);
    }

    @Override
    public int GenerateKeyWithECC(long hAgreementHandle, EccPublicKeyBlob pECCPubKeyBlob, EccPublicKeyBlob pTempECCPubKeyBlob, byte[] pbID, int ulIDLen, long[] phKeyHandle) throws RemoteException {
        return skfApi.GenerateKeyWithECC(hAgreementHandle, pECCPubKeyBlob, pTempECCPubKeyBlob, pbID, ulIDLen, phKeyHandle);
    }

    @Override
    public int ExportPublicKey(long hContainer, int bSignFlag, byte[] pbBlob, int[] pulBlobLen) throws RemoteException {
        return skfApi.ExportPublicKey(hContainer, bSignFlag, pbBlob, pulBlobLen);
    }

    @Override
    public int ImportSessionKey(long hContainer, int ulAlgId, byte[] pbWrapedData, int ulWrapedLen, long[] phKey) throws RemoteException {
        return skfApi.ImportSessionKey(hContainer, ulAlgId, pbWrapedData, ulWrapedLen, phKey);
    }

    @Override
    public int SetSymmKey(long hDev, byte[] pbKey, int ulAlgID, long[] phKey) throws RemoteException {

        int ret =   skfApi.SetSymmKey(this.phDdev[0], pbKey, ulAlgID, phKey);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =  skfApi.SetSymmKey(this.phDdev[0], pbKey, ulAlgID, phKey);

        }

        return ret;


    }

    @Override
    public int EncryptInit(long hKey, BlockCipherParam EncryptParam) throws RemoteException {
        return skfApi.EncryptInit(hKey, EncryptParam);
    }

    @Override
    public int Encrypt(long hKey, byte[] pbData, int ulDataLen, byte[] pbEncryptedData, int[] pulEncryptedLen) throws RemoteException {
        return  skfApi.Encrypt(hKey, pbData, ulDataLen, pbEncryptedData, pulEncryptedLen);
    }

    @Override
    public int EncryptUpdate(long hKey, byte[] pbData, int ulDataLen, byte[] pbEncryptedData, int[] pulEncryptedLen) throws RemoteException {
        return skfApi.EncryptUpdate(hKey, pbData, ulDataLen, pbEncryptedData, pulEncryptedLen);
    }

    @Override
    public int EncryptFinal(long hKey, byte[] pbEncryptedData, int[] pulEncryptedLen) throws RemoteException {
        return skfApi.EncryptFinal(hKey, pbEncryptedData, pulEncryptedLen);
    }

    @Override
    public int DecryptInit(long hKey, BlockCipherParam EncryptParam) throws RemoteException {
        return skfApi.DecryptInit(hKey, EncryptParam);
    }

    @Override
    public int Decrypt(long hKey, byte[] pbEncryptedData, int ulEncryptedLen, byte[] pbData, int[] pulDataLen) throws RemoteException {
        return skfApi.Decrypt(hKey, pbEncryptedData, ulEncryptedLen, pbData, pulDataLen);
    }

    @Override
    public int DecryptUpdate(long hKey, byte[] pbEncryptedData, int ulEncryptedLen, byte[] pbData, int[] pulDataLen) throws RemoteException {
        return skfApi.DecryptUpdate(hKey, pbEncryptedData, ulEncryptedLen, pbData, pulDataLen);
    }

    @Override
    public int DecryptFinal(long hKey, byte[] pbDecryptedData, int[] pulDecryptedDataLen) throws RemoteException {

        return skfApi.DecryptFinal(hKey, pbDecryptedData, pulDecryptedDataLen);
    }

    @Override
    public int DigestInit(long hDev, int ulAlgID, EccPublicKeyBlob pPubKey, byte[] pucID, int ulIDLen, long[] phHash) throws RemoteException {

        int ret =   skfApi.DigestInit(this.phDdev[0], ulAlgID, pPubKey, pucID, ulIDLen, phHash);

        if (ret == SkfApiCode.SAR_INVALIDPARAMERR){
            ret = ConnectDev(this.devName,this.phDdev);
            if (ret != SkfApiCode.SAR_OK){
                return ret;
            }
            ret =  skfApi.DigestInit(this.phDdev[0], ulAlgID, pPubKey, pucID, ulIDLen, phHash);

        }
        return ret;
    }

    @Override
    public int Digest(long hHash, byte[] pbData, int ulDataLen, byte[] phHashData, int[] pulHashLen) throws RemoteException {
        return skfApi.Digest(hHash, pbData, ulDataLen, phHashData, pulHashLen);
    }

    @Override
    public int DigestUpdate(long hHash, byte[] pbData, int ulDataLen) throws RemoteException {
        return skfApi.DigestUpdate(hHash, pbData, ulDataLen);
    }

    @Override
    public int DigestFinal(long hHash, byte[] pHashData, int[] pulHashLen) throws RemoteException {
        return skfApi.DigestFinal(hHash, pHashData, pulHashLen);
    }

    @Override
    public int MacInit(long hKey, BlockCipherParam pMacParam, long[] phMac) throws RemoteException {
        return skfApi.MacInit(hKey, pMacParam, phMac);
    }

    @Override
    public int Mac(long hMac, byte[] pbData, int ulDataLen, byte[] pbMacData, int[] pulMacLen) throws RemoteException {
        return skfApi.Mac(hMac, pbData, ulDataLen, pbMacData, pulMacLen);
    }

    @Override
    public int MacUpdate(long hMac, byte[] pbData, int ulDataLen) throws RemoteException {
        return skfApi.MacUpdate(hMac, pbData, ulDataLen);
    }

    @Override
    public int MacFinal(long hMac, byte[] pbMacData, int[] pulMacDataLen) throws RemoteException {

        return skfApi.MacFinal(hMac, pbMacData, pulMacDataLen);
    }

    @Override
    public int CloseHandle(long hHandle) throws RemoteException {
        return skfApi.CloseHandle(hHandle);
    }

    @Override
    public int XdjaUnlockPin(int role, byte[] key, byte[] newPin) throws RemoteException {

        //add 2017年7月28日16:05:25 接口调用权限校验,解锁后调用统一PIN码
        //delete 2018年10月18日16:11:44 去掉
//        AccessControlManager accessControlManager = AccessControlManager.getInstance(context);
//        int checkRes = accessControlManager.checkByUidPid(getCallingUid(), getCallingPid(), "XdjaUnlockPin");
//        if(checkRes != 0){
//            Log.i(tag,"checkByUidPid res: " + checkRes);
//            return ErrorCode.RET_NO_POWER;
//        }

        int ret;
        JNIAPI jniapi = new JNIAPI();
        long[] handle = new long[1];
        ret = jniapi.OpenDev(0,handle);
        if (ret != 0){
            return ret;
        }

        ret =  JNIPinManager.getInstance().XdjaUnlockPin(jniapi,handle[0],role,key,newPin);

        //调用统一PIN码接口，保存更新
        callUnitePin(ret,role,newPin,"XdjaUnlockPin");

        return ret;
    }

    @Override
    public int XdjaUnlockPinUseUsn(int role, byte[] usn, byte[] usnlockCode, byte[] newPin) throws RemoteException {

        //add 2017年7月28日16:05:25 接口调用权限校验,解锁后调用统一PIN码
        //delete 2018年10月18日16:11:44 去掉
//        AccessControlManager accessControlManager = AccessControlManager.getInstance(context);
//        int checkRes = accessControlManager.checkByUidPid(getCallingUid(), getCallingPid(), "XdjaUnlockPinUseUsn");
//        if(checkRes != 0){
//            Log.i(tag,"checkByUidPid res: " + checkRes);
//            return ErrorCode.RET_NO_POWER;
//        }

        int ret;
        JNIAPI jniapi = new JNIAPI();
        long[] handle = new long[1];
        ret = jniapi.OpenDev(0,handle);
        if (ret != 0){
            return ret;
        }
        ret = JNIPinManager.getInstance().XdjaUnlockPinUseUsn(jniapi, handle[0],role, usn,  usnlockCode,  newPin);

        //调用统一PIN码接口，保存更新
        callUnitePin(ret,role,newPin,"XdjaUnlockPinUseUsn");

        return ret;
    }

    @Override
    public String XdjaGetCosInfo() throws RemoteException {
        int ret;
        JNIAPI jniapi = new JNIAPI();
        long[] handle = new long[1];
        ret = jniapi.OpenDev(0,handle);
        if (ret != 0){
            return "";
        }
        XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
        int getDevInfoRet = jniapi.GetDevInfo(handle[0], devinfo);
        if (getDevInfoRet == 0){
            return JNIPinManager.getInstance().getCosVer(devinfo);
        }
        return "";
    }

    /**
     * 注册监听
     *
     * @param listener
     */
    @Override
    public void regist(IChipParamChangeListener listener) {

    }

    /**
     * 取消注册监听
     *
     * @param listener
     */
    @Override
    public void unRegist(IChipParamChangeListener listener) {

    }

    /**
     * 得到卡号
     * @return 卡号
     */
    private String getCardId(){
        DevInfo devInfo = new DevInfo();
        try {
            int ret = GetDevInfo(0,devInfo);
            if (ret == 0){
                return new String(devInfo.serialNumber);
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 获取包名
     * @param callingUid uid
     * @param callingPid pid
     * @return 包名，如果获取不到返回空字符串
     */
    private String getPkgName(int callingUid,int callingPid){
        PackageManager pm = context.getPackageManager();
        String[] pkgList = pm.getPackagesForUid(callingUid);
        if(pkgList != null && pkgList.length > 0){
            return pkgList[0];
        }else {
            Log.i(tag,"XdjaChipBinder getPkgName null, uid: " + callingUid);
            return "";
        }
    }

    /**
     * 调用统一PIN码，将结果告之
     * @param ret 方法执行结果
     * @param role 角色
     * @param pin PIN码
     * @param method 方法名
     */
    private void callUnitePin(int ret,int role,byte[] pin,String method) {
        String cardId = getCardId();
        InsideMultiChipUnitePinManager.getInstance().handlePinResult(context,
                cardId,
                role,
                pin,
                ret,
                method,
                getCallingUid(),
                getCallingPid(),
                "SkfApi");
    }
}
