package com.xdja.multichip.process.board;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.process.SupperChipBinder;
import com.xdja.skfapi.DevInfo;
import com.xdja.skfapi.SkfApi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * Created by guoyaxin on 2017/6/9.
 */

public class XdjaBinderManager {

    private SkfApi skfApi = new SkfApi();

    private static XdjaBinderManager instance;
    private Context context;

    private XdjaBinderManager(Context context) {
        this.context = context.getApplicationContext();
    }

    public static XdjaBinderManager getInstance(Context context) {
        if (instance == null) {
            synchronized (XdjaBinderManager.class) {
                if (instance == null) {
                    instance = new XdjaBinderManager(context);
                }
            }
        }
        return instance;
    }


    private  HashMap<String,OnboardXdjaChipBinder> iBinderHashMap = new HashMap<>();

    public List<IBinder> getAllXdjaChipBinder(){
        List<IBinder> chipBinders = new ArrayList<>();
        byte szDevNameList[] = new byte[260];
        int[] ulSize = new int[1];
        int ret = skfApi.EnumDev(1, szDevNameList, ulSize);
        if (ret==0){
            String namesStr = new String(szDevNameList);
            if (namesStr.contains("\0")){
                String[] devNames = namesStr.split("\0");
                for (String devName : devNames){
                    OnboardXdjaChipBinder chipBinder;
                    if (iBinderHashMap.containsKey(devName)){
                        chipBinder = iBinderHashMap.get(devName);
                    }else {
                        chipBinder =  new OnboardXdjaChipBinder(this.context,devName);
                        // add start---- by zhangxiaolong
                        // 20170718 判断一下打开的设备是否是芯片类型的
                        DevInfo devInfo = new DevInfo();
                        try {
                            chipBinder.GetDevInfo(0,devInfo);
                            int type =  bytesToShort(Arrays.copyOfRange(devInfo.reserved,35,37));
                            if (type != JNIAPI.CT_TF_XDJA_CHIP && type != JNIAPI.CT_XDJA_SPI){
                                continue;
                            }
                        } catch (RemoteException e) {
                            e.printStackTrace();
                            continue;
                        }
                        // add end----

                        iBinderHashMap.put(devName,chipBinder);
                    }
                    IBinder iBinder = (IBinder) SupperChipBinder.asInterface(chipBinder);
                    chipBinders.add(iBinder);
                }
            }

        }
        return chipBinders;
    }

    private short bytesToShort(byte[] b) {
        short s = 0;
        short s0 = (short) (b[0] & 0xff);// 最低位
        short s1 = (short) (b[1] & 0xff);
        s1 <<= 8;
        s = (short) (s0 | s1);
        return s;
    }
}
