package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.cc.BaseCard;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.SupperJniApiBinder;

import java.util.ArrayList;
import java.util.Arrays;

import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_EXCEPTION;

/**
 * Created by xwy on 2017/9/14.
 */

public class CCJniApiBinder extends SupperJniApiBinder {
    public static final String TAG = "CCJniApiBinderTag";
    private Context context;

    private CCJniApi ccJniApi = null;
    private static CCJniApiBinder instance;

    public static CCJniApiBinder getInstance(Context context) {
        if (context == null) {
            return null;
        }
        if (instance == null) {
            synchronized (CCJniApiBinder.class) {
                if (instance == null) {
                    instance = new CCJniApiBinder(context);
                }
            }
        }
        return instance;
    }


    private CCJniApiBinder(Context context) {
        super(context);
        this.context = context;

        //del 2018年3月22日09:17:56 weizg
        //在此处设置监听，当手机中没有任何sim卡时，也会收到一次sim不在的广播，
        //然后程序kill当前进程，再然后芯片管家被系统kill，因为主进程依赖的一个provider所在的子进程已经被kill了
        /*IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SIM_STATE_CHANGED");
        this.context.registerReceiver(receiver, filter);

        Log.w(TAG, "Sim ------registerReceiver--------!");*/

        //del 2018年3月14日10:00:17 weizg 下面的注册，目前测试的不起作用，暂时注释
        /*if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
            Log.w(TAG, "Sim -----------------------!");
            SubscriptionManager subscriptionManager = this.context.getSystemService(SubscriptionManager.class);
            subscriptionManager.addOnSubscriptionsChangedListener(new SimChangeDefaultOnlineListener());
        }*/
    }

    @Override
    protected JNIAPI getApi() {
        return getCCJniApi();
    }

    private CCJniApi getCCJniApi() {
        /*if (ccJniApi == null) {
            synchronized (CCJniApiBinder.class) {
                if (ccJniApi == null) {
                    ccJniApi = new CCJniApi(context.getApplicationContext());
                }
            }
        }*/

        //modify 2018年4月2日19:39:49 weizg 修改为通过下面方法获取，下面方法有可能返回null
        ccJniApi = CCCacheManager.getInstance().getCCJniApi(context);
        return ccJniApi;
    }

    @Override
    public JniApiParam getJniApiParam() {
        int ret = CCHandleInit.getInstance(context).openCard(getCCJniApi());
        if (ret != 0) {
            return null;
        } else {

            //add 2018年3月22日09:20:23 weizg
            //在此处设置监听，当手机中没有任何sim卡时，也会收到一次sim不在的广播，
            //然后程序kill当前进程，再然后芯片管家被系统kill，因为主进程依赖的一个provider所在的子进程已经被kill了
            //修改为 如果openCard成功，再注册
//            IntentFilter filter = new IntentFilter();
//            filter.addAction("android.intent.action.SIM_STATE_CHANGED");
//            this.context.registerReceiver(receiver, filter);
//            Log.w(TAG, "Sim ------registerReceiver--------!");

        }
        return super.getJniApiParam();
    }

    XDJA_DEVINFO lastDevInfo = new XDJA_DEVINFO();

    @Override
    protected int selfOpenDev() throws RemoteException {
        devInfo = null;
        if (canUse()) {
            int ret = CCHandleInit.getInstance(context).openCard(getCCJniApi());
            if (ret == 0) {
                XDJA_DEVINFO ccDevInfo = CCHandleInit.getInstance(context).mDevInfo;
                if (!Arrays.equals(lastDevInfo.cardid, ccDevInfo.cardid)) {
                    lastDevInfo.cardid = Arrays.copyOf(ccDevInfo.cardid, ccDevInfo.cardid.length);
                    lastDevInfo.cardtype = ccDevInfo.cardtype;
                    lastDevInfo.cosver = Arrays.copyOf(ccDevInfo.cosver, ccDevInfo.cosver.length);
                    lastDevInfo.reserve = ccDevInfo.reserve;
                    devInfo = lastDevInfo;
                    notifyListenerChange();
                }
            }
        }
        return 0;
    }

    @Override
    protected boolean isDevOnline(int errcode) throws RemoteException {
        //add 2018年5月9日14:37:10 weizg
        //新增重连错误码-2；测试发现贴膜卡进程后台运行时，会因为系统内存或其他原因，导致和SEService的连接断开，
        //在调用业务接口时会返回-2错误
        if (errcode == BaseCard.XKR_UNKNOWN
                || errcode == BaseCard.XKR_IO_FAILED) {
            selfOpenDev();
            //因为devinfo有缓存，所以用获取随机数验证当前api对象是否可用
//            if (getApi().GenRandom(0, 1, new byte[1]) == BaseCard.XKR_OK) {

            CCJniApi ccJniApi = (CCJniApi) getApi();

            if (ccJniApi != null && ccJniApi.GetDevInfoPri(0, new XDJA_DEVINFO()) == BaseCard.XKR_OK) {
                return true;
            } else {
                CCCacheManager.getInstance().clear();
            }
        }
        return false;
    }

    @Override
    protected int getChipType() {
        return JniApiParam.TYPE_COVERED;
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        if (bundle.containsKey(ParamKeywords.KEY_String_method)) {
            String method = bundle.getString(ParamKeywords.KEY_String_method);
            if (ParamKeywords.KEY_METHOD_UnlockPinUseUsn.equals(method)) {
                return super.callMethod(bundle);
            } else if ("SM4".equals(method)) {
                return SM4(bundle);
            } else if ("SetCardChangeListener".equals(method)) {
                return setCardChangeListener(bundle);
            } else if (ParamKeywords.KEY_METHOD_clearContainer.equals(method)) {
                Bundle result = super.callMethod(bundle);
                if (result.getInt(ParamKeywords.KEY_int_ret) == 0) {
                    CCCacheManager.getInstance().clear();
                }
                return result;
            }
        }
        return super.callMethod(bundle);
    }

    private Bundle SM4(Bundle bundle) {
        Bundle result = new Bundle();
        byte[] dataIn = bundle.getByteArray("dataIn");
        int dataLen = bundle.getInt("dataLen");
        int flag = bundle.getInt("flag");
        byte kID = bundle.getByte("kID");
        byte[] IV = bundle.getByteArray("IV");

        byte[] dataOut = new byte[dataLen];
        int[] outLen = new int[2];

        //modify 2018年4月2日19:40:45 weizg
        // getCCJniApi有可能返回null
        int ret = RET_EXCEPTION;

        try {

            ret = getCCJniApi().SM4(dataIn, dataLen, flag, dataOut, outLen, kID, IV);

            if (isDevOnline(ret)) {
                ret = getCCJniApi().SM4(dataIn, dataLen, flag, dataOut, outLen, kID, IV);
            }
        } catch (Exception e) {
            e.printStackTrace();
            ret = RET_EXCEPTION;
        }
        result.putInt("ret", ret);
        result.putByteArray("dataOut", dataOut);
        result.putByteArray("IV", IV);

        return result;
    }

    ArrayList<Messenger> messengerList = new ArrayList<>();

    private Bundle setCardChangeListener(Bundle bundle) {
        Bundle result = new Bundle();
        IBinder binder = bundle.getBinder("Binder");
        if (binder != null) {
            Messenger messenger = new Messenger(binder);
            messengerList.add(messenger);
        }
        return result;
    }

    Boolean flag = true;

    /**
     * 两秒计时。
     * 第一次调用返回true，
     * 随后两秒的调用都返回false，
     * 两秒之后的第一次调用返回true。
     *
     * @return
     */
    boolean canUse() {
        if (flag) {
            flag = false;
            new Thread(new Runnable() {
                @Override
                public void run() {
                    SystemClock.sleep(2000);
                    flag = true;
                }
            }).start();
            return true;
        }
        return false;
    }

    /**
     * 通知监听者卡号改变改变
     */
    private void notifyListenerChange() {
        for (Messenger messenger : messengerList) {
            if (messenger.getBinder().isBinderAlive()) {
                Message msg = new Message();
                msg.what = 1;
                msg.obj = lastDevInfo;
                try {
                    messenger.send(msg);
                } catch (RemoteException e) {
                    e.printStackTrace();
                }
            } else {
                messengerList.remove(messenger);
            }
        }
    }

//    BroadcastReceiver receiver = new BroadcastReceiver() {
//        private final static String ACTION_SIM_STATE_CHANGED = "android.intent.action.SIM_STATE_CHANGED";
//
//        @Override
//        public void onReceive(Context context, Intent intent) {
//            if (intent.getAction().equals(ACTION_SIM_STATE_CHANGED)) {
//                TelephonyManager tm = (TelephonyManager) context
//                        .getSystemService(Service.TELEPHONY_SERVICE);
//                int state = tm.getSimState();
//
//                Log.w(TAG, "Sim state :" + state);
//
//                switch (state) {
//                    case TelephonyManager.SIM_STATE_READY:
//                        break;
//                    case 6:
//                        Log.w(TAG, "Sim state change to absent! 6666");
//                    case TelephonyManager.SIM_STATE_ABSENT:
//                        handleSimAbsent();
//                        break;
//                    case TelephonyManager.SIM_STATE_UNKNOWN:
//                    case TelephonyManager.SIM_STATE_PIN_REQUIRED:
//                    case TelephonyManager.SIM_STATE_PUK_REQUIRED:
//                    case TelephonyManager.SIM_STATE_NETWORK_LOCKED:
//                    default:
//                        break;
//                }
//            }
//        }
//    };

    void handleSimAbsent() {

        try {
            devInfo = null;
            getCCJniApi().getTMCAPI().CloseSEService();
            JarMultiChipStatusManager.getInstance().sendCardStatus(context, "", JniApiParam.TYPE_COVERED, -1);
            Log.w(TAG, "Sim state change to absent!Process exit!!!!");
            exitProcess();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void exitProcess() {
        Intent intent = new Intent(this.context, CCProcessService.class);
        this.context.stopService(intent);
        new Thread(new Runnable() {
            @Override
            public void run() {
                int count = 0;
                while (true) {
                    if (CCProcessProvider.getCallingFlag() == 0 || count++ > 60) {
                        android.os.Process.killProcess(android.os.Process.myPid());
                        System.exit(0);
                    } else {
                        SystemClock.sleep(50);
                    }
                }
            }
        }).start();
    }

}
