package com.xdja.multichip.process.coveredcard;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.telephony.SubscriptionManager;
import android.util.Log;

/**
 * Created by xwy on 2017/9/14.
 */

public class CCProcessService extends Service {
    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {

        //2018年4月14日09:15:42 weizg 该服务可能会被系统自动重启，重启时intent可能会为空
        if (intent != null) {
            if (intent.hasExtra(CCHandleInit.KEY_PARAM)) {
                Log.e(TAG, "=================== onStartCommand ");
                CCHandleInit.getInstance(getApplicationContext()).openCC(getApplicationContext(), intent);
            } else if (intent.hasExtra(CCCacheManager.KEY_PARAM)) {

                if (CCCacheManager.VALUE_NEW_CCJNIAPI_INSTANCE.equals(
                        intent.getStringExtra(CCCacheManager.KEY_PARAM))) {
                    CCCacheManager.getInstance().setCcJniApiForCCProcessService(getCCJniApi(getApplicationContext()));
                }
            }
        }

        return super.onStartCommand(intent, flags, startId);
    }

    private static CCJniApi ccJniApi;

    private static CCJniApi getCCJniApi(Context context) {
        if (ccJniApi == null) {
            synchronized (CCProcessService.class) {
                if (ccJniApi == null) {
                    ccJniApi = new CCJniApi(context.getApplicationContext());
                }
            }
        }
        return ccJniApi;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

        Log.e(TAG, "=================== onDestroy ");
        CCCacheManager.getInstance().setCcJniApiForCCProcessService(null);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Log.v(TAG, this.getClass().getName() + " onCreate");
        //del 2018年3月14日10:00:17 weizg 下面的注册，目前测试的不起作用，暂时注释
       /* if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
            Log.w(TAG, "Sim -----------------------11111!");
            SubscriptionManager subscriptionManager = getSystemService(SubscriptionManager.class);
            subscriptionManager.addOnSubscriptionsChangedListener(new SimChangeDefaultOnlineListener());
        }*/


        //test
        /*try {
            final TMCAPI tmcapi = new CCJniApi(getApplicationContext()).getTMCAPI();
            tmcapi.CloseSEService();

            //modify 2018年2月22日14:57:59 weizg v1.7版本的贴膜卡需要read_phone_state权限，否则会崩溃
            //所有把下面open方法放入到try块中
            tmcapi.OpenSEService(getApplicationContext(), new Card.SCSupported() {
                @Override
                public void isSupported(boolean b) {
                    Log.e(TAG, "OpenSEService back listener ");
                    String otiType = tmcapi.GetOtiType();
                    Log.w(TAG, "OpenSEService is supported " + b + " otiType: " + otiType);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }*/

    }

    public static final String TAG = "CCJniApiBinderTag";

    @TargetApi(Build.VERSION_CODES.LOLLIPOP_MR1)
    class SimChangeDefaultOnlineListener extends SubscriptionManager.OnSubscriptionsChangedListener {

        public SimChangeDefaultOnlineListener() {
            super();
        }

        @Override
        public void onSubscriptionsChanged() {
            Log.w(TAG, "Sim Change Default Online!1111111Process exit!");
            super.onSubscriptionsChanged();
            SubscriptionManager subscriptionManager;
        }
    }

}
