package com.xdja.multichip.process.vhsm;

import android.content.Context;
import android.os.Bundle;

import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;

import java.util.ArrayList;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/11/16 <br/>
 */
public class VhsmJniApiHandle {

    private static VhsmJniApiHandle instance;

    public static VhsmJniApiHandle getInstance() {
        if (instance == null) {
            synchronized (VhsmJniApiHandle.class) {
                if (instance == null) {
                    instance = new VhsmJniApiHandle();
                }
            }
        }
        return instance;
    }

    protected ArrayList<Bundle> getCurrentCardInfo(Context context) {
        ArrayList<Bundle> list = new ArrayList<>();
        if (context == null) {
            return list;
        }

        VshmJniapiBinder binder = VshmJniapiBinder.getInstance(context);
        if (binder == null) {
            return list;
        }

        JniApiParam param = binder.getJniApiParam();
        if (param != null) {
            JarMultiChipStatusManager.getInstance().sendCardStatus(context, param.cardId, param.chipType, 1);
            Bundle bundle = new Bundle();
            bundle.putBinder(ParamKeywords.KEY_Binder_Binder, binder);
            bundle.putParcelable(ParamKeywords.KEY_Parcelable_JniApiParam, param);
            list.add(bundle);
        }
        return list;
    }
}
