package com.xdja.multichip.process.vhsm;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SupperJniApiBinder;
import com.xdja.multichip.utils.PermissionUtil;
import com.xdja.vhsm.VHSMJNI;

import java.io.File;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/11/15 <br/>
 */
public class VshmJniapiBinder extends SupperJniApiBinder {
    private static VshmJniapiBinder instance;
    private static final String fileName = "vhsm.dat";
    private static VshmJniApi jniApi = new VshmJniApi();

    public static VshmJniapiBinder getInstance(Context context) {
        if (instance == null) {
            synchronized (VshmJniapiBinder.class) {
                if (instance == null) {
                    instance = new VshmJniapiBinder(context);
                }
            }
        }
        return instance;
    }

    private VshmJniapiBinder(Context context) {
        super(context);
    }

    @Override
    protected JNIAPI getApi() {
        return jniApi;
    }

    @Override
    protected int selfOpenDev() throws RemoteException {
        int ret = init();
        mHandle = 0;
        if (ret != 0) {
            return JNIAPI.XKR_NO_KEY;
        }

        int[] devNum = new int[1];
        ret = getApi().EnumDev(0, devNum);
        if (ret != 0) {
            return ret;
        }
        if (devNum[0] <= 0) {
            return JNIAPI.XKR_NO_KEY;
        }

        long[] handle = new long[1];
        ret = getApi().OpenDev(0, handle);
        if (ret == 0) {
            mHandle = handle[0];
        }
        return ret;
    }

    @Override
    protected int getChipType() {
        return JniApiParam.TYPE_VHSM;
    }

    @Override
    protected boolean isDevOnline(int errCode) throws RemoteException {
        if (errCode == JNIAPI.XKR_NO_HANDLE
                || errCode == VHSMJNI.XKR_DEV_NOT_FOUND
                || errCode == VHSMJNI.XKR_INVALID_PARA) {
            selfOpenDev();
            if (mHandle == 0) {
                return false;
            }
            return true;
        } else {
            return false;
        }
    }

    @SuppressLint("MissingPermission")
    private int init() {
        File vhsmFile = new File(mContext.getFilesDir(), fileName);
        String imei = getImei();
        if (!vhsmFile.exists() || TextUtils.isEmpty(imei)) {
            boolean flag = PermissionUtil.isGranted(mContext, Manifest.permission.READ_PHONE_STATE);
            if (!flag) {
                return -1;
            }
            TelephonyManager telephonyManager = (TelephonyManager) mContext.getSystemService(Context.TELEPHONY_SERVICE);
            imei = telephonyManager.getDeviceId();
        }
        if (TextUtils.isEmpty(imei)) {
            return -1;
        }
        saveImei(imei);

        byte[] vhsmFilePath = vhsmFile.getAbsolutePath().getBytes();
        int ret = ((VshmJniApi) getApi()).InitModule(vhsmFilePath, vhsmFilePath.length, imei.getBytes(), imei.length());
        return ret;
    }

    private void saveImei(String imei) {
        if (TextUtils.isEmpty(imei)) {
            return;
        }
        SharedPreferences preferences = mContext.getSharedPreferences("vhsm", Context.MODE_PRIVATE);
        SharedPreferences.Editor edit = preferences.edit();
        edit.putString("imei", imei);
        edit.apply();
        edit.commit();
    }

    private String getImei() {
        SharedPreferences preferences = mContext.getSharedPreferences("vhsm", Context.MODE_PRIVATE);
        String imei = preferences.getString("imei", "");
        return imei;
    }

}
