/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.xdja.multichip.process.SuperChipForCall;
import com.xdja.multichip.process.bluetooth.BluetoothKeyProcessProvider;
import com.xdja.multichip.process.bluetooth.BluetoothKeyProcessService;

public class BluetoothKeyChipForCall
extends SuperChipForCall {
    public static final String NAME_PROCESS_BLUETOOTH = "bluekey";
    private static int bluetoothFlag = 0;
    private static BroadcastReceiver bluetoothReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int blueState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
            if (10 == blueState) {
                Intent stopIntent = new Intent();
                stopIntent.setClassName(context.getPackageName(), BluetoothKeyProcessService.class.getName());
                context.stopService(stopIntent);
            }
        }
    };

    public BluetoothKeyChipForCall(Context context) {
        super(context);
    }

    @Override
    protected Class getProviderClass() {
        return BluetoothKeyProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_BLUETOOTH;
    }

    @Override
    public boolean isCanUse() {
        this.regeditBluetoothListener();
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            int state = adapter.getState();
            return state != 10 && state != 13;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int getChipType() {
        return 4;
    }

    private synchronized void regeditBluetoothListener() {
        if (bluetoothFlag != 0) {
            return;
        }
        bluetoothFlag = 1;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        this.context.registerReceiver(bluetoothReceiver, filter);
    }
}

