/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.vhsm.DefaultVhsmBean;
import com.xdja.multichip.process.vhsm.VhsmBean;
import com.xdja.multichip.process.vhsm.VhsmJniapiBinder;
import java.io.File;
import java.util.ArrayList;

public class VhsmJniApiHandle {
    private static VhsmJniApiHandle instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VhsmJniApiHandle getInstance() {
        if (instance != null) return instance;
        Class<VhsmJniApiHandle> clazz = VhsmJniApiHandle.class;
        synchronized (VhsmJniApiHandle.class) {
            if (instance != null) return instance;
            instance = new VhsmJniApiHandle();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ArrayList<Bundle> getDefaultCardInfo(Context context) {
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        if (context == null) {
            return list;
        }
        Bundle defaultVhsm = this.getDefaultVhsm(context);
        if (defaultVhsm != null) {
            list.add(defaultVhsm);
        }
        return list;
    }

    private Bundle getDefaultVhsm(Context context) {
        DefaultVhsmBean defaultBean = DefaultVhsmBean.make(context);
        try {
            File vhsmDatFile = defaultBean.getVhsmDatFile();
            if (vhsmDatFile.exists()) {
                VhsmJniapiBinder binder = VhsmJniapiBinder.make(context, defaultBean);
                Bundle bundle = this.getBundle(context, binder);
                return bundle;
            }
        }
        catch (VhsmBean.VhsmBeanException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Bundle createDefaultVhsm(Context context) {
        DefaultVhsmBean defaultBean = DefaultVhsmBean.make(context);
        try {
            File vhsmDatFile = defaultBean.getVhsmDatFile();
            if (vhsmDatFile.exists()) {
                Bundle bundle = new Bundle();
                bundle.putInt("ret", -10030);
                return bundle;
            }
            VhsmJniapiBinder binder = VhsmJniapiBinder.make(context, defaultBean);
            Bundle bundle = this.getBundle(context, binder);
            return bundle;
        }
        catch (VhsmBean.VhsmBeanException e) {
            e.printStackTrace();
            int ret = defaultBean.handleVhsmBeanException(e);
            Bundle bundle = new Bundle();
            bundle.putInt("ret", ret);
            return bundle;
        }
    }

    private Bundle getBundle(Context context, VhsmJniapiBinder binder) {
        if (binder == null) {
            return null;
        }
        JniApiParam param = binder.getJniApiParam();
        if (param != null) {
            JarMultiChipStatusManager.getInstance().sendCardStatus(context, param.cardId, param.chipType, 1);
            Bundle bundle = new Bundle();
            bundle.putInt("ret", 0);
            bundle.putBinder("Binder", (IBinder)binder);
            bundle.putParcelable("JniApiParam", (Parcelable)param);
            return bundle;
        }
        return null;
    }
}

