/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.RemoteException;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.process.SupperJniApiBinder;
import com.xdja.multichip.process.vhsm.VhsmBean;
import com.xdja.multichip.process.vhsm.VhsmJniApi;
import java.io.File;
import java.util.HashMap;
import java.util.Set;

public class VhsmJniapiBinder
extends SupperJniApiBinder {
    private static VhsmJniapiBinder instance;
    private static VhsmJniApi jniApi;
    private static final String TAG = "vhsm";
    private VhsmBean vhsmBean;
    private static HashMap<VhsmBean, VhsmJniapiBinder> mapBinder;

    private VhsmJniapiBinder(Context context, VhsmBean vhsmBean) {
        super(context);
        if (vhsmBean == null) {
            throw new NullPointerException("VhsmBean is null!");
        }
        this.vhsmBean = vhsmBean;
    }

    public static VhsmJniapiBinder make(Context context, VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        if (context == null || vhsmBean == null) {
            return null;
        }
        VhsmJniapiBinder binder = VhsmJniapiBinder.getBinderInMap(vhsmBean);
        if (binder == null) {
            binder = new VhsmJniapiBinder(context, vhsmBean);
            mapBinder.put(vhsmBean, binder);
        }
        return binder;
    }

    private static VhsmJniapiBinder getBinderInMap(VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        if (vhsmBean == null) {
            return null;
        }
        String cardId = vhsmBean.getCardId();
        String id = vhsmBean.getId();
        String filePath = vhsmBean.getVhsmDatFile().getAbsolutePath();
        String pwd = vhsmBean.getVhsmPwd();
        Set<VhsmBean> vhsmSet = mapBinder.keySet();
        for (VhsmBean bean : vhsmSet) {
            try {
                if (!bean.getCardId().equals(cardId) || !bean.getId().equals(id) || !bean.getVhsmDatFile().getAbsolutePath().equals(filePath) || !bean.getVhsmPwd().equals(pwd)) continue;
                return mapBinder.get(bean);
            }
            catch (VhsmBean.VhsmBeanException e) {
                mapBinder.remove(bean);
            }
        }
        return null;
    }

    @Override
    protected JNIAPI getApi() {
        return jniApi;
    }

    @Override
    protected int selfOpenDev() throws RemoteException {
        int ret = this.init();
        this.mHandle = 0L;
        if (ret != 0) {
            return -97;
        }
        int[] devNum = new int[1];
        ret = this.getApi().EnumDev(0, devNum);
        if (ret != 0) {
            return ret;
        }
        if (devNum[0] <= 0) {
            return -97;
        }
        long[] handle = new long[1];
        ret = this.getApi().OpenDev(0, handle);
        if (ret == 0) {
            this.mHandle = handle[0];
        }
        return ret;
    }

    @Override
    protected int getChipType() {
        return 16;
    }

    @Override
    protected boolean isDevOnline(int errCode) throws RemoteException {
        if (errCode == -1 || errCode == -101 || errCode == -9) {
            this.selfOpenDev();
            return this.mHandle != 0L;
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    private int init() {
        try {
            File vhsmFile = this.vhsmBean.getVhsmDatFile();
            byte[] vhsmFilePath = vhsmFile.getAbsolutePath().getBytes();
            String pwd = this.vhsmBean.getVhsmPwd();
            String id = this.vhsmBean.getId();
            int ret = ((VhsmJniApi)this.getApi()).InitModule(vhsmFilePath, vhsmFilePath.length, pwd.getBytes(), pwd.getBytes().length, id.getBytes(), id.getBytes().length);
            return ret;
        }
        catch (VhsmBean.VhsmBeanException e) {
            e.printStackTrace();
            int i = this.vhsmBean.handleVhsmBeanException(e);
            return i;
        }
    }

    static {
        jniApi = new VhsmJniApi();
        mapBinder = new HashMap();
    }
}

