package com.xdja.multichip.process.cardstatus;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;

import com.xdja.multichip.ICardStatusBinder;
import com.xdja.multichip.jniapi.JarMultiJniApiErrorCode;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;

import java.util.ArrayList;
import java.util.HashMap;

import static com.xdja.multichip.jniapi.JarMultiChipStatusManager.CARD_STATUS_NOT_EXIST;
import static com.xdja.multichip.jniapi.JarMultiChipStatusManager.MULTI_CHIP_STATUS_MSG_WHAT_1;
import static com.xdja.multichip.param.ParamKeywords.KEY_Binder_messenger;
import static com.xdja.multichip.param.ParamKeywords.KEY_String_cardId;
import static com.xdja.multichip.param.ParamKeywords.KEY_String_method;
import static com.xdja.multichip.param.ParamKeywords.KEY_METHOD_registerListener;
import static com.xdja.multichip.param.ParamKeywords.KEY_METHOD_sendSafeCardStatus;
import static com.xdja.multichip.param.ParamKeywords.KEY_int_cardType;
import static com.xdja.multichip.param.ParamKeywords.KEY_int_ret;
import static com.xdja.multichip.param.ParamKeywords.KEY_int_status;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/5/16 <br/>
 */
public class CardStatusBinderService extends ICardStatusBinder.Stub {

    private final String TAG = CardStatusBinderService.class.getSimpleName() + "Log";

    private static CardStatusBinderService instance;

    private Context context;
    /**
     * 监听服务list
     */
    private ArrayList<Messenger> messengerList = new ArrayList<>();

    HashMap<Integer, CardTypeInfo> cardTypeInfoMap = new HashMap<>();

    private CardStatusBinderService(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }

        initData();

        sendBroadcast(context);
    }

    public static CardStatusBinderService getInstance(Context context) {
        if (instance == null) {
            synchronized (CardStatusBinderService.class) {
                if (instance == null) {
                    instance = new CardStatusBinderService(context);
                }
            }
        }
        return instance;
    }

    private void initData() {
        CardTypeInfo onboard = new CardTypeInfo(JniApiParam.TYPE_ONBOARD);
        CardTypeInfo tf = new CardTypeInfo(JniApiParam.TYPE_TF);
        CardTypeInfo bluetooth = new CardTypeInfo(JniApiParam.TYPE_BLUETOOTH);
        CardTypeInfo covered = new CardTypeInfo(JniApiParam.TYPE_COVERED);
        CardTypeInfo vhsm = new CardTypeInfo(JniApiParam.TYPE_VHSM);
        cardTypeInfoMap.put(onboard.cardType, onboard);
        cardTypeInfoMap.put(tf.cardType, tf);
        cardTypeInfoMap.put(bluetooth.cardType, bluetooth);
        cardTypeInfoMap.put(covered.cardType, covered);
        cardTypeInfoMap.put(vhsm.cardType, vhsm);
    }

    private void sendBroadcast(Context context) {
        Log.e(TAG,"sendBroadcast..........");
        Intent intent = new Intent();
        intent.setAction(ParamKeywords.ACTION_CardStatusServiceStart);
        context.sendBroadcast(intent);
    }


    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        Bundle result = new Bundle();
        if (bundle == null) {
            result.putInt(KEY_int_ret, JarMultiJniApiErrorCode.RET_PARAM_ERROR);
            return result;
        }
        if (!bundle.containsKey(KEY_String_method)) {
            result.putInt(KEY_int_ret, JarMultiJniApiErrorCode.NO_SUCH_METHOD);
            return result;
        }
        String method = bundle.getString(KEY_String_method);
        if (method.equals(KEY_METHOD_registerListener)) {
            return registerListener(bundle);
        } else if (method.equals(KEY_METHOD_sendSafeCardStatus)) {
            return sendSafeCardStatus(bundle);
        } else {
            result.putInt(KEY_int_ret, JarMultiJniApiErrorCode.NO_SUCH_METHOD);
        }
        return result;
    }

    /**
     * 注册监听
     *
     * @param bundle
     * @return
     */
    private Bundle registerListener(Bundle bundle) {
        Log.e(TAG,"registerListener............");
        Bundle result = new Bundle();
        IBinder binder = bundle.getBinder(KEY_Binder_messenger);
        final Messenger messenger = new Messenger(binder);
        for (Messenger m : messengerList) {
            if (m.equals(messenger)) {
                result.putInt(KEY_int_ret, 0);
                return result;
            }
        }
        messengerList.add(messenger);
        try {
            binder.linkToDeath(new DeathRecipient() {
                @Override
                public void binderDied() {
                    messengerList.remove(messenger);
                }
            }, 0);
            result.putInt(KEY_int_ret, 0);
        } catch (RemoteException e) {
            e.printStackTrace();
            result.putInt(KEY_int_ret, JarMultiJniApiErrorCode.RET_EXCEPTION);
        }
        return result;
    }

    private Bundle sendSafeCardStatus(Bundle bundle) {
        Bundle result = new Bundle();
        int callingUid = getCallingUid();
        if (callingUid != Process.myUid()) {
            result.putInt(KEY_int_ret, JarMultiJniApiErrorCode.RET_NO_POWER);
            return result;
        }
        String cardId = bundle.getString(KEY_String_cardId);
        int cardType = bundle.getInt(KEY_int_cardType);
        int status = bundle.getInt(KEY_int_status);

        result.putInt(KEY_int_ret, 0);
        Log.e(TAG, "cardId = " + cardId + "  cardType = " + cardType + "  status = " + status);
        handleMsg(cardId, cardType, status);
        return result;
    }

    private synchronized void handleMsg(String cardId, int cardType, int status) {
        if (cardId == null) {
            cardId = "";
        }
        CardTypeInfo info = cardTypeInfoMap.get(cardType);
        if (info.status != status || !info.cardId.equals(cardId)) {
            info.status = status;
            info.cardId = cardId;
            notifyMessenger(info);
        }
    }

    private synchronized void notifyMessenger(CardTypeInfo info) {
        Log.e(TAG, "notify cardType = " + info.cardType);
        for (Messenger messenger : messengerList) {
            Message msg = Message.obtain();
            msg.what = MULTI_CHIP_STATUS_MSG_WHAT_1;
            Bundle bundle = new Bundle();
            bundle.putInt(KEY_int_cardType, info.cardType);
            bundle.putInt(KEY_int_status, info.status);
            bundle.putString(KEY_String_cardId, info.cardId);
            msg.obj = bundle;
            try {
                messenger.send(msg);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }


    class CardTypeInfo {
        int cardType;
        String cardId = "";
        int status = CARD_STATUS_NOT_EXIST;

        public CardTypeInfo(int cardType) {
            this.cardType = cardType;
        }
    }
}
