package com.xdja.multichip.process.vhsm;

import android.Manifest;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.SuperChipForCall;
import com.xdja.multichip.utils.PermissionUtil;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/12/27 <br/>
 */
public class VhsmChipForCall extends SuperChipForCall {
    public static final String NAME_PROCESS_VHSM = "vhsm";

    public VhsmChipForCall(Context context) {
        super(context);
    }

    @Override
    protected Class getProviderClass() {
        return VhsmProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_VHSM;
    }

    @Override
    public boolean isCanUse() {
        boolean flag = PermissionUtil.isGranted(context, Manifest.permission.READ_PHONE_STATE);
        return flag;
    }

    @Override
    public int getChipType() {
        return JniApiParam.TYPE_VHSM;
    }

    public Bundle createDefaultVhsm(){
        String authority = getProviderAuthority(context, getProviderClass().getName());
        if (TextUtils.isEmpty(authority)) {
            Log.e(TAG, getProviderClass().getName() + " authority is null.");
            return null;
        }
        Uri uri = Uri.parse("content://" + authority);
        ContentResolver resolver = context.getContentResolver();
        Bundle bundle =  resolver.call(uri, ParamKeywords.KEY_METHOD_CreateDefaultVhsm, "", null);
        return bundle;
    }
}
