package com.xdja.safekeyservice.provider;

import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;

import com.xdja.multichip.AccessControlBinder;
import com.xdja.multichip.GetMultiJniApiBinder;
import com.xdja.multichip.MultiChipUnitePinBinder;
import com.xdja.multichip.process.cardstatus.CardStatusProvider;

import java.util.HashMap;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/29 <br/>
 * <p>
 * modify by zhangxiaolong@xdja.com
 * 此Provider今后(20170605)用于提供Binder代理对象
 */

public class GetProxyProvider extends ContentProvider {
    private final static String KEY_INT_RET = "ret";
    private final static String KEY_BINDER_BINDER = "Binder";

    @Override
    public boolean onCreate() {
        return false;
    }

    @Override
    public Cursor query(Uri uri, String[] strings, String s, String[] strings1, String s1) {
        return null;
    }

    @Override
    public String getType(Uri uri) {
        return null;
    }

    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        return null;
    }

    @Override
    public int delete(Uri uri, String s, String[] strings) {
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String s, String[] strings) {
        return 0;
    }

    HashMap<Integer, String> callingPkgMap = new HashMap<>();

    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        // add by zhangxiaolong@xdja.om 20180307
        // 用于解决在华为荣耀8（Android7.0）、mate10（Android8.0）上，安通+通过界面验证PIN码时，
        // 代码运行至此时，getCallingPackage()抛出异常的问题（callingUid和callingPkgName不一致）
        int uid = Binder.getCallingUid();
        String callingPkgName = null;
        if (callingPkgMap.containsKey(uid)) {
            callingPkgName = callingPkgMap.get(uid);
        } else {
            try {
                callingPkgName = getCallingPackage();
            } catch (Exception e) {
                e.printStackTrace();

                if (TextUtils.isEmpty(callingPkgName)) {
                    PackageManager pm = getContext().getPackageManager();
                    callingPkgName = pm.getNameForUid(uid);
                }
            }
            if (!TextUtils.isEmpty(callingPkgName)) {
                callingPkgMap.put(uid, callingPkgName);
            }
        }
        if (method.equals("GetBinder")) {
            sendCallAppInfoBroadcast(callingPkgName);
            return handleGetBinder(arg, extras);
        }
        return super.call(method, arg, extras);
    }

    private AccessControlBinder accessControlBinder = null;

    /**
     * 处理 GetBinder的方法
     *
     * @param arg
     * @param extras
     * @return
     */
    private Bundle handleGetBinder(String arg, Bundle extras) {
        if (TextUtils.isEmpty(arg)) {
            return null;
        }
        if (arg.equals("AccessControlBinder")) {
            Bundle result = new Bundle();
            result.putInt(KEY_INT_RET, 0);
            synchronized (GetProxyProvider.class) {
                if (accessControlBinder == null) {
                    accessControlBinder = new AccessControlBinder(getContext());
                }
            }
            result.putBinder(KEY_BINDER_BINDER, accessControlBinder);
            return result;
        } else if (arg.equals("MultiChipUnitePinBinder")) {
            Bundle result = new Bundle();
            result.putInt(KEY_INT_RET, 0);
            MultiChipUnitePinBinder binder = MultiChipUnitePinBinder.getInstance(getContext());
            result.putBinder(KEY_BINDER_BINDER, binder);
            return result;
        } else if (arg.equals("GetMultiJniApiBinder")) {
            Bundle result = new Bundle();
            result.putInt(KEY_INT_RET, 0);
            GetMultiJniApiBinder binder = GetMultiJniApiBinder.getInstance(getContext());
            result.putBinder(KEY_BINDER_BINDER, binder);
            return result;
        } else if (arg.equals("CardStatusBinder")) {
            ContentResolver resolver = getContext().getContentResolver();
            Uri uri = getCardStatusProviderUri(getContext());
            if (uri != null) {
                return resolver.call(uri, "GetBinder", arg, extras);
            }
        }
        return null;
    }


    //add 2018年1月4日11:52:43 weizg
    //新增接口调用者广播发生
    private void sendCallAppInfoBroadcast(String packageName) {
        if (TextUtils.isEmpty(packageName) || getContext() == null) {
            return;
        }
        Intent intent = new Intent();
        intent.setPackage(getContext().getPackageName());
        intent.setAction("com.xdja.safekeyservice.soc_APP_CALL");
        intent.putExtra("CALL_APP_NAME", packageName);
        getContext().sendBroadcast(intent);
    }

    private Uri cardStatusProviderUri;

    private Uri getCardStatusProviderUri(Context context) {
        if (cardStatusProviderUri != null) {
            return cardStatusProviderUri;
        }
        PackageManager pm = context.getPackageManager();
        ComponentName cn = new ComponentName(context, CardStatusProvider.class);
        try {
            ProviderInfo pi = pm.getProviderInfo(cn, PackageManager.GET_META_DATA);
            String authority = pi.authority;
            cardStatusProviderUri = Uri.parse("content://" + authority);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return cardStatusProviderUri;
    }
}
