/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.bluetooth.BluetoothKeyProcessService;
import com.xdja.multichip.process.bluetooth.JniApiBluetoothKeyBinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BluetoothKeyProcessProvider
extends ContentProvider {
    public static final String KEY_RET = "ret";
    public static final String KEY_BINDER = "Binder";
    public static final String KEY_JNIAPIPARAM = "JniApiParam";
    public static final String KEY_RESULT = "result";
    public static final String KEY_DEVADDRESS = "devAddress";
    public static final String KEY_DEVNAME = "devName";
    public static final String KEY_MESSENGER = "Messenger";
    public static final int RET_PARAM_NULL = -1;
    public static final int RET_CANNOT_CONNECT = -2;
    private ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    private HashMap<String, JniApiBluetoothKeyBinder> binderMap = new HashMap();
    private HashMap<String, String> connectedAddressNameMap = null;
    private SelfScanCallback selfScanCallback = null;
    private static final int FLAG_INIT_NOT = 0;
    private static final int FLAG_INIT_NO_START_SCAN = 1;
    private static final int FLAG_INIT_ALL = 2;
    int initFlag = 0;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action)) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                switch (state) {
                    case 10: {
                        Process.killProcess((int)Process.myPid());
                    }
                }
            }
        }
    };

    public boolean onCreate() {
        this.initData();
        if (this.getContext() != null) {
            this.getContext().startService(new Intent(this.getContext(), BluetoothKeyProcessService.class));
        }
        return false;
    }

    private void initData() {
        if (this.initFlag == 2) {
            return;
        }
        if (this.initFlag == 0) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            this.getContext().registerReceiver(this.mReceiver, filter);
            this.initFlag = 1;
        }
        try {
            BluetoothManager bleManager = (BluetoothManager)this.getContext().getSystemService("bluetooth");
            BluetoothAdapter bleAdapter = bleManager.getAdapter();
            if (bleAdapter.getState() != 12) {
                return;
            }
            if (this.initFlag == 1) {
                HashMap<String, String> map = this.getAllConnectedBluetoothKey();
                if (map == null || map.size() == 0) {
                    this.initFlag = 1;
                } else {
                    if (Build.VERSION.SDK_INT >= 21) {
                        BluetoothLeScanner bleLeScanner = bleAdapter.getBluetoothLeScanner();
                        bleLeScanner.startScan(this.getSelfScanCallback().scanCallback);
                    } else {
                        bleAdapter.startLeScan(this.getSelfScanCallback().leScanCallback);
                    }
                    this.initFlag = 2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void unInit() {
        if (this.initFlag == 0) {
            return;
        }
        try {
            BluetoothManager bleManager = (BluetoothManager)this.getContext().getSystemService("bluetooth");
            BluetoothAdapter bleAdapter = bleManager.getAdapter();
            if (bleAdapter.getState() != 12) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                BluetoothLeScanner bleLeScanner = bleAdapter.getBluetoothLeScanner();
                bleLeScanner.stopScan(this.getSelfScanCallback().scanCallback);
            } else {
                bleAdapter.stopLeScan(this.getSelfScanCallback().leScanCallback);
            }
            this.initFlag = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    public Bundle call(String method, String arg, Bundle extras) {
        this.initData();
        if ("GetJniApiBinder".equals(method)) {
            return this.handleGetJniApiBinder(method, arg, extras);
        }
        if ("ConnectBluetoothKey".equals(method)) {
            return this.handleConnectBluetoothKey(method, arg, extras);
        }
        if ("ConnectBluetoothKeyCallBack".equals(method)) {
            return this.handleConnectBluetoothKeyCallBack(method, arg, extras);
        }
        if ("DisconnectBluetoothKey".equals(method)) {
            return this.handleDisconnectBluetoothKey(method, arg, extras);
        }
        return super.call(method, arg, extras);
    }

    private Bundle handleGetJniApiBinder(String method, String arg, Bundle extras) {
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        Bundle bundle = new Bundle();
        if (this.judgeBluetoothCanUse()) {
            for (Map.Entry<String, JniApiBluetoothKeyBinder> entry : this.binderMap.entrySet()) {
                JniApiBluetoothKeyBinder binder = entry.getValue();
                JniApiParam param = binder.getJniApiParam();
                if (param == null) continue;
                Bundle singleBundle = new Bundle();
                singleBundle.putBinder(KEY_BINDER, (IBinder)binder);
                singleBundle.putParcelable(KEY_JNIAPIPARAM, (Parcelable)binder.getJniApiParam());
                list.add(singleBundle);
            }
        }
        bundle.putInt(KEY_RET, 0);
        bundle.putParcelableArrayList(KEY_RESULT, list);
        return bundle;
    }

    private Bundle handleConnectBluetoothKey(String method, String arg, Bundle extras) {
        Bundle bundle = new Bundle();
        String devAddress = extras.getString(KEY_DEVADDRESS);
        String devName = extras.getString(KEY_DEVNAME);
        if (TextUtils.isEmpty((CharSequence)devAddress) || TextUtils.isEmpty((CharSequence)devName)) {
            bundle.putInt(KEY_RET, -1);
            return bundle;
        }
        return this.getConnectBluetoothKeyBundle(devAddress, devName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle getConnectBluetoothKeyBundle(String devAddress, String devName) {
        Class<BluetoothKeyProcessProvider> clazz = BluetoothKeyProcessProvider.class;
        synchronized (BluetoothKeyProcessProvider.class) {
            Bundle bundle = new Bundle();
            String binderKey = this.convertToKey(devAddress, devName);
            JniApiBluetoothKeyBinder binder = null;
            if (this.binderMap.containsKey(binderKey)) {
                binder = this.binderMap.get(binderKey);
            } else {
                Pair<Integer, JniApiBluetoothKeyBinder> pair = JniApiBluetoothKeyBinder.make(this.getContext(), devAddress, devName);
                if ((Integer)pair.first == 0) {
                    binder = (JniApiBluetoothKeyBinder)((Object)pair.second);
                    this.binderMap.put(binderKey, binder);
                    this.unInit();
                }
            }
            if (binder != null) {
                this.saveConnectedBluetoothKey(devAddress, devName);
                bundle.putInt(KEY_RET, 0);
                bundle.putBinder(KEY_BINDER, (IBinder)binder);
                bundle.putString(KEY_DEVADDRESS, devAddress);
                bundle.putString(KEY_DEVNAME, devName);
                JniApiParam param = binder.getJniApiParam();
                bundle.putParcelable(KEY_JNIAPIPARAM, (Parcelable)param);
            } else {
                bundle.putInt(KEY_RET, -2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bundle;
        }
    }

    private Bundle handleConnectBluetoothKeyCallBack(String method, String arg, Bundle extras) {
        Bundle bundle = new Bundle();
        final String devAddress = extras.getString(KEY_DEVADDRESS);
        final String devName = extras.getString(KEY_DEVNAME);
        if (TextUtils.isEmpty((CharSequence)devAddress) || TextUtils.isEmpty((CharSequence)devName)) {
            bundle.putInt(KEY_RET, -1);
            return bundle;
        }
        final IBinder binder = extras.getBinder(KEY_MESSENGER);
        this.cachedThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                Bundle bundle = BluetoothKeyProcessProvider.this.getConnectBluetoothKeyBundle(devAddress, devName);
                if (binder != null) {
                    Messenger messenger = new Messenger(binder);
                    Message msg = new Message();
                    msg.what = 0;
                    msg.obj = bundle;
                    try {
                        messenger.send(msg);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        bundle.putInt(KEY_RET, 0);
        return bundle;
    }

    private Bundle handleDisconnectBluetoothKey(String method, String arg, Bundle extras) {
        Bundle bundle = new Bundle();
        String devAddress = extras.getString(KEY_DEVADDRESS);
        String devName = extras.getString(KEY_DEVNAME);
        if (TextUtils.isEmpty((CharSequence)devAddress) || TextUtils.isEmpty((CharSequence)devName)) {
            bundle.putInt(KEY_RET, -1);
            return bundle;
        }
        this.delConnectedBluetoothKey(devAddress, devName);
        if (this.connectedAddressNameMap == null) {
            this.connectedAddressNameMap = this.getAllConnectedBluetoothKey();
        }
        this.connectedAddressNameMap.remove(devAddress);
        String key = this.convertToKey(devAddress, devName);
        JniApiBluetoothKeyBinder binder = this.binderMap.remove(key);
        if (binder != null) {
            binder.handleDisconnect();
        }
        bundle.putInt(KEY_RET, 0);
        return bundle;
    }

    private boolean judgeBluetoothCanUse() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null) {
            return false;
        }
        int state = adapter.getState();
        return state == 12 || state == 2;
    }

    private String convertToKey(String devAddress, String devName) {
        return devAddress + "#" + devName;
    }

    private void saveConnectedBluetoothKey(String devAddress, String devName) {
        SharedPreferences preferences = this.getContext().getSharedPreferences("bluetooth_key_list.xml", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(devAddress, devName);
        editor.commit();
    }

    private HashMap<String, String> getAllConnectedBluetoothKey() {
        SharedPreferences preferences = this.getContext().getSharedPreferences("bluetooth_key_list.xml", 0);
        HashMap map = (HashMap)preferences.getAll();
        return map;
    }

    private void delConnectedBluetoothKey(String devAddress, String devName) {
        SharedPreferences preferences = this.getContext().getSharedPreferences("bluetooth_key_list.xml", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.remove(devAddress);
        editor.commit();
    }

    private SelfScanCallback getSelfScanCallback() {
        if (this.selfScanCallback == null) {
            this.selfScanCallback = new SelfScanCallback();
        }
        return this.selfScanCallback;
    }

    class SelfScanCallback {
        ScanCallback scanCallback;
        BluetoothAdapter.LeScanCallback leScanCallback;

        SelfScanCallback() {
            if (Build.VERSION.SDK_INT >= 21) {
                Log.d((String)"ble_callback", (String)"ScanCallback");
                this.scanCallback = new ScanCallback(){

                    @TargetApi(value=21)
                    public void onScanResult(int callbackType, ScanResult result) {
                        BluetoothDevice device = result.getDevice();
                        if (device == null || device.getName() == null) {
                            return;
                        }
                        String devAddress = device.getAddress();
                        String devName = device.getName();
                        SelfScanCallback.this.forScanResult(devAddress, devName);
                    }
                };
            } else {
                Log.d((String)"ble_callback", (String)"leScanCallback");
                this.leScanCallback = new BluetoothAdapter.LeScanCallback(){

                    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
                        if (device == null || device.getName() == null) {
                            return;
                        }
                        String devAddress = device.getAddress();
                        String devName = device.getName();
                        SelfScanCallback.this.forScanResult(devAddress, devName);
                    }
                };
            }
        }

        void forScanResult(final String devAddress, final String devName) {
            BluetoothKeyProcessProvider.this.cachedThreadPool.submit(new Runnable(){

                @Override
                public void run() {
                    String key = BluetoothKeyProcessProvider.this.convertToKey(devAddress, devName);
                    if (BluetoothKeyProcessProvider.this.binderMap.containsKey(key)) {
                        return;
                    }
                    if (BluetoothKeyProcessProvider.this.connectedAddressNameMap == null) {
                        BluetoothKeyProcessProvider.this.connectedAddressNameMap = BluetoothKeyProcessProvider.this.getAllConnectedBluetoothKey();
                    }
                    if (BluetoothKeyProcessProvider.this.connectedAddressNameMap.containsKey(devAddress)) {
                        BluetoothKeyProcessProvider.this.getConnectBluetoothKeyBundle(devAddress, devName);
                    }
                }
            });
        }
    }
}

