/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.coveredcard;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.process.coveredcard.CCJniApiBinder;
import com.xdja.multichip.process.coveredcard.CCJniApiHandle;
import com.xdja.multichip.utils.FuncUtils;
import com.xdja.multichip.utils.PermissionUtil;
import java.util.ArrayList;
import java.util.List;

public class CCEventReceiver
extends BroadcastReceiver {
    private static final String TAG = CCEventReceiver.class.getSimpleName();
    private static final String ACTION_SIM_STATE_CHANGED = "android.intent.action.SIM_STATE_CHANGED";
    static int readyFlag = 0;

    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            Log.v((String)"CC", (String)"CCEventReceiver intent null");
            return;
        }
        if (!MultiJniApiConfig.getInstance(context).judgeChipCanUse("coveredcard")) {
            return;
        }
        if (!"com.xdja.safekeyservice".equals(context.getPackageName()) && FuncUtils.isApkExist(context, "com.xdja.safekeyservice")) {
            return;
        }
        if (ACTION_SIM_STATE_CHANGED.equals(intent.getAction())) {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            int state = tm.getSimState();
            Log.w((String)TAG, (String)("Sim state :" + state));
            switch (state) {
                case 5: 
                case 6: {
                    if (!this.hasPermission(context.getApplicationContext())) break;
                    JarMultiChipStatusManager.getInstance().sendCardStatus(context, "", 8, -1);
                    this.scanCC(context.getApplicationContext());
                    break;
                }
                case 1: {
                    CCJniApiBinder.getInstance(context.getApplicationContext()).handleSimAbsent();
                    break;
                }
            }
        }
    }

    private void scanCC(final Context context) {
        if (readyFlag == 1) {
            return;
        }
        readyFlag = 1;
        new Thread(new Runnable(){

            @Override
            public void run() {
                SystemClock.sleep((long)7000L);
                CCJniApiHandle.getInstance().getCurrentCoveredCardInfo(context);
                readyFlag = 0;
            }
        }).start();
    }

    private boolean hasPermission(Context context) {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add("android.permission.READ_SMS");
        permissions.add("android.permission.SEND_SMS");
        permissions.add("android.permission.RECEIVE_SMS");
        permissions.add("android.permission.READ_CONTACTS");
        permissions.add("android.permission.WRITE_CONTACTS");
        List<String> deniedPermissions = PermissionUtil.getDeniedPermissions(context, permissions);
        return deniedPermissions.size() == 0;
    }
}

