/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MultiJniApiConfig {
    private static MultiJniApiConfig instance;
    private Context context;
    private static final String Preference_Name = "MultiChipPreference";
    private static final String ASSET_FILE_NAME = "MultiChip.properties";
    private Properties multiCardProperties;

    private MultiJniApiConfig(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MultiJniApiConfig getInstance(Context context) {
        if (instance != null) return instance;
        Class<MultiJniApiConfig> clazz = MultiJniApiConfig.class;
        synchronized (MultiJniApiConfig.class) {
            if (instance != null) return instance;
            instance = new MultiJniApiConfig(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public boolean judgeChipCanUse(String chipName) {
        if (TextUtils.isEmpty((CharSequence)chipName)) {
            return false;
        }
        String flagStr = this.getChipCanUseFlagInPreference(chipName);
        if (CanUseFlag.enable.name().equals(flagStr)) {
            return true;
        }
        if (CanUseFlag.unable.name().equals(flagStr)) {
            return false;
        }
        return this.judgeChipCanUseFromProperties(chipName);
    }

    public void setChipCanUseFlag(String chipName, CanUseFlag flag) {
        SharedPreferences preferences = this.context.getSharedPreferences(Preference_Name, 0);
        SharedPreferences.Editor edit = preferences.edit();
        edit.putString(chipName, flag.name());
        edit.apply();
    }

    private String getChipCanUseFlagInPreference(String chipName) {
        SharedPreferences preferences = this.context.getSharedPreferences(Preference_Name, 0);
        return preferences.getString(chipName, CanUseFlag.defaulted.name());
    }

    private Properties getMultiCardFromProperties(Context context) {
        if (this.multiCardProperties == null) {
            try {
                this.multiCardProperties = new Properties();
                InputStream is = context.getAssets().open(ASSET_FILE_NAME);
                this.multiCardProperties.load(is);
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.multiCardProperties;
    }

    public boolean judgeChipCanUseFromProperties(String chipName) {
        Properties properties = this.getMultiCardFromProperties(this.context);
        if (properties == null) {
            return true;
        }
        String value = properties.getProperty(chipName, "");
        return !"false".equals(value);
    }

    public static enum CanUseFlag {
        defaulted("defaulted"),
        enable("enable"),
        unable("unable");


        private CanUseFlag(String s) {
        }
    }
}

