/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.process.coveredcard.CCJniApi;
import com.xdja.multichip.process.coveredcard.CCProcessService;
import com.xdja.tmc.TMCAPI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CCHandleInit {
    private static final String TAG = "CCHandleIntTag";
    private Context context;
    XDJA_DEVINFO mDevInfo = new XDJA_DEVINFO();
    private static CCHandleInit instance;
    private CCJniApi ccJniApi;
    public static final String KEY_PARAM = "param";
    public static final String KEY_BUNDLE = "Bundle";
    public static final String KEY_MESSENGER = "Messenger";
    public static final String VALUE_OPENCC = "openCC";

    private CCHandleInit(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CCHandleInit getInstance(Context context) {
        if (context == null) {
            throw new NullPointerException("Context is null!");
        }
        if (instance != null) return instance;
        Class<CCHandleInit> clazz = CCHandleInit.class;
        synchronized (CCHandleInit.class) {
            if (instance != null) return instance;
            instance = new CCHandleInit(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized int openCard(CCJniApi jniApi) {
        Log.e((String)TAG, (String)"=================== openCard ");
        if (this.judgeSimIsReady() != 0) {
            return -1;
        }
        if (jniApi == null) {
            Log.e((String)TAG, (String)"=================== jniApi null ");
            return -2;
        }
        this.ccJniApi = jniApi;
        final boolean[] isSupportedFlag = new boolean[]{false};
        final CountDownLatch latch = new CountDownLatch(1);
        Messenger messenger = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                isSupportedFlag[0] = (Boolean)msg.obj;
                latch.countDown();
                Log.w((String)CCHandleInit.TAG, (String)("cc init handleMessage " + isSupportedFlag[0]));
            }
        });
        Intent intent = new Intent();
        intent.putExtra(KEY_PARAM, VALUE_OPENCC);
        intent.setClass(this.context, CCProcessService.class);
        Bundle bundle = new Bundle();
        bundle.putBinder(KEY_MESSENGER, messenger.getBinder());
        intent.putExtra(KEY_BUNDLE, bundle);
        this.context.startService(intent);
        try {
            latch.await(3500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (isSupportedFlag[0]) {
            return 0;
        }
        return -1;
    }

    public void openCC(Context context, Intent intent) {
        try {
            final Messenger messenger = new Messenger(intent.getBundleExtra(KEY_BUNDLE).getBinder(KEY_MESSENGER));
            if (this.ccJniApi != null) {
                this.ccJniApi.getTMCAPI().CloseSEService();
            }
            Log.w((String)TAG, (String)"OpenSEService OpenSEService before");
            if (this.ccJniApi == null) {
                Message msg = Message.obtain();
                try {
                    msg.obj = false;
                    messenger.send(msg);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                return;
            }
            this.ccJniApi.getTMCAPI().OpenSEService(context, new TMCAPI.TMCAPICallBack(){

                public void isSupported(boolean b) {
                    Message msg = Message.obtain();
                    try {
                        msg.obj = b;
                        messenger.send(msg);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                    String otiType = CCHandleInit.this.ccJniApi.getTMCAPI().GetOtiType();
                    Log.w((String)CCHandleInit.TAG, (String)("OpenSEService is supported " + b + " otiType: " + otiType));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int judgeSimIsReady() {
        TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
        int state = tm.getSimState();
        Log.e((String)TAG, (String)("=================== simState = " + state));
        if (state == 5) {
            return 0;
        }
        return -1;
    }
}

