package com.xdja.multichip.process;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_DIR;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_KEY_ATTR;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.activatechip.ActivateChip;
import com.xdja.multichip.AccessControlManager;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.InsideMultiChipUnitePinManager;
import com.xdja.multichip.JNIPinManager;
import com.xdja.multichip.param.JniApiParam;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/13 <br/>
 */

public abstract class SupperJniApiBinder extends IMultiJniApi.Stub {

    protected final static String KEY_METHOD = "method";
    protected final static String KEY_METHOD_UNLOCK_PIN_USE_USN = "UnlockPinUseUsn";
    protected final static String KEY_METHOD_IMPORT_CERT = "ImportCert";

    protected Context mContext;

    protected XDJA_DEVINFO devInfo = null;

    protected long mHandle = -1;

    public SupperJniApiBinder(Context context) {
        this.mContext = context.getApplicationContext() == null ? context : context.getApplicationContext();
    }

    protected abstract JNIAPI getApi();

    /**
     * 用于打开设备
     */
    protected abstract int selfOpenDev() throws RemoteException;


    /**
     * 得到芯片类型，参看：{@link JniApiParam#TYPE_ONBOARD}, {@link JniApiParam#TYPE_TF}, {@link JniApiParam#TYPE_BLUETOOTH}
     *
     * @return
     */
    protected abstract int getChipType();


    @Override
    public int GetVersion(byte[] verion, int[] ver_len) throws RemoteException {
        return getApi().GetVersion(verion, ver_len);
    }

    @Override
    public int EnumDev(int devType, int[] devNum) throws RemoteException {
        return getApi().EnumDev(devType, devNum);
    }

    @Override
    public int OpenDev(int index, long[] hHandle) throws RemoteException {
        return getApi().OpenDev(index, hHandle);
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) throws RemoteException {
        return getApi().OpenDevByName(devName, hHandle);
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) throws RemoteException {
        return getApi().OpenDevByNameEx(packagePath, hHandle);
    }

    @Override
    public int CloseDev(long handle) throws RemoteException {
        return getApi().CloseDev(mHandle);
    }

    @Override
    public int LockDev(long handle) throws RemoteException {
        return getApi().LockDev(mHandle);
    }

    @Override
    public int UnlockDev(long handle) throws RemoteException {
        return getApi().UnlockDev(mHandle);
    }

    @Override
    public int Transmit(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen) throws RemoteException {
        return getApi().Transmit(handle, cmd, cmdLen, dataOut, outLen);
    }

    @Override
    public int GetDevInfo(long handle, XDJA_DEVINFO devInfo) throws RemoteException {
//        int ret = getApi().GenRandom(handle,1,new byte[1]);
//        if (isDevOnline(ret)) {
//            ret = getApi().GetDevInfo(mHandle, devInfo);
//            return ret;
//        }

        //del 2017年10月18日18:35:45 weizg 贴膜卡测试发现，如果在贴膜卡尚未可用时，调用
        //GenRandom,会引起失败，导致初始化贴膜卡失败
//        GenRandom(handle,1,new byte[1]);

//        if (this.devInfo != null) {
//            System.arraycopy(this.devInfo.cardid, 0, devInfo.cardid, 0, 32);
//            System.arraycopy(this.devInfo.cosver, 0, devInfo.cosver, 0, 64);
//            devInfo.cardtype = this.devInfo.cardtype;
//            devInfo.reserve = this.devInfo.reserve;
//            return 0;
//        }
        int ret;
        ret = getApi().GetDevInfo(mHandle, devInfo);
        if (ret == 0) {
            this.devInfo = new XDJA_DEVINFO();
            System.arraycopy(devInfo.cardid, 0, this.devInfo.cardid, 0, 32);
            System.arraycopy(devInfo.cosver, 0, this.devInfo.cosver, 0, 64);
            this.devInfo.cardtype = devInfo.cardtype;
            this.devInfo.reserve = devInfo.reserve;
        }
        if (isDevOnline(ret)) {
            ret = getApi().GetDevInfo(mHandle, devInfo);
        }
        return ret;
    }

    @Override
    public int ActivateCard(long handle, byte[] param, int paramLen) throws RemoteException {
        int ret = getApi().ActivateCard(mHandle, param, paramLen);
        if (isDevOnline(ret)) {
            ret = getApi().ActivateCard(mHandle, param, paramLen);
        }
        return ret;
    }

    @Override
    public int GetActivateState(long handle) throws RemoteException {
        int ret = getApi().GetActivateState(mHandle);
        if (isDevOnline(ret)) {
            ret = getApi().GetActivateState(mHandle);
        }
        return ret;
    }

    @Override
    public int ChangePIN(long handle, int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen) throws RemoteException {
        int ret;
        int uid = getCallingUid();
        int pid = getCallingPid();
        ret = AccessControlManager.getInstance(mContext).checkByUidPid(uid, pid, "ChangePIN");
        if (ret != 0) {
            return ret;
        }
        ret = getApi().ChangePIN(mHandle, pinRole, oldPin, oldLen, newPin, newLen);
        if (isDevOnline(ret)) {
            ret = getApi().ChangePIN(mHandle, pinRole, oldPin, oldLen, newPin, newLen);
        }
        callUnitePin(ret, pinRole, newPin, "ChangePIN");
        return ret;
    }

    @Override
    public int GetPinTryCount(long handle, int pinRole) throws RemoteException {
        int ret = getApi().GetPinTryCount(mHandle, pinRole);
        if (isDevOnline(ret)) {
            ret = getApi().GetPinTryCount(mHandle, pinRole);
        }
        return ret;
    }

    @Override
    public int VerifyPIN(long handle, int pinRole, byte[] pin, int pinLen) throws RemoteException {
        int ret;
        int uid = getCallingUid();
        int pid = getCallingPid();
        ret = AccessControlManager.getInstance(mContext).checkByUidPid(uid, pid, "VerifyPIN");
        if (ret != 0) {
            return ret;
        }
        ret = getApi().VerifyPIN(mHandle, pinRole, pin, pinLen);
        if (isDevOnline(ret)) {
            ret = getApi().VerifyPIN(mHandle, pinRole, pin, pinLen);
        }
        callUnitePin(ret, pinRole, pin, "VerifyPIN");
        return ret;
    }

    @Override
    public int UnlockPIN(long handle, int id, byte[] key, int keyLen, byte[] newPin, int newLen) throws RemoteException {
        int ret;
        int uid = getCallingUid();
        int pid = getCallingPid();
        ret = AccessControlManager.getInstance(mContext).checkByUidPid(uid, pid, "UnlockPIN");
        if (ret != 0) {
            return ret;
        }
        ret = getApi().UnlockPIN(mHandle, id, key, keyLen, newPin, newLen);
        if (isDevOnline(ret)) {
            ret = getApi().UnlockPIN(mHandle, id, key, keyLen, newPin, newLen);
        }
        return ret;
    }

    @Override
    public int ReloadPIN(long handle, int pinRole, byte[] key, int keyLen, byte[] newPin, int newLen) throws RemoteException {
        int ret;
        int uid = getCallingUid();
        int pid = getCallingPid();
        ret = AccessControlManager.getInstance(mContext).checkByUidPid(uid, pid, "ReloadPIN");
        if (ret != 0) {
            return ret;
        }
        ret = getApi().ReloadPIN(mHandle, pinRole, key, keyLen, newPin, newLen);
        if (isDevOnline(ret)) {
            ret = getApi().ReloadPIN(mHandle, pinRole, key, keyLen, newPin, newLen);
        }
        callUnitePin(ret, pinRole, newPin, "UnlockPIN");
        return ret;
    }

    @Override
    public int CardReset(long handle) throws RemoteException {
        int ret = getApi().CardReset(mHandle);
        if (isDevOnline(ret)) {
            ret = getApi().CardReset(mHandle);
        }
        return ret;
    }

    @Override
    public int ExternAuth(long handle, byte exterAuthID, byte[] encRandom) throws RemoteException {
        int ret = getApi().ExternAuth(mHandle, exterAuthID, encRandom);
        if (isDevOnline(ret)) {
            ret = getApi().ExternAuth(mHandle, exterAuthID, encRandom);
        }
        return ret;
    }

    @Override
    public int InterAuth(long handle, byte[] dataIn, int inLen, int flag, byte kID, byte[] tmpKey, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().InterAuth(mHandle, dataIn, inLen, flag, kID, tmpKey, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().InterAuth(mHandle, dataIn, inLen, flag, kID, tmpKey, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int CreateDir(long handle, XDJA_DIR dir) throws RemoteException {
        int ret = getApi().CreateDir(mHandle, dir);
        if (isDevOnline(ret)) {
            ret = getApi().CreateDir(mHandle, dir);
        }
        return 0;
    }

    @Override
    public int SelectFile(long handle, byte[] fid) throws RemoteException {
        int ret = getApi().SelectFile(mHandle, fid);
        if (isDevOnline(ret)) {
            ret = getApi().SelectFile(mHandle, fid);
        }
        return ret;
    }

    @Override
    public int GetDirSize(long handle, int[] size) throws RemoteException {
        int ret = getApi().GetDirSize(mHandle, size);
        if (isDevOnline(ret)) {
            ret = getApi().GetDirSize(mHandle, size);
        }
        return ret;
    }

    @Override
    public int DeleteFile(long handle, byte[] fid) throws RemoteException {
        int ret = getApi().DeleteFile(mHandle, fid);
        if (isDevOnline(ret)) {
            ret = getApi().DeleteFile(mHandle, fid);
        }
        return ret;
    }

    @Override
    public int CreateFile(long handle, XDJA_FILE file) throws RemoteException {
        int ret = getApi().CreateFile(mHandle, file);
        if (isDevOnline(ret)) {
            ret = getApi().CreateFile(mHandle, file);
        }
        return ret;
    }

    @Override
    public int GetFileInfo(long handle, byte[] fid, XDJA_FILE file) throws RemoteException {
        int ret = getApi().GetFileInfo(mHandle, fid, file);
        if (isDevOnline(ret)) {
            ret = getApi().GetFileInfo(mHandle, fid, file);
        }
        return ret;
    }

    @Override
    public int ReadFile(long handle, byte[] fid, int readPos, int readLen, byte[] dataOut) throws RemoteException {
        int ret = getApi().ReadFile(mHandle, fid, readPos, readLen, dataOut);
        if (isDevOnline(ret)) {
            ret = getApi().ReadFile(mHandle, fid, readPos, readLen, dataOut);
        }
        return ret;
    }

    @Override
    public int WriteFile(long handle, byte[] fid, int writePos, int writeLen, byte[] dataIn) throws RemoteException {
        int ret = getApi().WriteFile(mHandle, fid, writePos, writeLen, dataIn);
        if (isDevOnline(ret)) {
            ret = getApi().WriteFile(mHandle, fid, writePos, writeLen, dataIn);
        }
        return ret;
    }

    @Override
    public int ReadRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) throws RemoteException {
        int ret = getApi().ReadRsaPubKey(mHandle, pubfid, pubKey);
        if (isDevOnline(ret)) {
            ret = getApi().ReadRsaPubKey(mHandle, pubfid, pubKey);
        }
        return ret;
    }

    @Override
    public int WriteRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) throws RemoteException {
        int ret = getApi().WriteRsaPubKey(mHandle, pubfid, pubKey);
        if (isDevOnline(ret)) {
            ret = getApi().WriteRsaPubKey(mHandle, pubfid, pubKey);
        }
        return ret;
    }

    @Override
    public int WriteRsaPriKey(long handle, byte[] prifid, XDJA_RSA_PRIKEY priKey) throws RemoteException {
        int ret = getApi().WriteRsaPriKey(mHandle, prifid, priKey);
        if (isDevOnline(ret)) {
            ret = getApi().WriteRsaPriKey(mHandle, prifid, priKey);
        }
        return ret;
    }

    @Override
    public int ReadSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) throws RemoteException {
        int ret = getApi().ReadSm2PubKey(mHandle, pubfid, pubKey);
        if (isDevOnline(ret)) {
            ret = getApi().ReadSm2PubKey(mHandle, pubfid, pubKey);
        }
        return ret;
    }

    @Override
    public int WriteSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) throws RemoteException {
        int ret = getApi().WriteSm2PubKey(mHandle, pubfid, pubKey);
        if (isDevOnline(ret)) {
            ret = getApi().WriteSm2PubKey(mHandle, pubfid, pubKey);
        }
        return ret;
    }

    @Override
    public int WriteSm2PriKey(long handle, byte[] prifid, XDJA_SM2_PRIKEY priKey) throws RemoteException {
        int ret = getApi().WriteSm2PriKey(mHandle, prifid, priKey);
        if (isDevOnline(ret)) {
            ret = getApi().WriteSm2PriKey(mHandle, prifid, priKey);
        }
        return ret;
    }

    @Override
    public int ReadCert(long handle, byte[] fid, byte[] certBuf, int[] certLen) throws RemoteException {
        int ret = getApi().ReadCert(mHandle, fid, certBuf, certLen);
        if (isDevOnline(ret)) {
            ret = getApi().ReadCert(mHandle, fid, certBuf, certLen);
        }
        return ret;
    }

    @Override
    public int WriteCert(long handle, byte[] fid, byte[] certBuf, int certLen) throws RemoteException {
        int ret = getApi().WriteCert(mHandle, fid, certBuf, certLen);
        if (isDevOnline(ret)) {
            ret = getApi().WriteCert(mHandle, fid, certBuf, certLen);
        }
        return ret;
    }

    @Override
    public int GenRandom(long handle, int len, byte[] random) throws RemoteException {
        int ret = getApi().GenRandom(mHandle, len, random);
        if (isDevOnline(ret)) {
            ret = getApi().GenRandom(mHandle, len, random);
        }
        return ret;
    }

    @Override
    public int DESKEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().DESKEY(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().DESKEY(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int DES3KEY(long handle, byte[] tmpKey, int tmpkeyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().DES3KEY(mHandle, tmpKey, tmpkeyLen, dataIn, inLen, flag, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().DES3KEY(mHandle, tmpKey, tmpkeyLen, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int AESKEY(long handle, byte[] tmpKey, int keyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().AESKEY(mHandle, tmpKey, keyLen, dataIn, inLen, flag, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().AESKEY(mHandle, tmpKey, keyLen, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int CreateKey(long handle, XDJA_KEY_ATTR keyAttr) throws RemoteException {
        int ret = getApi().CreateKey(mHandle, keyAttr);
        if (isDevOnline(ret)) {
            ret = getApi().CreateKey(mHandle, keyAttr);
        }
        return ret;
    }

    @Override
    public int ImportKey(long handle, int type, byte[] dataIn, byte kID) throws RemoteException {
        int ret = getApi().ImportKey(mHandle, type, dataIn, kID);
        if (isDevOnline(ret)) {
            ret = getApi().ImportKey(mHandle, type, dataIn, kID);
        }
        return ret;
    }

    @Override
    public int SM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte kID, byte[] IV) throws RemoteException {
        int ret = getApi().SM1(mHandle, dataIn, inLen, flag, dataOut, kID, IV);
        if (isDevOnline(ret)) {
            ret = getApi().SM1(mHandle, dataIn, inLen, flag, dataOut, kID, IV);
        }
        return ret;
    }

    @Override
    public int ImportTmpKey(long handle, byte[] tmpKey) throws RemoteException {
        int ret = getApi().ImportTmpKey(mHandle, tmpKey);
        if (isDevOnline(ret)) {
            ret = getApi().ImportTmpKey(mHandle, tmpKey);
        }
        return ret;
    }

    @Override
    public int TmpSM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().TmpSM1(mHandle, dataIn, inLen, flag, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().TmpSM1(mHandle, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int ImportCipherKey(long handle, byte[] tmpKey, int alg) throws RemoteException {
        int ret = getApi().ImportCipherKey(mHandle, tmpKey, alg);
        if (isDevOnline(ret)) {
            ret = getApi().ImportCipherKey(mHandle, tmpKey, alg);
        }
        return ret;
    }

    @Override
    public int TmpCipher(long handle, byte[] dataIn, int inLen, int alg, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().TmpCipher(mHandle, dataIn, inLen, alg, flag, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().TmpCipher(mHandle, dataIn, inLen, alg, flag, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int SM1KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().SM1KEY(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().SM1KEY(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int SSF33(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().SSF33(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().SSF33(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int SM4KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().SM4KEY(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().SM4KEY(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int SM4KEYEx(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().SM4KEYEx(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().SM4KEYEx(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int SM6KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = getApi().SM6KEY(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (isDevOnline(ret)) {
            ret = getApi().SM6KEY(mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    @Override
    public int GenRSAKeyPair(long handle, int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pubkey, XDJA_RSA_PRIKEY prikey) throws RemoteException {
        int ret = getApi().GenRSAKeyPair(mHandle, bits, pubfid, prifid, pubkey, prikey);
        if (isDevOnline(ret)) {
            ret = getApi().GenRSAKeyPair(mHandle, bits, pubfid, prifid, pubkey, prikey);
        }
        return ret;
    }

    @Override
    public int RSAPubKeyCalc(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().RSAPubKeyCalc(mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().RSAPubKeyCalc(mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    @Override
    public int RSAPriKeyCalc(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().RSAPriKeyCalc(mHandle, prifid, dataIn, inLen, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().RSAPriKeyCalc(mHandle, prifid, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    @Override
    public int RSAPriKeyCalcEx(long handle, byte[] pin, int pinLen, int pinRole, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().RSAPriKeyCalcEx(mHandle, pin, pinLen, pinRole, prifid, dataIn, inLen, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().RSAPriKeyCalcEx(mHandle, pin, pinLen, pinRole, prifid, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    @Override
    public int RSASign(long handle, int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().RSASign(mHandle, bits, prifid, dataType, dataIn, inLen, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().RSASign(mHandle, bits, prifid, dataType, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    @Override
    public int RSASignVerify(long handle, int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData) throws RemoteException {
        int ret = getApi().RSASignVerify(mHandle, bits, pubfid, pubkey, dataType, dataIn, inLen, signatureData);
        if (isDevOnline(ret)) {
            ret = getApi().RSASignVerify(mHandle, bits, pubfid, pubkey, dataType, dataIn, inLen, signatureData);
        }
        return ret;
    }

    @Override
    public int PackEnvelope(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int alg, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().PackEnvelope(mHandle, pubfid, pubkey, alg, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().PackEnvelope(mHandle, pubfid, pubkey, alg, dataOut, outLen);
        }
        return ret;
    }

    @Override
    public int UnpackEnvelope(long handle, byte[] prifid, int alg, byte[] dataIn, int inLen) throws RemoteException {
        int ret = getApi().UnpackEnvelope(mHandle, prifid, alg, dataIn, inLen);
        if (isDevOnline(ret)) {
            ret = getApi().UnpackEnvelope(mHandle, prifid, alg, dataIn, inLen);
        }
        return ret;
    }

    @Override
    public int KeyDisperse(long handle, int keyId, byte[] keyParam, int keyParamLen) throws RemoteException {
        int ret = getApi().KeyDisperse(mHandle, keyId, keyParam, keyParamLen);
        if (isDevOnline(ret)) {
            ret = getApi().KeyDisperse(mHandle, keyId, keyParam, keyParamLen);
        }
        return ret;
    }

    @Override
    public int SetSM2Id(long handle, byte[] sm2Id, int inLen) throws RemoteException {
        int ret = getApi().SetSM2Id(mHandle, sm2Id, inLen);
        if (isDevOnline(ret)) {
            ret = getApi().SetSM2Id(mHandle, sm2Id, inLen);
        }
        return ret;
    }

    @Override
    public int GetSM2Id(long handle, byte[] sm2Id, int[] outLen) throws RemoteException {
        int ret = getApi().GetSM2Id(mHandle, sm2Id, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().GetSM2Id(mHandle, sm2Id, outLen);
        }
        return ret;
    }

    @Override
    public int SetSM2Param(long handle, XDJA_SM2_PARAM param) throws RemoteException {
        int ret = getApi().SetSM2Param(mHandle, param);
        if (isDevOnline(ret)) {
            ret = getApi().SetSM2Param(mHandle, param);
        }
        return ret;
    }

    @Override
    public int GetSM2Param(long handle, XDJA_SM2_PARAM param) throws RemoteException {
        int ret = getApi().GetSM2Param(mHandle, param);
        if (isDevOnline(ret)) {
            ret = getApi().GetSM2Param(mHandle, param);
        }
        return ret;
    }

    @Override
    public int GenSM2KeyPair(long handle, byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey) throws RemoteException {
        int ret = getApi().GenSM2KeyPair(mHandle, pubfid, prifid, pubkey, prikey);
        if (isDevOnline(ret)) {
            ret = getApi().GenSM2KeyPair(mHandle, pubfid, prifid, pubkey, prikey);
        }
        return ret;
    }

    @Override
    public int SM2Encrypt(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().SM2Encrypt(mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().SM2Encrypt(mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    @Override
    public int SM2EncryptGM(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().SM2EncryptGM(mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().SM2EncryptGM(mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    @Override
    public int SM2Decrypt(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().SM2Decrypt(mHandle, prifid, dataIn, inLen, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().SM2Decrypt(mHandle, prifid, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    @Override
    public int SM2DecryptGM(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().SM2DecryptGM(mHandle, prifid, dataIn, inLen, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().SM2DecryptGM(mHandle, prifid, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    @Override
    public int SM2Sign(long handle, byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().SM2Sign(mHandle, pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().SM2Sign(mHandle, pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    /**
     * 备注：这个接口如果返回-10，表示验签失败。
     */
    @Override
    public int SM2SignVerify(long handle, byte[] pubfid, int dataType, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) throws RemoteException {
        int ret = getApi().SM2SignVerify(mHandle, pubfid, dataType, pubkey, dataIn, inLen, signatureData);
        if (isDevOnline(ret)) {
            ret = getApi().SM2SignVerify(mHandle, pubfid, dataType, pubkey, dataIn, inLen, signatureData);
        }
        return ret;
    }

    @Override
    public int SM2SignEx(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] signatureData, int[] signatureDataLen) throws RemoteException {
        int ret = getApi().SM2SignEx(mHandle, pubfid, prifid, dataIn, inLen, signatureData, signatureDataLen);
        if (isDevOnline(ret)) {
            ret = getApi().SM2SignEx(mHandle, pubfid, prifid, dataIn, inLen, signatureData, signatureDataLen);
        }
        return ret;
    }

    @Override
    public int SM2SignVerifyEx(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) throws RemoteException {
        int ret = getApi().SM2SignVerifyEx(mHandle, pubfid, pubkey, dataIn, inLen, signatureData);
        if (isDevOnline(ret)) {
            ret = getApi().SM2SignVerifyEx(mHandle, pubfid, pubkey, dataIn, inLen, signatureData);
        }
        return ret;
    }

    @Override
    public int SHA1(long handle, byte[] dataIn, int inLen, byte[] dataOut) throws RemoteException {
        int ret = getApi().SHA1(mHandle, dataIn, inLen, dataOut);
        if (isDevOnline(ret)) {
            ret = getApi().SHA1(mHandle, dataIn, inLen, dataOut);
        }
        return ret;
    }

    @Override
    public int SHA1Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) throws RemoteException {
        int ret = getApi().SHA1Ex(mHandle, dataIn, inLen, dataOut);
        if (isDevOnline(ret)) {
            ret = getApi().SHA1Ex(mHandle, dataIn, inLen, dataOut);
        }
        return ret;
    }

    @Override
    public int SM3(long handle, byte[] dataIn, int inLen, byte[] dataOut) throws RemoteException {
        int ret = getApi().SM3(mHandle, dataIn, inLen, dataOut);
        if (isDevOnline(ret)) {
            ret = getApi().SM3(mHandle, dataIn, inLen, dataOut);
        }
        return ret;
    }

    @Override
    public int SM3Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) throws RemoteException {
        int ret = getApi().SM3Ex(mHandle, dataIn, inLen, dataOut);
        if (isDevOnline(ret)) {
            ret = getApi().SM3Ex(mHandle, dataIn, inLen, dataOut);
        }
        return ret;
    }

    @Override
    public int SM2KeyGenInit(long handle, byte[] pubfid, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = getApi().SM2KeyGenInit(mHandle, pubfid, dataOut, outLen);
        if (isDevOnline(ret)) {
            ret = getApi().SM2KeyGenInit(mHandle, pubfid, dataOut, outLen);
        }
        return ret;
    }

    @Override
    public int SM2KeyGenCompute(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, byte dictFlag, byte keyFlag) throws RemoteException {
        int ret = getApi().SM2KeyGenCompute(mHandle, pubfid, prifid, dataIn, inLen, dataOut, outLen, dictFlag, keyFlag);
        if (isDevOnline(ret)) {
            ret = getApi().SM2KeyGenCompute(mHandle, pubfid, prifid, dataIn, inLen, dataOut, outLen, dictFlag, keyFlag);
        }
        return ret;
    }

    @Override
    public int SM2KeyGenVerify(long handle, byte[] dataIn, int inLen) throws RemoteException {
        int ret = getApi().SM2KeyGenVerify(mHandle, dataIn, inLen);
        if (isDevOnline(ret)) {
            ret = getApi().SM2KeyGenVerify(mHandle, dataIn, inLen);
        }
        return ret;
    }

    /**
     * 此接口写为同步接口；
     * 防止两个地方同时调用此接口进行激活
     *
     * @param handle
     * @param url
     * @return
     * @throws RemoteException
     */
    @Override
    public synchronized int ActivateCardByURL(long handle, String url) throws RemoteException {
        int ret = GetActivateState(handle);
        if (ret == 0) {
            return ret;
        }
        ActivateChip activateChip = new ActivateChip();
        ret = activateChip.activateChip(mContext, handle, url);
        return ret;
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        if (bundle.containsKey(KEY_METHOD)) {
            String method = bundle.getString(KEY_METHOD);
            if (KEY_METHOD_UNLOCK_PIN_USE_USN.equals(method)) {
                return UnlockPinUseUsn(bundle);
            } else if (KEY_METHOD_IMPORT_CERT.equals(method)) {
                return new SuppertImportCert().importCert(this, bundle);
            }
        }
        Bundle result = new Bundle();
        result.putInt("ret", -1);
        return result;
    }

    /**
     * 内部方法:
     * 判断是否是设备掉电引起的错误返回值
     * 如果是XKR_IO_FAILED 或 XKR_INVALID_PARA， 则可能是因为掉电引起的，
     * 此时，重新打开卡，如果重新打开卡，还是失败，则返回false，否则返回true。
     * 如果不是XKR_IO_FAILED 或 XKR_INVALID_PARA， 则直接返回false
     * <p>
     * update by xwy on 2017-9-15 15:39:34
     * 增加XKR_UNKNOWN错误码
     * 贴膜卡掉电后返回XKR_UNKNOWN错误码
     *
     * @param errcode
     * @return
     */
    protected boolean isDevOnline(int errcode) throws RemoteException {
        //通过卡接口收发数据失败，有可能是安全卡掉电引起。
        if (errcode == JNIAPI.XKR_NO_HANDLE || errcode == JNIAPI.XKR_IO_FAILED || errcode == JNIAPI.XKR_BACK_LENGTH
                || errcode == JNIAPI.XKR_BACK_DATA || errcode == JNIAPI.XKR_EEPROM_WRITE
                || errcode == JNIAPI.XKR_PARAMETER || errcode == JNIAPI.XKR_DATA_PARAMETER
                || errcode == JNIAPI.XKR_INVALID_DATA || errcode == JNIAPI.XKR_WRONG_MAC
                || errcode == JNIAPI.XKR_UNKNOWN) {
            selfOpenDev();
            if (mHandle == 0) {
                return false;
            }
            return true;
        } else {
            return false;
        }
    }

    protected String getCardId() {
        String cardId = "";
        XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
        try {
            int ret = GetDevInfo(0, devinfo);
            if (ret == 0) {
                cardId = new String(devinfo.cardid, 0, 32);
            }

            Log.w("JniApi", "getCardId ret: " + ret);
            Log.w("JniApi", "getCardId : " + cardId);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return cardId;
    }

    /**
     * 得到 JniApiParam
     *
     * @return
     */
    @Override
    public JniApiParam getJniApiParam() {
        XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
        try {
            int ret = GetDevInfo(mHandle, devinfo);
            if (ret == 0) {
                JniApiParam param = new JniApiParam();
                param.chipType = getChipType();
                param.cardId = new String(devinfo.cardid).trim();
                return param;
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 调用统一PIN码，将结果告之
     *
     * @param ret
     * @param role
     * @param pin
     * @param method
     */
    private void callUnitePin(int ret, int role, byte[] pin, String method) {
        String cardId = getCardId();
        InsideMultiChipUnitePinManager.getInstance().handlePinResult(mContext,
                cardId,
                role,
                pin,
                ret,
                method,
                getCallingUid(),
                getCallingPid(),
                "JNIAPI");
    }

    protected Bundle UnlockPinUseUsn(Bundle bundle) {

        int role = bundle.getInt("role");
        byte[] usn = bundle.getByteArray("usn");
        byte[] usnlockCode = bundle.getByteArray("usnlockCode");
        byte[] newPin = bundle.getByteArray("newPin");

        int ret = JNIPinManager.getInstance().XdjaUnlockPinUseUsn(getApi(), mHandle, role, usn, usnlockCode, newPin);
        Bundle result = new Bundle();
        result.putInt("ret", ret);
        return result;
    }
}
