package com.xdja.multichip.process.vhsm;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Context;
import android.provider.Settings;
import android.telephony.TelephonyManager;

import com.xdja.crypto.XDJACrypto;
import com.xdja.multichip.utils.PermissionUtil;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/1/15 <br/>
 */
public class VhsmUtils {

    /**
     * 在设备首次运行的时候，系统随机生成的64位数字。
     * 有可能为空
     *
     * @param context
     * @return
     */
    public static String getAndroidId(Context context) {
        if (context == null) {
            return "";
        }
        String androidId = Settings.System.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
        return androidId;
    }

    public static final String NO_PERMISSION = "NoPermission";

    @SuppressLint("MissingPermission")
    public static String getImei(Context context) throws VhsmBean.VhsmBeanException {
        String deviceId;
        //先判断是否有读取imei的权限，如果没有，则直接返回
        boolean flag = PermissionUtil.isGranted(context, Manifest.permission.READ_PHONE_STATE);
        if (!flag) {
            throw new VhsmBean.VhsmBeanException(NO_PERMISSION);
        }
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        deviceId = telephonyManager.getDeviceId();
        return deviceId;
    }


    /**
     * 获取mac地址
     */
    public static String getMacAddress(Context context) {
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        } catch (SocketException e) {
            e.printStackTrace();
        }
        String hardWareAddress = null;
        NetworkInterface iF = null;
        if (interfaces == null) {
            return null;
        }
        while (interfaces.hasMoreElements()) {
            iF = interfaces.nextElement();
            try {
                hardWareAddress = bytesToString(iF.getHardwareAddress());
                if (hardWareAddress != null) {
                    break;
                }
            } catch (SocketException e) {
                e.printStackTrace();
            }
        }
        return hardWareAddress;
    }

    /**
     * 计算成卡号
     *
     * @param id
     * @return
     */
    public static String calcVhsmCardId(String id) {
        XDJACrypto xdjaCrypto = new XDJACrypto("");
        xdjaCrypto.SM3Init();
        xdjaCrypto.SM3Update(id.getBytes(), id.length());
        byte[] out = new byte[32];
        xdjaCrypto.SM3Final(out);

        byte[] cardId = new byte[16];
        System.arraycopy("xdjavhsm".getBytes(), 0, cardId, 0, 8);
        System.arraycopy(out, 0, cardId, 8, 8);
        return convert(cardId);
    }


    /***
     * byte转为String
     *
     * @param bytes
     * @return
     */
    private static String bytesToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (byte b : bytes) {
            buf.append(String.format("%02X:", b));
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    /**
     * 转换
     *
     * @param data
     * @return
     */
    private static String convert(byte[] data) {
        char[] arr = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(arr[((data[i] & 0xF0) >> 4)]);
            sb.append(arr[(data[i] & 0xF)]);
        }
        return sb.toString();
    }
}
