/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.board;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.watchdata.jwtclient.WdCallback;
import com.watchdata.jwtclient.WdJwtSDK;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.anno.AutoChipForCall;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperJniApiBinder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@AutoChipForCall
public class OnboardJniApiBinder
extends SuperJniApiBinder {
    private static final String TAG = OnboardJniApiBinder.class.getSimpleName();
    JNIAPI jniapi = new JNIAPI();
    private static OnboardJniApiBinder instance;
    private static final String haisiPkgName = "com.fri.sonicom.sectoken";
    private static final String haisiServiceNmae = "com.fri.service.ZDTokenService";
    private static final String woqiPkgName = "com.watchsmart.epurse.skfmanager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OnboardJniApiBinder getInstance(Context context) {
        if (context == null) {
            return null;
        }
        if (instance != null) return instance;
        Class<OnboardJniApiBinder> clazz = OnboardJniApiBinder.class;
        synchronized (OnboardJniApiBinder.class) {
            if (instance != null) return instance;
            instance = new OnboardJniApiBinder(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private OnboardJniApiBinder(Context context) {
        super(context);
    }

    @Override
    protected JNIAPI getApi() {
        return this.jniapi;
    }

    @Override
    public int OpenDev(int index, long[] hHandle) throws RemoteException {
        int ret = this.getApi().OpenDev(index, hHandle);
        this.mHandle = ret == 0 ? hHandle[0] : 0L;
        return ret;
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) throws RemoteException {
        Log.v((String)TAG, (String)"This method(OpenDevByName) doesn't work!");
        return 0;
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) throws RemoteException {
        Log.v((String)TAG, (String)"This method(OpenDevByNameEx) doesn't work!");
        return 0;
    }

    @Override
    protected int selfOpenDev() {
        return this.initFirst();
    }

    private int initFirst() {
        int ret;
        long[] devHandle = new long[1];
        int[] devNum = new int[1];
        int devNumSum = 0;
        this.devInfo = null;
        try {
            ret = this.EnumDev(531, devNum);
            devNumSum += devNum[0];
            ret = this.EnumDev(535, devNum);
            devNumSum += devNum[0];
            ret = this.EnumDev(2560, devNum);
            devNumSum += devNum[0];
        }
        catch (RemoteException e) {
            e.printStackTrace();
            ret = -1;
        }
        if (devNumSum <= 0) {
            ret = -97;
        } else {
            try {
                ret = this.OpenDev(0, devHandle);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    protected int getChipType() {
        return 1;
    }

    @Override
    public JniApiParam getJniApiParam() {
        return super.getJniApiParam();
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        return super.callMethod(bundle);
    }

    private int openThirdChip() {
        int ret = this.openHaisi();
        if (ret == 0) {
            return ret;
        }
        ret = this.openWoqi();
        return ret;
    }

    private int openHaisi() {
        boolean flag = this.judgeAppExist(haisiPkgName);
        if (!flag) {
            return -97;
        }
        flag = this.bindHaisiService();
        if (!flag) {
            return -97;
        }
        long[] devHandle = new long[1];
        int[] devNum = new int[1];
        try {
            this.getApi().SetThirdPartySoName("libZDSkfInseApi.so".getBytes());
            this.CloseDev(this.mHandle);
            int ret = this.EnumDev(2304, devNum);
            if (ret != 0 || devNum[0] <= 0) {
                return -97;
            }
            ret = this.OpenDev(0, devHandle);
            return ret;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -97;
        }
    }

    private boolean bindHaisiService() {
        final boolean[] flag = new boolean[]{false};
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                ComponentName com = new ComponentName(OnboardJniApiBinder.haisiPkgName, OnboardJniApiBinder.haisiServiceNmae);
                intent.setAction("com.fri.service.IZDTokenService");
                intent.setComponent(com);
                try {
                    flag[0] = OnboardJniApiBinder.this.mContext.bindService(intent, new ServiceConnection(){

                        public void onServiceConnected(ComponentName name, IBinder service) {
                            flag[0] = true;
                            latch.countDown();
                        }

                        public void onServiceDisconnected(ComponentName name) {
                        }
                    }, 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        try {
            latch.await(1500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return flag[0];
    }

    private int openWoqi() {
        boolean flag = this.judgeAppExist(woqiPkgName);
        if (!flag) {
            return -97;
        }
        final String[] mPath = new String[1];
        final CountDownLatch latch = new CountDownLatch(1);
        WdJwtSDK jwtSDK = new WdJwtSDK(this.mContext);
        jwtSDK.initSDK(new WdCallback(){

            public void initResult(String token) {
                mPath[0] = token;
                latch.countDown();
            }
        });
        try {
            latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log.d((String)"wdskfapi", (String)("path: " + mPath));
        if (TextUtils.isEmpty((CharSequence)mPath[0])) {
            return -97;
        }
        int ret = this.jniapi.SetThirdPartySoName("libwdskf.so".getBytes());
        if (ret != 0) {
            return -97;
        }
        ret = this.jniapi.SetThirdPartyParam(mPath[0].getBytes());
        if (ret != 0) {
            return -97;
        }
        int[] devNum = new int[1];
        ret = this.jniapi.EnumDev(2304, devNum);
        if (ret != 0) {
            return -97;
        }
        long[] handles = new long[1];
        ret = this.jniapi.OpenDev(0, handles);
        if (ret != 0) {
            return -97;
        }
        this.mHandle = handles[0];
        return 0;
    }

    private boolean judgeAppExist(String pkgName) {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            pm.getPackageInfo(pkgName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }
}

