package com.xdja.multichip.process.tfcard;

import android.content.Context;
import android.os.Build;

import com.xdja.multichip.anno.AutoChipForCall;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperChipForCall;

import java.util.ArrayList;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/12/27 <br/>
 */
@AutoChipForCall
public class TFChipForCall extends SuperChipForCall {

    public static final String NAME_PROCESS_TF = "tfkey";


    @Override
    protected Class getProviderClass() {
        return TFProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_TF;
    }

    @Override
    public boolean isCanUse() {
        boolean flag = true;
        String model = Build.MODEL;
        if (noHasTFChipList.contains(model)) {
            flag = false;
        }
        return flag;
    }

    @Override
    public int getChipType() {
        return JniApiParam.TYPE_TF;
    }

    @Override
    public void setContext(Context context) {
        super.context = context;
    }


    /**
     * 不含芯片手机的list
     */
    private static ArrayList<String> noHasTFChipList = new ArrayList<>();

    static {
        noHasTFChipList.add("ACTOMA ACE");
    }
}
