package com.xdja.multichip.process.vhsm.net;

import android.os.Environment;
import android.os.FileObserver;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;

import java.io.File;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/5/24 <br/>
 */
public class NetVhsmFileListener {

    private static final String TAG = "NetVhsmFileListenerTag";
    private static NetVhsmFileListener instance;

    static final String randFilePath = new File(Environment.getExternalStorageDirectory(), NetVhsmChipForCall.randFilePath).getAbsolutePath();
    static final String wboxFilePath = new File(Environment.getExternalStorageDirectory(), NetVhsmChipForCall.wboxFilePath).getAbsolutePath();
    static final String vhsmLibFilePath = new File(Environment.getExternalStorageDirectory(), NetVhsmChipForCall.vhsmLibFilePath).getAbsolutePath();

    private PriNetVhsmFileListener randListener;
    private PriNetVhsmFileListener wboxListener;
    private PriNetVhsmFileListener vhsmLibListener;

    public static NetVhsmFileListener getInstance() {
        if (instance == null) {
            synchronized (NetVhsmFileListener.class) {
                if (instance == null) {
                    instance = new NetVhsmFileListener();
                }
            }
        }
        return instance;
    }

    private NetVhsmFileListener() {
        if (randListener == null) {
            randListener = new PriNetVhsmFileListener(randFilePath);
        }
        if (wboxListener == null) {
            wboxListener = new PriNetVhsmFileListener(wboxFilePath);
        }
        if (vhsmLibListener == null) {
            vhsmLibListener = new PriNetVhsmFileListener(vhsmLibFilePath);
        }
    }


    public void startObserver() {
        randListener.startWatching();
        wboxListener.startWatching();
        vhsmLibListener.startWatching();
    }


    private static final int FLAG_NOT_CHANGE = 0;
    private static final int FLAG_CHANGE = 1;
    private static int wboxChangeFlag = FLAG_NOT_CHANGE;

    static void setWboxChange() {
        wboxChangeFlag = FLAG_CHANGE;
    }

    static int getWboxChangeFlag() {
        return wboxChangeFlag;
    }

    static void setWboxNotChange() {
        wboxChangeFlag = FLAG_NOT_CHANGE;
    }

    class PriNetVhsmFileListener extends FileObserver {

        private String path;
        private int startWatchFlag = 0;

        public PriNetVhsmFileListener(String path) {
            super(path);
            this.path = path;
        }

        @Override
        public void onEvent(final int event, String path) {

            if (event == FileObserver.MODIFY) {
                SystemClock.sleep(500);
                if (getWboxChangeFlag() == FLAG_NOT_CHANGE) {
                    killSelf(event, this.path);
                } else {
                    setWboxNotChange();
                }
            } else if (event == FileObserver.DELETE || event == FileObserver.DELETE_SELF) {
                killSelf(event, this.path);
            }
        }

        @Override
        public void startWatching() {
            File file = new File(path);
            if (file.exists()) {
                if (startWatchFlag == 0) {
                    startWatchFlag = 1;
                    super.startWatching();
                }
            } else {
                if (startWatchFlag == 1) {
                    stopWatching();
                }
            }
        }

        @Override
        public void stopWatching() {
            startWatchFlag = 0;
            super.stopWatching();
        }
    }

    private static void killSelf(int event, String path) {
        Log.e(TAG, "killSelf event = " + event + " path = " + path);
        SystemClock.sleep(500);
        Process.killProcess(Process.myPid());
    }

}
