/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm.net;

import android.os.Environment;
import android.os.FileObserver;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import java.io.File;

public class NetVhsmFileListener {
    private static final String TAG = "NetVhsmFileListenerTag";
    private static NetVhsmFileListener instance;
    static final String randFilePath;
    static final String wboxFilePath;
    static final String vhsmLibFilePath;
    private PriNetVhsmFileListener randListener;
    private PriNetVhsmFileListener wboxListener;
    private PriNetVhsmFileListener vhsmLibListener;
    private static final int FLAG_NOT_CHANGE = 0;
    private static final int FLAG_CHANGE = 1;
    private static int wboxChangeFlag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetVhsmFileListener getInstance() {
        if (instance != null) return instance;
        Class<NetVhsmFileListener> clazz = NetVhsmFileListener.class;
        synchronized (NetVhsmFileListener.class) {
            if (instance != null) return instance;
            instance = new NetVhsmFileListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NetVhsmFileListener() {
        if (this.randListener == null) {
            this.randListener = new PriNetVhsmFileListener(randFilePath);
        }
        if (this.wboxListener == null) {
            this.wboxListener = new PriNetVhsmFileListener(wboxFilePath);
        }
        if (this.vhsmLibListener == null) {
            this.vhsmLibListener = new PriNetVhsmFileListener(vhsmLibFilePath);
        }
    }

    public void startObserver() {
        this.randListener.startWatching();
        this.wboxListener.startWatching();
        this.vhsmLibListener.startWatching();
    }

    static void setWboxChange() {
        wboxChangeFlag = 1;
    }

    static int getWboxChangeFlag() {
        return wboxChangeFlag;
    }

    static void setWboxNotChange() {
        wboxChangeFlag = 0;
    }

    private static void killSelf(int event, String path) {
        Log.e((String)TAG, (String)("killSelf event = " + event + " path = " + path));
        SystemClock.sleep((long)500L);
        Process.killProcess((int)Process.myPid());
    }

    static {
        randFilePath = new File(Environment.getExternalStorageDirectory(), "xdja/vhsm/net/rand.bin").getAbsolutePath();
        wboxFilePath = new File(Environment.getExternalStorageDirectory(), "xdja/vhsm/net/wbox.lib").getAbsolutePath();
        vhsmLibFilePath = new File(Environment.getExternalStorageDirectory(), "xdja/vhsm/net/vhsm.lib").getAbsolutePath();
        wboxChangeFlag = 0;
    }

    class PriNetVhsmFileListener
    extends FileObserver {
        private String path;
        private int startWatchFlag;

        public PriNetVhsmFileListener(String path) {
            super(path);
            this.startWatchFlag = 0;
            this.path = path;
        }

        public void onEvent(int event, String path) {
            if (event == 2) {
                SystemClock.sleep((long)500L);
                if (NetVhsmFileListener.getWboxChangeFlag() == 0) {
                    NetVhsmFileListener.killSelf(event, this.path);
                } else {
                    NetVhsmFileListener.setWboxNotChange();
                }
            } else if (event == 512 || event == 1024) {
                NetVhsmFileListener.killSelf(event, this.path);
            }
        }

        public void startWatching() {
            File file = new File(this.path);
            if (file.exists()) {
                if (this.startWatchFlag == 0) {
                    this.startWatchFlag = 1;
                    super.startWatching();
                }
            } else if (this.startWatchFlag == 1) {
                this.stopWatching();
            }
        }

        public void stopWatching() {
            this.startWatchFlag = 0;
            super.stopWatching();
        }
    }
}

