/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.coveredcard;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.util.Log;
import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.process.CardProcessService;
import com.xdja.multichip.process.ProcessExitsReceiver;
import com.xdja.multichip.process.coveredcard.CCJniApi;
import com.xdja.multichip.process.coveredcard.CCJniApiHandle;
import com.xdja.multichip.process.coveredcard.CCProcessService;
import com.xdja.multichip.utils.SharedPreferencesUtil;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class CCProcessProvider
extends ContentProvider {
    private static final String TAG = "CCProcessProviderTag";
    private static AtomicInteger callingFlag = new AtomicInteger(0);

    public boolean onCreate() {
        Log.e((String)TAG, (String)("onCreate pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + this.getCallingPackage()));
        Context context = this.getContext();
        if (SharedPreferencesUtil.getCcPersistence(context)) {
            CCJniApi.getInstance(context).getTMCAPI().SetLogFlag(true);
        }
        if (!MultiJniApiConfig.getInstance(context).judgeChipCanUse("coveredcard")) {
            return false;
        }
        CardProcessService.startService(context, new Intent(context, CCProcessService.class));
        ProcessExitsReceiver.register(context);
        return false;
    }

    public Bundle call(String method, String arg, Bundle extras) {
        Log.e((String)TAG, (String)("call method: " + method));
        Log.e((String)TAG, (String)("calling pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + this.getCallingPackage()));
        Bundle bundle = new Bundle();
        if ("GetJniApiBinder".equals(method)) {
            CCProcessProvider.increaseFlag();
            ArrayList<Bundle> list = CCJniApiHandle.getInstance().getCurrentCoveredCardInfo(this.getContext());
            bundle.putInt("ret", 0);
            bundle.putParcelableArrayList("JniApiParam", list);
            Log.e((String)TAG, (String)("result list size = " + (list == null ? 0 : list.size())));
            CCProcessProvider.decreaseFlag();
            return bundle;
        }
        if ("CcSetLogFlag".equals(method)) {
            return this.handleSetLogFlag(extras);
        }
        return super.call(method, arg, extras);
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    private Bundle handleSetLogFlag(Bundle bundle) {
        boolean flag = bundle.getBoolean("flag", false);
        boolean isPersistence = bundle.getBoolean("isPersistence", false);
        Log.i((String)TAG, (String)("flag = " + flag + ", isPersistence = " + isPersistence));
        Context context = this.getContext();
        SharedPreferencesUtil.setCcPersistence(context, isPersistence);
        CCJniApi.getInstance(context).getTMCAPI().SetLogFlag(flag);
        Bundle result = new Bundle();
        result.putInt("ret", 0);
        return result;
    }

    private static void increaseFlag() {
        callingFlag.incrementAndGet();
    }

    private static void decreaseFlag() {
        callingFlag.decrementAndGet();
    }

    public static int getCallingFlag() {
        return callingFlag.get();
    }
}

