/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm.net;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_DIR;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_KEY_ATTR;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.process.vhsm.net.NetVhsmFileListener;
import com.xdja.multichip.process.vhsm.net.NetVhsmJniapiBinder;
import com.xdja.multichip.process.vhsm.net.VhsmBeanConvert;
import com.xdja.vhsm.base.VHSMBase;
import com.xdja.vhsm.base.XDJA_VHSM_DEVINFO;
import com.xdja.vhsm.base.XDJA_VHSM_FILE;
import com.xdja.vhsm.base.XDJA_VHSM_KEY_ATTR;
import com.xdja.vhsm.base.XDJA_VHSM_RSA_PRIKEY;
import com.xdja.vhsm.base.XDJA_VHSM_RSA_PUBKEY;
import com.xdja.vhsm.base.XDJA_VHSM_SM2_PRIKEY;
import com.xdja.vhsm.base.XDJA_VHSM_SM2_PUBKEY;
import java.io.File;
import java.nio.charset.StandardCharsets;

public class NetVhsmJniApi
extends JNIAPI {
    private static final String TAG = "NetVhsmTag";
    static VHSMBase jniapi = new VHSMBase();
    private Context context;
    File randFile = new File(NetVhsmFileListener.RANDFILEPATH);
    File wboxFile = new File(NetVhsmFileListener.WBOXFILEPATH);
    File vhsmLibFile = new File(NetVhsmFileListener.VHSMLIBFILEPATH);
    long timeWhenOpen = 0L;

    public NetVhsmJniApi(Context context) {
        this.context = context;
    }

    public int SetVhsmPath(String path) {
        Log.d((String)TAG, (String)("set path " + path));
        if (TextUtils.isEmpty((CharSequence)path)) {
            return 0;
        }
        int ret = jniapi.SetDevPath(path.getBytes(StandardCharsets.UTF_8));
        Log.d((String)TAG, (String)("set path ret" + ret));
        return ret;
    }

    public int GetVersion(byte[] verion, int[] ver_len) {
        return jniapi.GetVersion(verion, ver_len);
    }

    public int EnumDev(int devType, int[] devNum) {
        return jniapi.EnumDev(devType, devNum);
    }

    public int OpenDev(int index, long[] hHandle) {
        try {
            int ret = jniapi.OpenDev(index, hHandle);
            if (ret == 0) {
                this.timeWhenOpen = this.randFile.lastModified();
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -97;
        }
    }

    public int OpenDevByName(byte[] devName, long[] hHandle) {
        return -1001;
    }

    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) {
        return -1001;
    }

    public int CloseDev(long handle) {
        int ret = jniapi.CloseDev(handle);
        this.timeWhenOpen = 0L;
        if (handle != 0L) {
            JarMultiChipStatusManager.getInstance().sendCardStatus(this.context, "", 32, -1);
        }
        return ret;
    }

    public int LockDev(long handle) {
        return jniapi.LockDev(handle);
    }

    public int UnlockDev(long handle) {
        return jniapi.UnlockDev(handle);
    }

    public int Transmit(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen) {
        return -1001;
    }

    public int TransmitEx(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen) {
        return -1001;
    }

    public int GetDevInfo(long handle, XDJA_DEVINFO devInfo) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_DEVINFO vhsmDevInfo = new XDJA_VHSM_DEVINFO();
        ret = jniapi.GetDevInfo(handle, vhsmDevInfo);
        if (ret == 0) {
            try {
                VhsmBeanConvert.convert(vhsmDevInfo, devInfo);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return -100;
            }
        }
        return ret;
    }

    public int SetLogPath(byte[] logPath) {
        return -1001;
    }

    public int ActivateCard(long handle, byte[] param, int paramLen) {
        return -1001;
    }

    public int GetActivateState(long handle) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return 0;
    }

    public int ChangePIN(long handle, int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        ret = jniapi.ChangePIN(handle, pinRole, oldPin, oldLen, newPin, newLen);
        if (ret == 0) {
            NetVhsmFileListener.setWboxChange();
        }
        return ret;
    }

    public int GetPinTryCount(long handle, int pinRole) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.GetPinTryCount(handle, pinRole);
    }

    public int VerifyPIN(long handle, int pinRole, byte[] pin, int pinLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        ret = jniapi.VerifyPIN(handle, pinRole, pin, pinLen);
        return ret;
    }

    public int UnlockPIN(long handle, int id, byte[] key, int keyLen, byte[] newPin, int newLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.UnlockPIN(handle, id, key, keyLen, newPin, newLen);
    }

    public int ReloadPIN(long handle, int pinRole, byte[] key, int keyLen, byte[] newPin, int newLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.ReloadPIN(handle, pinRole, key, keyLen, newPin, newLen);
    }

    public int CardReset(long handle) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.CardReset(handle);
    }

    public int ExternAuth(long handle, byte exterAuthID, byte[] encRandom) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.ExternalAuth(handle, exterAuthID, encRandom);
    }

    public int InterAuth(long handle, byte[] dataIn, int inLen, int flag, byte kID, byte[] tmpKey, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int CreateDir(long handle, XDJA_DIR dir) {
        return -1001;
    }

    public int SelectFile(long handle, byte[] fid) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SelectFile(handle, fid);
    }

    public int DeleteFile(long handle, byte[] fid) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.DeleteFile(handle, fid);
    }

    public int GetDirSize(long handle, int[] size) {
        return -1001;
    }

    public int CreateFile(long handle, XDJA_FILE file) {
        XDJA_VHSM_FILE vhsmFile;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            vhsmFile = VhsmBeanConvert.convertTo(file, XDJA_VHSM_FILE.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.CreateFile(handle, vhsmFile);
    }

    public int GetFileInfo(long handle, byte[] fid, XDJA_FILE file) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_FILE vhsmFile = new XDJA_VHSM_FILE();
        ret = jniapi.GetFileInfo(handle, fid, vhsmFile);
        if (ret == 0) {
            try {
                VhsmBeanConvert.convert(vhsmFile, file);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return -100;
            }
        }
        return ret;
    }

    public int ReadFile(long handle, byte[] fid, int readPos, int readLen, byte[] dataOut) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.ReadFile(handle, fid, readPos, readLen, dataOut);
    }

    public int WriteFile(long handle, byte[] fid, int writePos, int writeLen, byte[] dataIn) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.WriteFile(handle, fid, writePos, writeLen, dataIn);
    }

    public int ReadRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_RSA_PUBKEY vhsmRsaPubkey = new XDJA_VHSM_RSA_PUBKEY();
        ret = jniapi.ReadRsaPubKey(handle, pubfid, vhsmRsaPubkey);
        if (ret == 0) {
            try {
                VhsmBeanConvert.convert(vhsmRsaPubkey, pubKey);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return -100;
            }
        }
        return ret;
    }

    public int WriteRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        XDJA_VHSM_RSA_PUBKEY vhsmRsaPubkey;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            vhsmRsaPubkey = VhsmBeanConvert.convertTo(pubKey, XDJA_VHSM_RSA_PUBKEY.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.WriteRsaPubKey(handle, pubfid, vhsmRsaPubkey);
    }

    public int WriteRsaPriKey(long handle, byte[] prifid, XDJA_RSA_PRIKEY priKey) {
        XDJA_VHSM_RSA_PRIKEY vhsmRsaPrikey;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            vhsmRsaPrikey = VhsmBeanConvert.convertTo(priKey, XDJA_VHSM_RSA_PRIKEY.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.WriteRsaPriKey(handle, prifid, vhsmRsaPrikey);
    }

    public int ReadSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_SM2_PUBKEY vhsmSm2Pubkey = new XDJA_VHSM_SM2_PUBKEY();
        ret = jniapi.ReadSm2PubKey(handle, pubfid, vhsmSm2Pubkey);
        if (ret == 0) {
            try {
                VhsmBeanConvert.convert(vhsmSm2Pubkey, pubKey);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return -100;
            }
        }
        return ret;
    }

    public int WriteSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        XDJA_VHSM_SM2_PUBKEY vhsmSm2Pubkey;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            vhsmSm2Pubkey = VhsmBeanConvert.convertTo(pubKey, XDJA_VHSM_SM2_PUBKEY.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.WriteSm2PubKey(handle, pubfid, vhsmSm2Pubkey);
    }

    public int WriteSm2PriKey(long handle, byte[] prifid, XDJA_SM2_PRIKEY priKey) {
        XDJA_VHSM_SM2_PRIKEY vhsmSm2Prikey;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            vhsmSm2Prikey = VhsmBeanConvert.convertTo(priKey, XDJA_VHSM_SM2_PRIKEY.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.WriteSm2PriKey(handle, prifid, vhsmSm2Prikey);
    }

    public int ReadCert(long handle, byte[] fid, byte[] certBuf, int[] certLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.ReadCert(handle, fid, certBuf, certLen);
    }

    public int WriteCert(long handle, byte[] fid, byte[] certBuf, int certLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.WriteCert(handle, fid, certBuf, certLen);
    }

    public int GenRandom(long handle, int len, byte[] random) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.GenRandom(handle, len, random);
    }

    public int DESKEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int DES3KEY(long handle, byte[] tmpKey, int tmpkeyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int AESKEY(long handle, byte[] tmpKey, int keyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int CreateKey(long handle, XDJA_KEY_ATTR keyAttr) {
        XDJA_VHSM_KEY_ATTR vhsmKeyAttr;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            vhsmKeyAttr = VhsmBeanConvert.convertTo(keyAttr, XDJA_VHSM_KEY_ATTR.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.CreateKey(handle, vhsmKeyAttr);
    }

    public int ImportKey(long handle, int type, byte[] dataIn, byte kID) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.ImportKey(handle, type, dataIn, kID);
    }

    public int SM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM1(handle, dataIn, inLen, flag, dataOut, kID, IV);
    }

    public int ImportTmpKey(long handle, byte[] tmpKey) {
        return -1001;
    }

    public int TmpSM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int ImportCipherKey(long handle, byte[] tmpKey, int alg) {
        return -1001;
    }

    public int TmpCipher(long handle, byte[] dataIn, int inLen, int alg, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int SM1KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM1KEY(handle, tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    public int SSF33(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int SM4KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM4KEY(handle, tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    public int SM4KEYEx(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int SM6KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int GenRSAKeyPair(long handle, int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pubkey, XDJA_RSA_PRIKEY prikey) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_RSA_PUBKEY vhsmRsaPubkey = new XDJA_VHSM_RSA_PUBKEY();
        XDJA_VHSM_RSA_PRIKEY vhsmRsaPrikey = new XDJA_VHSM_RSA_PRIKEY();
        ret = jniapi.GenRSAKeyPair(handle, bits, pubfid, prifid, vhsmRsaPubkey, vhsmRsaPrikey);
        if (ret == 0) {
            try {
                VhsmBeanConvert.convert(vhsmRsaPubkey, pubkey);
                VhsmBeanConvert.convert(vhsmRsaPrikey, prikey);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return -100;
            }
        }
        return ret;
    }

    public int RSAPubKeyCalc(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        XDJA_VHSM_RSA_PUBKEY vhsmRsaPubkey;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            vhsmRsaPubkey = VhsmBeanConvert.convertTo(pubkey, XDJA_VHSM_RSA_PUBKEY.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.RSAPubKeyCalc(handle, pubfid, vhsmRsaPubkey, dataIn, inLen, dataOut, outLen);
    }

    public int RSAPriKeyCalc(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.RSAPriKeyCalc(handle, prifid, dataIn, inLen, dataOut, outLen);
    }

    public int RSAPriKeyCalcEx(long handle, byte[] pin, int pinLen, int pinRole, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return -1001;
    }

    public int RSASign(long handle, int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.RSASign(handle, bits, prifid, dataType, dataIn, inLen, dataOut, outLen);
    }

    public int RSASignVerify(long handle, int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData) {
        XDJA_VHSM_RSA_PUBKEY vhsmRsaPubkey;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            vhsmRsaPubkey = VhsmBeanConvert.convertTo(pubkey, XDJA_VHSM_RSA_PUBKEY.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.RSASignVerify(handle, bits, pubfid, vhsmRsaPubkey, dataType, dataIn, inLen, signatureData);
    }

    public int PackEnvelope(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int alg, byte[] dataOut, int[] outLen) {
        return -1001;
    }

    public int UnpackEnvelope(long handle, byte[] prifid, int alg, byte[] dataIn, int inLen) {
        return -1001;
    }

    public int KeyDisperse(long handle, int keyId, byte[] keyParam, int keyParamLen) {
        return -1001;
    }

    public int SetSM2Id(long handle, byte[] sm2Id, int inLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SetSM2Id(handle, sm2Id, inLen);
    }

    public int GetSM2Id(long handle, byte[] sm2Id, int[] outLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.GetSM2Id(handle, sm2Id, outLen);
    }

    public int SetSM2Param(long handle, XDJA_SM2_PARAM param) {
        return -1001;
    }

    public int GetSM2Param(long handle, XDJA_SM2_PARAM param) {
        return -1001;
    }

    public int GenSM2KeyPair(long handle, byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_SM2_PUBKEY vhsmSm2Pubkey = new XDJA_VHSM_SM2_PUBKEY();
        XDJA_VHSM_SM2_PRIKEY vhsmSm2Prikey = new XDJA_VHSM_SM2_PRIKEY();
        ret = jniapi.GenSM2KeyPair(handle, pubfid, prifid, vhsmSm2Pubkey, vhsmSm2Prikey);
        if (ret == 0) {
            try {
                VhsmBeanConvert.convert(vhsmSm2Pubkey, pubkey);
                VhsmBeanConvert.convert(vhsmSm2Prikey, prikey);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return -100;
            }
        }
        return ret;
    }

    public int SM2Encrypt(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        XDJA_VHSM_SM2_PUBKEY sm2Pubkey;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            sm2Pubkey = VhsmBeanConvert.convertTo(pubkey, XDJA_VHSM_SM2_PUBKEY.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.SM2Encrypt(handle, pubfid, sm2Pubkey, dataIn, inLen, dataOut, outLen);
    }

    public int SM2EncryptGM(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        XDJA_VHSM_SM2_PUBKEY sm2Pubkey;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            sm2Pubkey = VhsmBeanConvert.convertTo(pubkey, XDJA_VHSM_SM2_PUBKEY.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.SM2EncryptGM(handle, pubfid, sm2Pubkey, dataIn, inLen, dataOut, outLen);
    }

    public int SM2Decrypt(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2Decrypt(handle, prifid, dataIn, inLen, dataOut, outLen);
    }

    public int SM2DecryptGM(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2DecryptGM(handle, prifid, dataIn, inLen, dataOut, outLen);
    }

    public int SM2Sign(long handle, byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2Sign(handle, pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
    }

    public int SM2SignVerify(long handle, byte[] pubfid, int dataType, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        XDJA_VHSM_SM2_PUBKEY sm2Pubkey;
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        try {
            sm2Pubkey = VhsmBeanConvert.convertTo(pubkey, XDJA_VHSM_SM2_PUBKEY.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return -100;
        }
        return jniapi.SM2SignVerify(handle, pubfid, dataType, sm2Pubkey, dataIn, inLen, signatureData);
    }

    public int SM2SignEx(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] signatureData, int[] signatureDataLen) {
        return -1001;
    }

    public int SM2SignVerifyEx(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        return -1001;
    }

    public int SHA1(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return -1001;
    }

    public int SHA1Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return -1001;
    }

    public int SM3(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM3(handle, dataIn, inLen, dataOut);
    }

    public int SM3Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return -1001;
    }

    public int SM2KeyGenInit(long handle, byte[] pubfid, byte[] dataOut, int[] outLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2KeyGenInit(handle, pubfid, dataOut, outLen);
    }

    public int SM2KeyGenCompute(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, byte dictFlag, byte keyFlag) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2KeyGenCompute(handle, pubfid, prifid, dataIn, inLen, dataOut, outLen, dictFlag, keyFlag);
    }

    public int SM2KeyGenVerify(long handle, byte[] dataIn, int inLen) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2KeyGenVerify(handle, dataIn, inLen);
    }

    public int SM4(long handle, byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        int ret = this.judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM4(handle, dataIn, dataLen, flag, dataOut, kID, IV);
    }

    private int judgeFileExist() {
        if (!(this.randFile.exists() && this.wboxFile.exists() && this.vhsmLibFile.exists())) {
            try {
                Log.e((String)TAG, (String)"File not exist!Then CloseDev!");
                NetVhsmJniapiBinder.getInstance(this.context).CloseDev(0L);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return -97;
        }
        long currentTime = this.randFile.lastModified();
        if (currentTime != this.timeWhenOpen) {
            try {
                if (this.timeWhenOpen != 0L) {
                    Log.e((String)TAG, (String)"RandFile lastModifiedTime is not equal currentTime!Then CloseDev!");
                    NetVhsmJniapiBinder.getInstance(this.context).CloseDev(0L);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return NetVhsmJniapiBinder.getInstance(this.context).selfOpenDev();
        }
        return 0;
    }
}

