package com.xdja.multichip;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import com.xdja.multichip.process.coveredcard.CCChipForCall;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/1/7 <br/>
 */
public class MultiJniApiConfig {
    public static final String KEY_I2C_PATH = "I2CPath";

    private static MultiJniApiConfig instance;
    private Context context;

    private static final String PREFERENCE_NAME = "MultiChipPreference";
    private static final String ASSET_FILE_NAME = "MultiChip.properties";

    /**
     * 是否打开其他公司芯片的标志位；
     * 如果值为true，表示要去打开其他公司芯片；
     * 其他值则不打开
     */
    public static final String KEY_ISOPEN_THIRD_CHIP = "isOpenThirdChip";

    private MultiJniApiConfig(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    /**
     * 获取实例
     *
     * @param context
     * @return
     */
    public static MultiJniApiConfig getInstance(Context context) {
        if (instance == null) {
            synchronized (MultiJniApiConfig.class) {
                if (instance == null) {
                    instance = new MultiJniApiConfig(context);
                }
            }
        }
        return instance;
    }

    /**
     * 判断芯片是否可用
     *
     * @param chipName
     * @return
     */
    public boolean judgeChipCanUse(String chipName) {
        if (TextUtils.isEmpty(chipName)) {
            return false;
        }
        String flagStr = getChipCanUseFlagInPreference(chipName);
        if (CanUseFlag.ENABLE.name().equals(flagStr)) {
            return true;
        } else if (CanUseFlag.UNABLE.name().equals(flagStr)) {
            return false;
        } else {
            return judgeStateFromProperties(chipName);
        }
    }

    /**
     * 判断是否关闭低速通道
     */
    public boolean isCloseLowChannel() {
        boolean isSupportLowChannel = judgeStateFromProperties(CCChipForCall.NAME_SUPPORT_LOWCHANNEL);
        return !isSupportLowChannel;
    }


    /**
     * 设置芯片是否可用
     *
     * @param chipName
     * @param flag
     */
    public void setChipCanUseFlag(String chipName, CanUseFlag flag) {
        SharedPreferences preferences = context.getSharedPreferences(PREFERENCE_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor edit = preferences.edit();
        edit.putString(chipName, flag.name());
        edit.apply();
    }

    /**
     * 从Preference中获取标志位
     *
     * @param chipName
     * @return
     */
    private String getChipCanUseFlagInPreference(String chipName) {
        SharedPreferences preferences = context.getSharedPreferences(PREFERENCE_NAME, Context.MODE_PRIVATE);
        return preferences.getString(chipName, CanUseFlag.DEFAULTED.name());
    }

    private Properties multiCardProperties;

    public Properties getMultiCardFromProperties(Context context) {
        if (multiCardProperties == null) {
            try {
                multiCardProperties = new Properties();
                InputStream is = context.getAssets().open(ASSET_FILE_NAME);
                multiCardProperties.load(is);
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return multiCardProperties;
    }


    /**
     * 从Properties中判断
     *
     * @param propertyKey
     * @return
     */
    public boolean judgeStateFromProperties(String propertyKey) {
        Properties properties = getMultiCardFromProperties(context);
        if (properties == null) {
            return true;
        }
        String value = properties.getProperty(propertyKey, "");

        if ("false".equals(value)) {
            return false;
        }
        return true;
    }


    public enum CanUseFlag {
        /**
         * 默认
         */
        DEFAULTED("defaulted"),
        /**
         * 允许
         */
        ENABLE("enable"),
        /**
         * 禁止
         */
        UNABLE("unable");

        CanUseFlag(String s) {

        }
    }
}
