package com.xdja.multichip.process;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;

import java.util.List;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/10/21 <br/>
 */
public class ProcessExitsReceiver extends BroadcastReceiver {
    public static final String KEY_ACTION = "com.xdja.multichip.process.exits";

    /**
     * 注册
     *
     * @param context
     */
    public static void register(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(KEY_ACTION);
        context.registerReceiver(new ProcessExitsReceiver(), intentFilter);
    }

    @Override
    public void onReceive(final Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (intent.getAction().equals(KEY_ACTION)) {
            new Thread(new Runnable() {
                @Override
                public void run() {
                    processExits(context);
                }
            }).start();
        }
    }

    public static void processExits(Context context) {
        Log.e("ProcessExitsReceiver","process exits");
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningServiceInfo> runningServices = am.getRunningServices(20);
        for (ActivityManager.RunningServiceInfo info : runningServices) {
            if (info.pid == Process.myPid()) {
                ComponentName service = info.service;
                Intent is = new Intent();
                is.setClassName(context, service.getClassName());
                context.stopService(is);
            }
        }
        SystemClock.sleep(100);
        System.exit(0);
    }
}
