package com.xdja.multichip.process.vhsm;

import android.text.TextUtils;

import java.io.File;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/1/15 <br/>
 */
public abstract class VhsmBean {

    /**
     * 获取Id
     *
     * @return
     */
    public abstract String getId() throws VhsmBeanException;

    /**
     * 获取虚拟卡文件
     *
     * @return
     */
    public abstract File getVhsmDatFile() throws VhsmBeanException;

    /**
     * 获取虚拟卡的密码
     *
     * @return
     */
    public abstract String getVhsmPwd() throws VhsmBeanException;

    public abstract int handleVhsmBeanException(VhsmBeanException e);

    /**
     * 获取id对应的卡号
     *
     * @return
     */
    public String getCardId() throws VhsmBeanException {
        String id = getId();
        if (TextUtils.isEmpty(id)) {
            return "";
        }

        String cardId = VhsmUtils.calcVhsmCardId(id);
        return cardId;
    }

    public static class VhsmBeanException extends Exception {
        public VhsmBeanException(String msg) {
            super(msg);
        }
    }
}
