package com.xdja.multichip.process.vhsm.net;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_DIR;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_KEY_ATTR;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.jniapi.JarMultiJniApiErrorCode;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.vhsm.base.VHSMBase;
import com.xdja.vhsm.base.XDJA_VHSM_DEVINFO;
import com.xdja.vhsm.base.XDJA_VHSM_FILE;
import com.xdja.vhsm.base.XDJA_VHSM_KEY_ATTR;
import com.xdja.vhsm.base.XDJA_VHSM_RSA_PRIKEY;
import com.xdja.vhsm.base.XDJA_VHSM_RSA_PUBKEY;
import com.xdja.vhsm.base.XDJA_VHSM_SM2_PRIKEY;
import com.xdja.vhsm.base.XDJA_VHSM_SM2_PUBKEY;

import java.io.File;
import java.nio.charset.StandardCharsets;


/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/11/15 <br/>
 */
public class NetVhsmJniApi extends JNIAPI {

    private static final String TAG = "NetVhsmTag";

    static VHSMBase jniapi = new VHSMBase();
    private Context context;

    public NetVhsmJniApi(Context context) {
        this.context = context;
    }

    public int SetVhsmPath(String path) {
        if (TextUtils.isEmpty(path)) {
            return 0;
        }
        final int ret = jniapi.SetDevPath(path.getBytes(StandardCharsets.UTF_8));
        Log.d(TAG, "set path ret=" + ret);
        return ret;
    }

    @Override
    public int GetVersion(byte[] verion, int[] ver_len) {
        return jniapi.GetVersion(verion, ver_len);
    }

    @Override
    public int EnumDev(int devType, int[] devNum) {
        return jniapi.EnumDev(devType, devNum);
    }

    @Override
    public int OpenDev(int index, long[] hHandle) {
        //add by zhangxiaolong 2019-12-27 加上try-catch的目的是为了防止没有赋予 电话权限而 openDev造成的异常；
        //因为so库中没有判断是否具有电话权限，而直接获取imei了。
        try {
            int ret = jniapi.OpenDev(index, hHandle);
            //add by zhangxiaolong 2019-12-12 在打开时保存一下randFile的修改时间，用于之后的接口比对时间，
            //防止重新初始化了，本进程不知道的情况
            if (ret == 0) {
                timeWhenOpen = new File(VhsmFileHandle.getInstance().getRandfilePath()).lastModified();
            }
            return ret;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return JNIAPI.XKR_NO_KEY;
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CloseDev(long handle) {
        int ret = jniapi.CloseDev(handle);
        //add by zhangxiaolong 2020-6-22 当closeDev时，将timeWhenOpen
        timeWhenOpen = 0;
        if (handle != 0) {
            JarMultiChipStatusManager.getInstance().sendCardStatus(context, "", JniApiParam.TYPE_VHSM_NET, JarMultiChipStatusManager.CARD_STATUS_NOT_EXIST);
        }
        return ret;
    }

    @Override
    public int LockDev(long handle) {
        return jniapi.LockDev(handle);
    }

    @Override
    public int UnlockDev(long handle) {
        return jniapi.UnlockDev(handle);
    }

    @Override
    public int Transmit(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int TransmitEx(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetDevInfo(long handle, XDJA_DEVINFO devInfo) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_DEVINFO vhsmDevInfo = new XDJA_VHSM_DEVINFO();
        ret = jniapi.GetDevInfo(handle, vhsmDevInfo);
        if (ret == 0) {
            try {
                VhsmBeanConvert.convert(vhsmDevInfo, devInfo);
            } catch (NoSuchFieldException | IllegalAccessException e) {
                e.printStackTrace();
                return JNIAPI.XKR_UNKNOWN;
            }
        }
        return ret;
    }

    @Override
    public int SetLogPath(byte[] logPath) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ActivateCard(long handle, byte[] param, int paramLen) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetActivateState(long handle) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return 0;
    }

    //访问控制类接口
    @Override
    public int ChangePIN(long handle, int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        ret = jniapi.ChangePIN(handle, pinRole, oldPin, oldLen, newPin, newLen);
        if (ret == 0) {
            NetVhsmFileListener.setWboxChange();
        }
        return ret;
    }

    @Override
    public int GetPinTryCount(long handle, int pinRole) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.GetPinTryCount(handle, pinRole);
    }

    @Override
    public int VerifyPIN(long handle, int pinRole, byte[] pin, int pinLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        ret = jniapi.VerifyPIN(handle, pinRole, pin, pinLen);
        return ret;
    }

    @Override
    public int UnlockPIN(long handle, int id, byte[] key, int keyLen, byte[] newPin, int newLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.UnlockPIN(handle, id, key, keyLen, newPin, newLen);
    }

    @Override
    public int ReloadPIN(long handle, int pinRole, byte[] key, int keyLen, byte[] newPin, int newLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.ReloadPIN(handle, pinRole, key, keyLen, newPin, newLen);
    }

    @Override
    public int CardReset(long handle) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.CardReset(handle);
    }

    @Override
    public int ExternAuth(long handle, byte exterAuthID, byte[] encRandom) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.ExternalAuth(handle, exterAuthID, encRandom);
    }

    @Override
    public int InterAuth(long handle, byte[] dataIn, int inLen, int flag, byte kID, byte[] tmpKey, byte[] dataOut, byte[] IV) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    //文件管理类接口
    @Override
    public int CreateDir(long handle, XDJA_DIR dir) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SelectFile(long handle, byte[] fid) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SelectFile(handle, fid);
    }

    @Override
    public int DeleteFile(long handle, byte[] fid) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.DeleteFile(handle, fid);
    }

    @Override
    public int GetDirSize(long handle, int[] size) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CreateFile(long handle, XDJA_FILE file) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_FILE vhsmFile;
        try {
            vhsmFile = VhsmBeanConvert.convertTo(file, XDJA_VHSM_FILE.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
        return jniapi.CreateFile(handle, vhsmFile);
    }

    @Override
    public int GetFileInfo(long handle, byte[] fid, XDJA_FILE file) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }

        XDJA_VHSM_FILE vhsmFile = new XDJA_VHSM_FILE();
        ret = jniapi.GetFileInfo(handle, fid, vhsmFile);
        if (ret == 0) {
            try {
                VhsmBeanConvert.convert(vhsmFile, file);
            } catch (NoSuchFieldException | IllegalAccessException e) {
                e.printStackTrace();
                return JNIAPI.XKR_UNKNOWN;
            }
        }

        return ret;
    }

    @Override
    public int ReadFile(long handle, byte[] fid, int readPos, int readLen, byte[] dataOut) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.ReadFile(handle, fid, readPos, readLen, dataOut);
    }

    @Override
    public int WriteFile(long handle, byte[] fid, int writePos, int writeLen, byte[] dataIn) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.WriteFile(handle, fid, writePos, writeLen, dataIn);
    }

    @Override
    public int ReadRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_RSA_PUBKEY vhsmRsaPubkey = new XDJA_VHSM_RSA_PUBKEY();
        ret = jniapi.ReadRsaPubKey(handle, pubfid, vhsmRsaPubkey);
        if (ret == 0) {
            try {
                VhsmBeanConvert.convert(vhsmRsaPubkey, pubKey);
            } catch (NoSuchFieldException | IllegalAccessException e) {
                e.printStackTrace();
                return JNIAPI.XKR_UNKNOWN;
            }
        }
        return ret;
    }

    @Override
    public int WriteRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_RSA_PUBKEY vhsmRsaPubkey;
        try {
            vhsmRsaPubkey = VhsmBeanConvert.convertTo(pubKey, XDJA_VHSM_RSA_PUBKEY.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
        return jniapi.WriteRsaPubKey(handle, pubfid, vhsmRsaPubkey);
    }

    @Override
    public int WriteRsaPriKey(long handle, byte[] prifid, XDJA_RSA_PRIKEY priKey) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_RSA_PRIKEY vhsmRsaPrikey;
        try {
            vhsmRsaPrikey = VhsmBeanConvert.convertTo(priKey, XDJA_VHSM_RSA_PRIKEY.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
        return jniapi.WriteRsaPriKey(handle, prifid, vhsmRsaPrikey);
    }

    @Override
    public int ReadSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_SM2_PUBKEY vhsmSm2Pubkey = new XDJA_VHSM_SM2_PUBKEY();
        ret = jniapi.ReadSm2PubKey(handle, pubfid, vhsmSm2Pubkey);
        if (ret == 0) {
            try {
                VhsmBeanConvert.convert(vhsmSm2Pubkey, pubKey);
            } catch (NoSuchFieldException | IllegalAccessException e) {
                e.printStackTrace();
                return JNIAPI.XKR_UNKNOWN;
            }
        }
        return ret;
    }

    @Override
    public int WriteSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_SM2_PUBKEY vhsmSm2Pubkey;
        try {
            vhsmSm2Pubkey = VhsmBeanConvert.convertTo(pubKey, XDJA_VHSM_SM2_PUBKEY.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }

        return jniapi.WriteSm2PubKey(handle, pubfid, vhsmSm2Pubkey);
    }

    @Override
    public int WriteSm2PriKey(long handle, byte[] prifid, XDJA_SM2_PRIKEY priKey) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_SM2_PRIKEY vhsmSm2Prikey;
        try {
            vhsmSm2Prikey = VhsmBeanConvert.convertTo(priKey, XDJA_VHSM_SM2_PRIKEY.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }

        return jniapi.WriteSm2PriKey(handle, prifid, vhsmSm2Prikey);
    }

    @Override
    public int ReadCert(long handle, byte[] fid, byte[] certBuf, int[] certLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.ReadCert(handle, fid, certBuf, certLen);
    }

    @Override
    public int WriteCert(long handle, byte[] fid, byte[] certBuf, int certLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.WriteCert(handle, fid, certBuf, certLen);
    }

    //密码服务类接口
    @Override
    public int GenRandom(long handle, int len, byte[] random) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.GenRandom(handle, len, random);
    }

    //对称算法
    @Override
    public int DESKEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int DES3KEY(long handle, byte[] tmpKey, int tmpkeyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int AESKEY(long handle, byte[] tmpKey, int keyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CreateKey(long handle, XDJA_KEY_ATTR keyAttr) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }

        XDJA_VHSM_KEY_ATTR vhsmKeyAttr;
        try {
            vhsmKeyAttr = VhsmBeanConvert.convertTo(keyAttr, XDJA_VHSM_KEY_ATTR.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
        return jniapi.CreateKey(handle, vhsmKeyAttr);
    }

    @Override
    public int ImportKey(long handle, int type, byte[] dataIn, byte kID) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.ImportKey(handle, type, dataIn, kID);
    }

    @Override
    public int SM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM1(handle, dataIn, inLen, flag, dataOut, kID, IV);
    }

    @Override
    public int ImportTmpKey(long handle, byte[] tmpKey) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int TmpSM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ImportCipherKey(long handle, byte[] tmpKey, int alg) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int TmpCipher(long handle, byte[] dataIn, int inLen, int alg, int flag, byte[] dataOut, byte[] IV) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM1KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM1KEY(handle, tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    @Override
    public int SSF33(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM4KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM4KEY(handle, tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    @Override
    public int SM4KEYEx(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM6KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    /**
     * 卡内产生RSA密钥对
     * 条件：密钥对不出卡时要求有写指定公私钥文件的权限
     *
     * @param bits   [in]RSA公钥模数长度，1024或2048
     * @param pubfid [in]公钥文件ID，为0x00 0x00时表示公钥导出卡外
     * @param prifid [in]私钥文件ID，公私钥文件ID均为0x00 0x00时私钥可导出卡外
     * @param pubkey [in]RSA公钥结构，公钥文件ID为0x00 0x00时有效
     * @param prikey [in]RSA私钥结构，公私钥文件ID均为0x00 0x00时有效
     * @return 错误码
     * {@link JNIAPI#XKR_OK }   成功
     */
    @Override
    public int GenRSAKeyPair(long handle, int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pubkey, XDJA_RSA_PRIKEY prikey) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_RSA_PUBKEY vhsmRsaPubkey = new XDJA_VHSM_RSA_PUBKEY();
        XDJA_VHSM_RSA_PRIKEY vhsmRsaPrikey = new XDJA_VHSM_RSA_PRIKEY();

        ret = jniapi.GenRSAKeyPair(handle, bits, pubfid, prifid, vhsmRsaPubkey, vhsmRsaPrikey);
        if (ret == 0) {
            try {
                //这里不判断 pubfid 和 prifid 为0的原因是：
                //如果为0，则表示要导出到卡外，也就是pubkey或prikey不是null，直接转换就行；
                //如果不是0，则表示要产生到卡内，也就是pubkey或prikey是null，在VhsmBeanConvert.convert中，
                // 已经判断参数为null的情况了，所以直接写没有问题
                VhsmBeanConvert.convert(vhsmRsaPubkey, pubkey);
                VhsmBeanConvert.convert(vhsmRsaPrikey, prikey);
            } catch (NoSuchFieldException | IllegalAccessException e) {
                e.printStackTrace();
                return JNIAPI.XKR_UNKNOWN;
            }
        }
        return ret;
    }

    @Override
    public int RSAPubKeyCalc(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_RSA_PUBKEY vhsmRsaPubkey;
        try {
            vhsmRsaPubkey = VhsmBeanConvert.convertTo(pubkey, XDJA_VHSM_RSA_PUBKEY.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
        return jniapi.RSAPubKeyCalc(handle, pubfid, vhsmRsaPubkey, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int RSAPriKeyCalc(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.RSAPriKeyCalc(handle, prifid, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int RSAPriKeyCalcEx(long handle, byte[] pin, int pinLen, int pinRole, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int RSASign(long handle, int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.RSASign(handle, bits, prifid, dataType, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int RSASignVerify(long handle, int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }

        XDJA_VHSM_RSA_PUBKEY vhsmRsaPubkey;
        try {
            vhsmRsaPubkey = VhsmBeanConvert.convertTo(pubkey, XDJA_VHSM_RSA_PUBKEY.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
        return jniapi.RSASignVerify(handle, bits, pubfid, vhsmRsaPubkey, dataType, dataIn, inLen, signatureData);
    }

    @Override
    public int PackEnvelope(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int alg, byte[] dataOut, int[] outLen) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int UnpackEnvelope(long handle, byte[] prifid, int alg, byte[] dataIn, int inLen) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int KeyDisperse(long handle, int keyId, byte[] keyParam, int keyParamLen) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SetSM2Id(long handle, byte[] sm2Id, int inLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SetSM2Id(handle, sm2Id, inLen);
    }

    @Override
    public int GetSM2Id(long handle, byte[] sm2Id, int[] outLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.GetSM2Id(handle, sm2Id, outLen);
    }

    @Override
    public int SetSM2Param(long handle, XDJA_SM2_PARAM param) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetSM2Param(long handle, XDJA_SM2_PARAM param) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    /**
     * 生成SM2密钥对
     *
     * @param pubfid [in]   公钥文件ID,为0x00 0x00时表示公钥导出卡外
     * @param prifid [in]   私钥文件ID,公私钥ID均为0x00 0x00时表示私钥导出卡外
     * @param pubkey [out]  SM2公钥结构，公钥文件ID为0x00 0x00时有效并且不能为空
     * @param prikey [out]  SM2私钥结构，公私钥文件ID均为0x00 0x00时有效并且不能为空
     * @return 错误码
     * {@link JNIAPI#XKR_OK }   成功
     */
    @Override
    public int GenSM2KeyPair(long handle, byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }

        XDJA_VHSM_SM2_PUBKEY vhsmSm2Pubkey = new XDJA_VHSM_SM2_PUBKEY();
        XDJA_VHSM_SM2_PRIKEY vhsmSm2Prikey = new XDJA_VHSM_SM2_PRIKEY();
        ret = jniapi.GenSM2KeyPair(handle, pubfid, prifid, vhsmSm2Pubkey, vhsmSm2Prikey);
        if (ret == 0) {
            try {
                //这里不判断 pubfid 和 prifid 为0的原因是：
                //如果为0，则表示要导出到卡外，也就是pubkey或prikey不是null，直接转换就行；
                //如果不是0，则表示要产生到卡内，也就是pubkey或prikey是null，在VhsmBeanConvert.convert中，
                // 已经判断参数为null的情况了，所以直接写没有问题
                VhsmBeanConvert.convert(vhsmSm2Pubkey, pubkey);
                VhsmBeanConvert.convert(vhsmSm2Prikey, prikey);
            } catch (NoSuchFieldException | IllegalAccessException e) {
                e.printStackTrace();
                return JNIAPI.XKR_UNKNOWN;
            }
        }

        return ret;
    }

    @Override
    public int SM2Encrypt(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_SM2_PUBKEY sm2Pubkey;
        try {
            sm2Pubkey = VhsmBeanConvert.convertTo(pubkey, XDJA_VHSM_SM2_PUBKEY.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
        return jniapi.SM2Encrypt(handle, pubfid, sm2Pubkey, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int SM2EncryptGM(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_SM2_PUBKEY sm2Pubkey;
        try {
            sm2Pubkey = VhsmBeanConvert.convertTo(pubkey, XDJA_VHSM_SM2_PUBKEY.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
        return jniapi.SM2EncryptGM(handle, pubfid, sm2Pubkey, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int SM2Decrypt(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2Decrypt(handle, prifid, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int SM2DecryptGM(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2DecryptGM(handle, prifid, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int SM2Sign(long handle, byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2Sign(handle, pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
    }

    /**
     * 备注：这个接口如果返回-10，表示验签失败。
     */
    @Override
    public int SM2SignVerify(long handle, byte[] pubfid, int dataType, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        XDJA_VHSM_SM2_PUBKEY sm2Pubkey;
        try {
            sm2Pubkey = VhsmBeanConvert.convertTo(pubkey, XDJA_VHSM_SM2_PUBKEY.class);
        } catch (NoSuchFieldException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
        return jniapi.SM2SignVerify(handle, pubfid, dataType, sm2Pubkey, dataIn, inLen, signatureData);
    }

    @Override
    public int SM2SignEx(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] signatureData, int[] signatureDataLen) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM2SignVerifyEx(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    //Hash
    @Override
    public int SHA1(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SHA1Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM3(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM3(handle, dataIn, inLen, dataOut);
    }

    @Override
    public int SM3Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;
    }

    //Application
    @Override
    public int SM2KeyGenInit(long handle, byte[] pubfid, byte[] dataOut, int[] outLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2KeyGenInit(handle, pubfid, dataOut, outLen);
    }

    @Override
    public int SM2KeyGenCompute(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, byte dictFlag, byte keyFlag) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2KeyGenCompute(handle, pubfid, prifid, dataIn, inLen, dataOut, outLen, dictFlag, keyFlag);
    }

    @Override
    public int SM2KeyGenVerify(long handle, byte[] dataIn, int inLen) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM2KeyGenVerify(handle, dataIn, inLen);
    }

    public int SM4(long handle, byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        int ret = judgeFileExist();
        if (ret != 0) {
            return ret;
        }
        return jniapi.SM4(handle, dataIn, dataLen, flag, dataOut, kID, IV);
    }


    long timeWhenOpen = 0;

    private int judgeFileExist() {
        File randFile = new File(VhsmFileHandle.getInstance().getRandfilePath());
        File wboxFile = new File(VhsmFileHandle.getInstance().getWboxfilePath());
        File vhsmLibFile = new File(VhsmFileHandle.getInstance().getVhsmlibfilePath());
        if (!randFile.exists() || !wboxFile.exists() || !vhsmLibFile.exists()) {
            try {
                Log.e(TAG, "File not exist!Then CloseDev!");
                NetVhsmJniapiBinder.getInstance(context).CloseDev(0);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
            return JNIAPI.XKR_NO_KEY;
        }

        //--------------------------------------------↓
        //add by zhangxiaolong 2019-12-12 和打开时保存randFile的修改时间 进行比对，防止重新初始化了，本进程不知道的情况
        long currentTime = randFile.lastModified();
        if (currentTime != timeWhenOpen) {
            try {
                //modify by zhangxiaolong 2020-6-22 如果timeWhenOpen为0
                if (timeWhenOpen != 0) {
                    Log.e(TAG, "RandFile lastModifiedTime is not equal currentTime!Then CloseDev!");
                    NetVhsmJniapiBinder.getInstance(context).CloseDev(0);
                }
            } catch (RemoteException e) {
                e.printStackTrace();
            }
            return NetVhsmJniapiBinder.getInstance(context).selfOpenDev();
        }
        //--------------------------------------------↑
        return 0;
    }
}
