package com.xdja.multichip.process.vhsm.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;

import java.io.File;

/**
 * @author hyh
 * @data 2023/2/3 10:09
 */
public class VhsmFileHandle {
    private final static String TAG="VhsmFileHandle";
    private final static VhsmFileHandle INSTANCE = new VhsmFileHandle();
    private static final String FILE_NAME = "vhsm_file";
    private static final String VHSM_PATH = "vhsm_path";
    static final String DEFAULT_FILE_DIR = new File(Environment.getExternalStorageDirectory(), "xdja/vhsm/net").getAbsolutePath();
    private String currentVhsmPath = DEFAULT_FILE_DIR;

    private VhsmFileHandle() {

    }

    public static VhsmFileHandle getInstance() {
        return INSTANCE;
    }

    public int setVhsmCustomPath(Context context, String path) {
        Log.d(TAG,"set file path "+path);
        currentVhsmPath = path;
        saveVhsmPath(context, path);
        NetVhsmJniApi netVhsmJniApi = new NetVhsmJniApi(context);
        int ret = netVhsmJniApi.SetVhsmPath(path);
        return ret;
    }

    public void saveVhsmPath(Context context, String path) {
        if (TextUtils.isEmpty(path)) {
            path = "";
        }
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(VHSM_PATH, path);
        editor.commit();
    }

    public String getLocalVhsmPath(Context context) {
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sharedPreferences.getString(VHSM_PATH, "");
    }

    private String getCacheVhsmPath() {
        if (TextUtils.isEmpty(currentVhsmPath)) {
            currentVhsmPath = DEFAULT_FILE_DIR;
        }
        Log.e(TAG,"get current vhsm path "+currentVhsmPath);
        return currentVhsmPath;
    }

    public String getRandfilePath() {
        return getCacheVhsmPath()+File.separator + "rand.bin";
    }

    public String getWboxfilePath() {
        return getCacheVhsmPath()+File.separator + "wbox.lib";
    }

    public String getKdatfilePath() {
        return getCacheVhsmPath()+File.separator + "vhsm.dat";
    }

    public String getVhsmlibfilePath() {
        return getCacheVhsmPath()+File.separator + "vhsm.lib";
    }


    public boolean judgeVhsmFileComplete() {
        File randFile = new File(getRandfilePath());
        if (!randFile.exists()) {
            return false;
        }
        File wboxFile = new File(getWboxfilePath());
        if (!wboxFile.exists()) {
            return false;
        }
        File kdatFile = new File(getKdatfilePath());
        if (!kdatFile.exists()) {
            return false;
        }
        return true;
    }
}
