/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MultiJniApiConfig {
    public static final String KEY_I2C_PATH = "I2CPath";
    private static MultiJniApiConfig instance;
    private Context context;
    private static final String PREFERENCE_NAME = "MultiChipPreference";
    private static final String ASSET_FILE_NAME = "MultiChip.properties";
    public static final String KEY_ISOPEN_THIRD_CHIP = "isOpenThirdChip";
    private Properties multiCardProperties;

    private MultiJniApiConfig(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MultiJniApiConfig getInstance(Context context) {
        if (instance != null) return instance;
        Class<MultiJniApiConfig> clazz = MultiJniApiConfig.class;
        synchronized (MultiJniApiConfig.class) {
            if (instance != null) return instance;
            instance = new MultiJniApiConfig(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public boolean judgeChipCanUse(String chipName) {
        if (TextUtils.isEmpty((CharSequence)chipName)) {
            return false;
        }
        String flagStr = this.getChipCanUseFlagInPreference(chipName);
        if (CanUseFlag.ENABLE.name().equals(flagStr)) {
            return true;
        }
        if (CanUseFlag.UNABLE.name().equals(flagStr)) {
            return false;
        }
        return this.judgeStateFromProperties(chipName);
    }

    public boolean isCloseLowChannel() {
        boolean isSupportLowChannel = this.judgeStateFromProperties("supportLowChannel");
        return !isSupportLowChannel;
    }

    public void setChipCanUseFlag(String chipName, CanUseFlag flag) {
        SharedPreferences preferences = this.context.getSharedPreferences(PREFERENCE_NAME, 0);
        SharedPreferences.Editor edit = preferences.edit();
        edit.putString(chipName, flag.name());
        edit.apply();
    }

    private String getChipCanUseFlagInPreference(String chipName) {
        SharedPreferences preferences = this.context.getSharedPreferences(PREFERENCE_NAME, 0);
        return preferences.getString(chipName, CanUseFlag.DEFAULTED.name());
    }

    public Properties getMultiCardFromProperties(Context context) {
        if (this.multiCardProperties == null) {
            try {
                this.multiCardProperties = new Properties();
                InputStream is = context.getAssets().open(ASSET_FILE_NAME);
                this.multiCardProperties.load(is);
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.multiCardProperties;
    }

    public boolean judgeStateFromProperties(String propertyKey) {
        Properties properties = this.getMultiCardFromProperties(this.context);
        if (properties == null) {
            return true;
        }
        String value = properties.getProperty(propertyKey, "");
        return !"false".equals(value);
    }

    public static enum CanUseFlag {
        DEFAULTED("defaulted"),
        ENABLE("enable"),
        UNABLE("unable");


        private CanUseFlag(String s) {
        }
    }
}

