/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm.net;

import android.content.Context;
import android.content.Intent;
import android.os.FileObserver;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.xdja.multichip.process.vhsm.net.NetVhsmService;
import com.xdja.multichip.process.vhsm.net.VhsmFileHandle;
import java.io.File;

public class NetVhsmFileListener {
    private static final String TAG = "NetVhsmFileListenerTag";
    private static NetVhsmFileListener instance;
    private PriNetVhsmFileListener randListener;
    private PriNetVhsmFileListener wboxListener;
    private PriNetVhsmFileListener vhsmLibListener;
    private Context context;
    private static final int FLAG_NOT_CHANGE = 0;
    private static final int FLAG_CHANGE = 1;
    private static int wboxChangeFlag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetVhsmFileListener getInstance() {
        if (instance != null) return instance;
        Class<NetVhsmFileListener> clazz = NetVhsmFileListener.class;
        synchronized (NetVhsmFileListener.class) {
            if (instance != null) return instance;
            instance = new NetVhsmFileListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NetVhsmFileListener() {
        if (this.randListener == null) {
            this.randListener = new PriNetVhsmFileListener(VhsmFileHandle.getInstance().getRandfilePath());
        }
        if (this.wboxListener == null) {
            this.wboxListener = new PriNetVhsmFileListener(VhsmFileHandle.getInstance().getWboxfilePath());
        }
        if (this.vhsmLibListener == null) {
            this.vhsmLibListener = new PriNetVhsmFileListener(VhsmFileHandle.getInstance().getVhsmlibfilePath());
        }
    }

    public void startObserver(Context context) {
        this.context = context;
        this.randListener.startWatching();
        this.wboxListener.startWatching();
        this.vhsmLibListener.startWatching();
    }

    static void setWboxChange() {
        wboxChangeFlag = 1;
    }

    static int getWboxChangeFlag() {
        return wboxChangeFlag;
    }

    static void setWboxNotChange() {
        wboxChangeFlag = 0;
    }

    private static void killSelf(Context context, int event, String path) {
        Log.e((String)TAG, (String)("killSelf event = " + event + " path = " + path));
        Intent intent = new Intent();
        intent.setClass(context, NetVhsmService.class);
        context.startService(intent);
        Process.killProcess((int)Process.myPid());
    }

    static {
        wboxChangeFlag = 0;
    }

    class PriNetVhsmFileListener
    extends FileObserver {
        private String path;
        private int startWatchFlag;

        public PriNetVhsmFileListener(String path) {
            super(path);
            this.startWatchFlag = 0;
            this.path = path;
        }

        public void onEvent(int event, String path) {
            if (event == 2) {
                SystemClock.sleep((long)100L);
                if (NetVhsmFileListener.getWboxChangeFlag() == 0) {
                    NetVhsmFileListener.killSelf(NetVhsmFileListener.this.context, event, this.path);
                } else {
                    NetVhsmFileListener.setWboxNotChange();
                }
            } else if (event == 512 || event == 1024) {
                NetVhsmFileListener.killSelf(NetVhsmFileListener.this.context, event, this.path);
            }
        }

        public void startWatching() {
            File file = new File(this.path);
            if (file.exists()) {
                if (this.startWatchFlag == 0) {
                    this.startWatchFlag = 1;
                    super.startWatching();
                }
            } else if (this.startWatchFlag == 1) {
                this.stopWatching();
            }
        }

        public void stopWatching() {
            this.startWatchFlag = 0;
            super.stopWatching();
        }
    }
}

